package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.OptionalInt;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OptionalWithNullable}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOptionalWithNullable.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableOptionalWithNullable.of()}.
 */
@Generated(from = "OptionalWithNullable", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableOptionalWithNullable implements OptionalWithNullable {
  private final @Nullable String javaOptional;
  private final @Nullable Integer javaOptionalInt;
  private final @Nullable Integer javaOptionalInteger;
  private final Optional<String> guavaOptional;
  private final @Nullable String javaOptionalStringParameter;

  private ImmutableOptionalWithNullable(java.util.Optional<String> javaOptionalStringParameter) {
    this.javaOptionalStringParameter = javaOptionalStringParameter.orElse(null);
    this.javaOptional = null;
    this.javaOptionalInt = null;
    this.javaOptionalInteger = null;
    this.guavaOptional = Optional.absent();
  }

  private ImmutableOptionalWithNullable(@Nullable String javaOptionalStringParameter) {
    this.javaOptionalStringParameter = javaOptionalStringParameter;
    this.javaOptional = null;
    this.javaOptionalInt = null;
    this.javaOptionalInteger = null;
    this.guavaOptional = Optional.absent();
  }

  private ImmutableOptionalWithNullable(
      @Nullable String javaOptional,
      @Nullable Integer javaOptionalInt,
      @Nullable Integer javaOptionalInteger,
      Optional<String> guavaOptional,
      @Nullable String javaOptionalStringParameter) {
    this.javaOptional = javaOptional;
    this.javaOptionalInt = javaOptionalInt;
    this.javaOptionalInteger = javaOptionalInteger;
    this.guavaOptional = guavaOptional;
    this.javaOptionalStringParameter = javaOptionalStringParameter;
  }

  /**
   * @return The value of the {@code javaOptional} attribute
   */
  @Override
  public java.util.Optional<String> getJavaOptional() {
    return java.util.Optional.ofNullable(javaOptional);
  }

  /**
   * @return The value of the {@code javaOptionalInt} attribute
   */
  @Override
  public OptionalInt getJavaOptionalInt() {
    return javaOptionalInt != null
        ? OptionalInt.of(javaOptionalInt)
        : OptionalInt.empty();
  }

  /**
   * @return The value of the {@code javaOptionalInteger} attribute
   */
  @Override
  public java.util.Optional<Integer> getJavaOptionalInteger() {
    return java.util.Optional.ofNullable(javaOptionalInteger);
  }

  /**
   * @return The value of the {@code guavaOptional} attribute
   */
  @Override
  public Optional<String> getGuavaOptional() {
    return guavaOptional;
  }

  /**
   * @return The value of the {@code javaOptionalStringParameter} attribute
   */
  @Override
  public java.util.Optional<String> getJavaOptionalStringParameter() {
    return java.util.Optional.ofNullable(javaOptionalStringParameter);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionalWithNullable#getJavaOptional() javaOptional} attribute.
   * @param value The value for javaOptional, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithNullable withJavaOptional(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.javaOptional, newValue)) return this;
    return new ImmutableOptionalWithNullable(
        newValue,
        this.javaOptionalInt,
        this.javaOptionalInteger,
        this.guavaOptional,
        this.javaOptionalStringParameter);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionalWithNullable#getJavaOptional() javaOptional} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for javaOptional
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithNullable withJavaOptional(java.util.Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.javaOptional, value)) return this;
    return new ImmutableOptionalWithNullable(
        value,
        this.javaOptionalInt,
        this.javaOptionalInteger,
        this.guavaOptional,
        this.javaOptionalStringParameter);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionalWithNullable#getJavaOptionalInt() javaOptionalInt} attribute.
   * @param value The value for javaOptionalInt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithNullable withJavaOptionalInt(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.javaOptionalInt, newValue)) return this;
    return new ImmutableOptionalWithNullable(
        this.javaOptional,
        newValue,
        this.javaOptionalInteger,
        this.guavaOptional,
        this.javaOptionalStringParameter);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionalWithNullable#getJavaOptionalInt() javaOptionalInt} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for javaOptionalInt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithNullable withJavaOptionalInt(OptionalInt optional) {
    @Nullable Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.javaOptionalInt, value)) return this;
    return new ImmutableOptionalWithNullable(
        this.javaOptional,
        value,
        this.javaOptionalInteger,
        this.guavaOptional,
        this.javaOptionalStringParameter);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionalWithNullable#getJavaOptionalInteger() javaOptionalInteger} attribute.
   * @param value The value for javaOptionalInteger, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithNullable withJavaOptionalInteger(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.javaOptionalInteger, newValue)) return this;
    return new ImmutableOptionalWithNullable(
        this.javaOptional,
        this.javaOptionalInt,
        newValue,
        this.guavaOptional,
        this.javaOptionalStringParameter);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionalWithNullable#getJavaOptionalInteger() javaOptionalInteger} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for javaOptionalInteger
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithNullable withJavaOptionalInteger(java.util.Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.javaOptionalInteger, value)) return this;
    return new ImmutableOptionalWithNullable(
        this.javaOptional,
        this.javaOptionalInt,
        value,
        this.guavaOptional,
        this.javaOptionalStringParameter);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionalWithNullable#getGuavaOptional() guavaOptional} attribute.
   * @param value The value for guavaOptional, {@code null} is accepted as {@code com.google.common.base.Optional.absent()}
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithNullable withGuavaOptional(@Nullable String value) {
    Optional<String> newValue = Optional.fromNullable(value);
    if (this.guavaOptional.equals(newValue)) return this;
    return new ImmutableOptionalWithNullable(
        this.javaOptional,
        this.javaOptionalInt,
        this.javaOptionalInteger,
        newValue,
        this.javaOptionalStringParameter);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionalWithNullable#getGuavaOptional() guavaOptional} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for guavaOptional
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithNullable withGuavaOptional(Optional<String> optional) {
    Optional<String> value = optional;
    if (this.guavaOptional.equals(value)) return this;
    return new ImmutableOptionalWithNullable(
        this.javaOptional,
        this.javaOptionalInt,
        this.javaOptionalInteger,
        value,
        this.javaOptionalStringParameter);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionalWithNullable#getJavaOptionalStringParameter() javaOptionalStringParameter} attribute.
   * @param value The value for javaOptionalStringParameter, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithNullable withJavaOptionalStringParameter(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.javaOptionalStringParameter, newValue)) return this;
    return new ImmutableOptionalWithNullable(this.javaOptional, this.javaOptionalInt, this.javaOptionalInteger, this.guavaOptional, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionalWithNullable#getJavaOptionalStringParameter() javaOptionalStringParameter} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for javaOptionalStringParameter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithNullable withJavaOptionalStringParameter(java.util.Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.javaOptionalStringParameter, value)) return this;
    return new ImmutableOptionalWithNullable(this.javaOptional, this.javaOptionalInt, this.javaOptionalInteger, this.guavaOptional, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOptionalWithNullable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOptionalWithNullable
        && equalTo(0, (ImmutableOptionalWithNullable) another);
  }

  private boolean equalTo(int synthetic, ImmutableOptionalWithNullable another) {
    return Objects.equals(javaOptional, another.javaOptional)
        && Objects.equals(javaOptionalInt, another.javaOptionalInt)
        && Objects.equals(javaOptionalInteger, another.javaOptionalInteger)
        && guavaOptional.equals(another.guavaOptional)
        && Objects.equals(javaOptionalStringParameter, another.javaOptionalStringParameter);
  }

  /**
   * Computes a hash code from attributes: {@code javaOptional}, {@code javaOptionalInt}, {@code javaOptionalInteger}, {@code guavaOptional}, {@code javaOptionalStringParameter}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(javaOptional);
    h += (h << 5) + Objects.hashCode(javaOptionalInt);
    h += (h << 5) + Objects.hashCode(javaOptionalInteger);
    h += (h << 5) + guavaOptional.hashCode();
    h += (h << 5) + Objects.hashCode(javaOptionalStringParameter);
    return h;
  }

  /**
   * Prints the immutable value {@code OptionalWithNullable} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("OptionalWithNullable")
        .omitNullValues()
        .add("javaOptional", javaOptional)
        .add("javaOptionalInt", javaOptionalInt)
        .add("javaOptionalInteger", javaOptionalInteger)
        .add("guavaOptional", guavaOptional.orNull())
        .add("javaOptionalStringParameter", javaOptionalStringParameter)
        .toString();
  }

  /**
   * Construct a new immutable {@code OptionalWithNullable} instance.
   * @param javaOptionalStringParameter The value for the {@code javaOptionalStringParameter} attribute
   * @return An immutable OptionalWithNullable instance
   */
  public static ImmutableOptionalWithNullable of(java.util.Optional<String> javaOptionalStringParameter) {
    return new ImmutableOptionalWithNullable(javaOptionalStringParameter);
  }

  /**
   * Construct a new immutable {@code OptionalWithNullable} instance.
   * @param javaOptionalStringParameter The value for the {@code javaOptionalStringParameter} attribute
   * @return An immutable OptionalWithNullable instance
   */
  public static ImmutableOptionalWithNullable of(@Nullable String javaOptionalStringParameter) {
    return new ImmutableOptionalWithNullable(javaOptionalStringParameter);
  }

  /**
   * Creates an immutable copy of a {@link OptionalWithNullable} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OptionalWithNullable instance
   */
  public static ImmutableOptionalWithNullable copyOf(OptionalWithNullable instance) {
    if (instance instanceof ImmutableOptionalWithNullable) {
      return (ImmutableOptionalWithNullable) instance;
    }
    return ImmutableOptionalWithNullable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOptionalWithNullable ImmutableOptionalWithNullable}.
   * <pre>
   * ImmutableOptionalWithNullable.builder()
   *    .javaOptional(String) // optional {@link OptionalWithNullable#getJavaOptional() javaOptional}
   *    .javaOptionalInt(int) // optional {@link OptionalWithNullable#getJavaOptionalInt() javaOptionalInt}
   *    .javaOptionalInteger(Integer) // optional {@link OptionalWithNullable#getJavaOptionalInteger() javaOptionalInteger}
   *    .guavaOptional(String) // optional {@link OptionalWithNullable#getGuavaOptional() guavaOptional}
   *    .javaOptionalStringParameter(String) // optional {@link OptionalWithNullable#getJavaOptionalStringParameter() javaOptionalStringParameter}
   *    .build();
   * </pre>
   * @return A new ImmutableOptionalWithNullable builder
   */
  public static ImmutableOptionalWithNullable.Builder builder() {
    return new ImmutableOptionalWithNullable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOptionalWithNullable ImmutableOptionalWithNullable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OptionalWithNullable", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String javaOptional;
    private @Nullable Integer javaOptionalInt;
    private @Nullable Integer javaOptionalInteger;
    private Optional<String> guavaOptional = Optional.absent();
    private @Nullable String javaOptionalStringParameter;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OptionalWithNullable} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(OptionalWithNullable instance) {
      Objects.requireNonNull(instance, "instance");
      java.util.Optional<String> javaOptionalOptional = instance.getJavaOptional();
      if (javaOptionalOptional.isPresent()) {
        javaOptional(javaOptionalOptional);
      }
      OptionalInt javaOptionalIntOptional = instance.getJavaOptionalInt();
      if (javaOptionalIntOptional.isPresent()) {
        javaOptionalInt(javaOptionalIntOptional);
      }
      java.util.Optional<Integer> javaOptionalIntegerOptional = instance.getJavaOptionalInteger();
      if (javaOptionalIntegerOptional.isPresent()) {
        javaOptionalInteger(javaOptionalIntegerOptional);
      }
      Optional<String> guavaOptionalOptional = instance.getGuavaOptional();
      if (guavaOptionalOptional.isPresent()) {
        guavaOptional(guavaOptionalOptional);
      }
      java.util.Optional<String> javaOptionalStringParameterOptional = instance.getJavaOptionalStringParameter();
      if (javaOptionalStringParameterOptional.isPresent()) {
        javaOptionalStringParameter(javaOptionalStringParameterOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithNullable#getJavaOptional() javaOptional} to javaOptional.
     * @param javaOptional The value for javaOptional, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder javaOptional(@Nullable String javaOptional) {
      this.javaOptional = javaOptional;
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithNullable#getJavaOptional() javaOptional} to javaOptional.
     * @param javaOptional The value for javaOptional
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder javaOptional(java.util.Optional<String> javaOptional) {
      this.javaOptional = javaOptional.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithNullable#getJavaOptionalInt() javaOptionalInt} to javaOptionalInt.
     * @param javaOptionalInt The value for javaOptionalInt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder javaOptionalInt(int javaOptionalInt) {
      this.javaOptionalInt = javaOptionalInt;
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithNullable#getJavaOptionalInt() javaOptionalInt} to javaOptionalInt.
     * @param javaOptionalInt The value for javaOptionalInt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder javaOptionalInt(OptionalInt javaOptionalInt) {
      this.javaOptionalInt = javaOptionalInt.isPresent() ? javaOptionalInt.getAsInt() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithNullable#getJavaOptionalInteger() javaOptionalInteger} to javaOptionalInteger.
     * @param javaOptionalInteger The value for javaOptionalInteger, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder javaOptionalInteger(@Nullable Integer javaOptionalInteger) {
      this.javaOptionalInteger = javaOptionalInteger;
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithNullable#getJavaOptionalInteger() javaOptionalInteger} to javaOptionalInteger.
     * @param javaOptionalInteger The value for javaOptionalInteger
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder javaOptionalInteger(java.util.Optional<Integer> javaOptionalInteger) {
      this.javaOptionalInteger = javaOptionalInteger.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithNullable#getGuavaOptional() guavaOptional} to guavaOptional.
     * @param guavaOptional The value for guavaOptional, {@code null} is accepted as {@code com.google.common.base.Optional.absent()}
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder guavaOptional(@Nullable String guavaOptional) {
      this.guavaOptional = Optional.fromNullable(guavaOptional);
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithNullable#getGuavaOptional() guavaOptional} to guavaOptional.
     * @param guavaOptional The value for guavaOptional
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder guavaOptional(Optional<String> guavaOptional) {
      this.guavaOptional = guavaOptional;
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithNullable#getJavaOptionalStringParameter() javaOptionalStringParameter} to javaOptionalStringParameter.
     * @param javaOptionalStringParameter The value for javaOptionalStringParameter, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder javaOptionalStringParameter(@Nullable String javaOptionalStringParameter) {
      this.javaOptionalStringParameter = javaOptionalStringParameter;
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithNullable#getJavaOptionalStringParameter() javaOptionalStringParameter} to javaOptionalStringParameter.
     * @param javaOptionalStringParameter The value for javaOptionalStringParameter
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder javaOptionalStringParameter(java.util.Optional<String> javaOptionalStringParameter) {
      this.javaOptionalStringParameter = javaOptionalStringParameter.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableOptionalWithNullable ImmutableOptionalWithNullable}.
     * @return An immutable instance of OptionalWithNullable
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOptionalWithNullable build() {
      return new ImmutableOptionalWithNullable(
          javaOptional,
          javaOptionalInt,
          javaOptionalInteger,
          guavaOptional,
          javaOptionalStringParameter);
    }
  }
}
