package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SpecifiedExceptionWithNamesConstructor}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSpecifiedExceptionWithNamesConstructor.builder()}.
 */
@Generated(from = "SpecifiedExceptionWithNamesConstructor", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSpecifiedExceptionWithNamesConstructor
    implements SpecifiedExceptionWithNamesConstructor {
  private final int someRequiredInteger;
  private final String someRequiredString;

  private ImmutableSpecifiedExceptionWithNamesConstructor(int someRequiredInteger, String someRequiredString) {
    this.someRequiredInteger = someRequiredInteger;
    this.someRequiredString = someRequiredString;
  }

  /**
   * @return The value of the {@code someRequiredInteger} attribute
   */
  @Override
  public int getSomeRequiredInteger() {
    return someRequiredInteger;
  }

  /**
   * @return The value of the {@code someRequiredString} attribute
   */
  @Override
  public String getSomeRequiredString() {
    return someRequiredString;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SpecifiedExceptionWithNamesConstructor#getSomeRequiredInteger() someRequiredInteger} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for someRequiredInteger
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSpecifiedExceptionWithNamesConstructor withSomeRequiredInteger(int value) {
    if (this.someRequiredInteger == value) return this;
    return new ImmutableSpecifiedExceptionWithNamesConstructor(value, this.someRequiredString);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SpecifiedExceptionWithNamesConstructor#getSomeRequiredString() someRequiredString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for someRequiredString
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSpecifiedExceptionWithNamesConstructor withSomeRequiredString(String value) {
    String newValue = Objects.requireNonNull(value, "someRequiredString");
    if (this.someRequiredString.equals(newValue)) return this;
    return new ImmutableSpecifiedExceptionWithNamesConstructor(this.someRequiredInteger, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSpecifiedExceptionWithNamesConstructor} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSpecifiedExceptionWithNamesConstructor
        && equalTo(0, (ImmutableSpecifiedExceptionWithNamesConstructor) another);
  }

  private boolean equalTo(int synthetic, ImmutableSpecifiedExceptionWithNamesConstructor another) {
    return someRequiredInteger == another.someRequiredInteger
        && someRequiredString.equals(another.someRequiredString);
  }

  /**
   * Computes a hash code from attributes: {@code someRequiredInteger}, {@code someRequiredString}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + someRequiredInteger;
    h += (h << 5) + someRequiredString.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SpecifiedExceptionWithNamesConstructor} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SpecifiedExceptionWithNamesConstructor")
        .omitNullValues()
        .add("someRequiredInteger", someRequiredInteger)
        .add("someRequiredString", someRequiredString)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SpecifiedExceptionWithNamesConstructor} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SpecifiedExceptionWithNamesConstructor instance
   */
  public static ImmutableSpecifiedExceptionWithNamesConstructor copyOf(SpecifiedExceptionWithNamesConstructor instance) {
    if (instance instanceof ImmutableSpecifiedExceptionWithNamesConstructor) {
      return (ImmutableSpecifiedExceptionWithNamesConstructor) instance;
    }
    return ImmutableSpecifiedExceptionWithNamesConstructor.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSpecifiedExceptionWithNamesConstructor ImmutableSpecifiedExceptionWithNamesConstructor}.
   * <pre>
   * ImmutableSpecifiedExceptionWithNamesConstructor.builder()
   *    .someRequiredInteger(int) // required {@link SpecifiedExceptionWithNamesConstructor#getSomeRequiredInteger() someRequiredInteger}
   *    .someRequiredString(String) // required {@link SpecifiedExceptionWithNamesConstructor#getSomeRequiredString() someRequiredString}
   *    .build();
   * </pre>
   * @return A new ImmutableSpecifiedExceptionWithNamesConstructor builder
   */
  public static ImmutableSpecifiedExceptionWithNamesConstructor.Builder builder() {
    return new ImmutableSpecifiedExceptionWithNamesConstructor.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSpecifiedExceptionWithNamesConstructor ImmutableSpecifiedExceptionWithNamesConstructor}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SpecifiedExceptionWithNamesConstructor", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SOME_REQUIRED_INTEGER = 0x1L;
    private static final long INIT_BIT_SOME_REQUIRED_STRING = 0x2L;
    private long initBits = 0x3L;

    private int someRequiredInteger;
    private @Nullable String someRequiredString;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SpecifiedExceptionWithNamesConstructor} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SpecifiedExceptionWithNamesConstructor instance) {
      Objects.requireNonNull(instance, "instance");
      someRequiredInteger(instance.getSomeRequiredInteger());
      someRequiredString(instance.getSomeRequiredString());
      return this;
    }

    /**
     * Initializes the value for the {@link SpecifiedExceptionWithNamesConstructor#getSomeRequiredInteger() someRequiredInteger} attribute.
     * @param someRequiredInteger The value for someRequiredInteger 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder someRequiredInteger(int someRequiredInteger) {
      this.someRequiredInteger = someRequiredInteger;
      initBits &= ~INIT_BIT_SOME_REQUIRED_INTEGER;
      return this;
    }

    /**
     * Initializes the value for the {@link SpecifiedExceptionWithNamesConstructor#getSomeRequiredString() someRequiredString} attribute.
     * @param someRequiredString The value for someRequiredString 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder someRequiredString(String someRequiredString) {
      this.someRequiredString = Objects.requireNonNull(someRequiredString, "someRequiredString");
      initBits &= ~INIT_BIT_SOME_REQUIRED_STRING;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSpecifiedExceptionWithNamesConstructor ImmutableSpecifiedExceptionWithNamesConstructor}.
     * @return An immutable instance of SpecifiedExceptionWithNamesConstructor
     * @throws org.immutables.fixture.style.SpecifiedExceptionWithNamesConstructor.Exc if any required attributes are missing
     */
    public ImmutableSpecifiedExceptionWithNamesConstructor build() {
      checkRequiredAttributes();
      return new ImmutableSpecifiedExceptionWithNamesConstructor(someRequiredInteger, someRequiredString);
    }

    private boolean someRequiredIntegerIsSet() {
      return (initBits & INIT_BIT_SOME_REQUIRED_INTEGER) == 0;
    }

    private boolean someRequiredStringIsSet() {
      return (initBits & INIT_BIT_SOME_REQUIRED_STRING) == 0;
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new SpecifiedExceptionWithNamesConstructor.Exc(missingRequiredAttributesNames());
      }
    }

    private String[] missingRequiredAttributesNames() {
      String[] attributes = new String[2];
      @Var int c = 0;
      if (!someRequiredIntegerIsSet()) attributes[c++] = "someRequiredInteger";
      if (!someRequiredStringIsSet()) attributes[c++] = "someRequiredString";
      return Arrays.copyOf(attributes, c);
    }
  }
}
