package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StagedBuilderExtendingBuilder}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new StagedBuilderExtendingBuilder.Builder()}.
 */
@Generated(from = "StagedBuilderExtendingBuilder", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableStagedBuilderExtendingBuilder
    implements StagedBuilderExtendingBuilder {
  private final String name;
  private final int age;

  private ImmutableStagedBuilderExtendingBuilder(String name, int age) {
    this.name = name;
    this.age = age;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code age} attribute
   */
  @Override
  public int age() {
    return age;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StagedBuilderExtendingBuilder#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStagedBuilderExtendingBuilder withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableStagedBuilderExtendingBuilder(newValue, this.age);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StagedBuilderExtendingBuilder#age() age} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for age
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStagedBuilderExtendingBuilder withAge(int value) {
    if (this.age == value) return this;
    return new ImmutableStagedBuilderExtendingBuilder(this.name, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStagedBuilderExtendingBuilder} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStagedBuilderExtendingBuilder
        && equalTo(0, (ImmutableStagedBuilderExtendingBuilder) another);
  }

  private boolean equalTo(int synthetic, ImmutableStagedBuilderExtendingBuilder another) {
    return name.equals(another.name)
        && age == another.age;
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code age}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + age;
    return h;
  }

  /**
   * Prints the immutable value {@code StagedBuilderExtendingBuilder} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StagedBuilderExtendingBuilder")
        .omitNullValues()
        .add("name", name)
        .add("age", age)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link StagedBuilderExtendingBuilder} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StagedBuilderExtendingBuilder instance
   */
  public static ImmutableStagedBuilderExtendingBuilder copyOf(StagedBuilderExtendingBuilder instance) {
    if (instance instanceof ImmutableStagedBuilderExtendingBuilder) {
      return (ImmutableStagedBuilderExtendingBuilder) instance;
    }
    return new StagedBuilderExtendingBuilder.Builder()
        .name(instance.name())
        .age(instance.age())
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableStagedBuilderExtendingBuilder ImmutableStagedBuilderExtendingBuilder}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StagedBuilderExtendingBuilder", generator = "Immutables")
  @NotThreadSafe
  public static class Builder implements NameBuildStage, AgeBuildStage, BuildFinal {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_AGE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private int age;

    /**
     * Creates a builder for {@link ImmutableStagedBuilderExtendingBuilder ImmutableStagedBuilderExtendingBuilder} instances.
     * <pre>
     * new StagedBuilderExtendingBuilder.Builder()
     *    .name(String) // required {@link StagedBuilderExtendingBuilder#name() name}
     *    .age(int) // required {@link StagedBuilderExtendingBuilder#age() age}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof StagedBuilderExtendingBuilder.Builder)) {
        throw new UnsupportedOperationException("Use: new StagedBuilderExtendingBuilder.Builder()");
      }
    }

    /**
     * Initializes the value for the {@link StagedBuilderExtendingBuilder#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final StagedBuilderExtendingBuilder.Builder name(String name) {
      checkNotIsSet(nameIsSet(), "name");
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return (StagedBuilderExtendingBuilder.Builder) this;
    }

    /**
     * Initializes the value for the {@link StagedBuilderExtendingBuilder#age() age} attribute.
     * @param age The value for age 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final StagedBuilderExtendingBuilder.Builder age(int age) {
      checkNotIsSet(ageIsSet(), "age");
      this.age = age;
      initBits &= ~INIT_BIT_AGE;
      return (StagedBuilderExtendingBuilder.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableStagedBuilderExtendingBuilder ImmutableStagedBuilderExtendingBuilder}.
     * @return An immutable instance of StagedBuilderExtendingBuilder
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStagedBuilderExtendingBuilder build() {
      checkRequiredAttributes();
      return new ImmutableStagedBuilderExtendingBuilder(name, age);
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private boolean ageIsSet() {
      return (initBits & INIT_BIT_AGE) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of StagedBuilderExtendingBuilder is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!nameIsSet()) attributes.add("name");
      if (!ageIsSet()) attributes.add("age");
      return "Cannot build StagedBuilderExtendingBuilder, some of required attributes are not set " + attributes;
    }
  }

  @Generated(from = "StagedBuilderExtendingBuilder", generator = "Immutables")
  public interface NameBuildStage {
    /**
     * Initializes the value for the {@link StagedBuilderExtendingBuilder#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    AgeBuildStage name(String name);
  }

  @Generated(from = "StagedBuilderExtendingBuilder", generator = "Immutables")
  public interface AgeBuildStage {
    /**
     * Initializes the value for the {@link StagedBuilderExtendingBuilder#age() age} attribute.
     * @param age The value for age 
     * @return {@code this} builder for use in a chained invocation
     */
    BuildFinal age(int age);
  }

  @Generated(from = "StagedBuilderExtendingBuilder", generator = "Immutables")
  public interface BuildFinal {

    /**
     * Builds a new {@link ImmutableStagedBuilderExtendingBuilder ImmutableStagedBuilderExtendingBuilder}.
     * @return An immutable instance of StagedBuilderExtendingBuilder
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    ImmutableStagedBuilderExtendingBuilder build();
  }
}
