package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TransientDerivedFields.Tr}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTr.builder()}.
 */
@Generated(from = "TransientDerivedFields.Tr", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTr implements TransientDerivedFields.Tr {
  private transient final int def;

  private ImmutableTr(ImmutableTr.Builder builder) {
    this.def = TransientDerivedFields.Tr.super.def();
  }

  /**
   * @return The computed-at-construction value of the {@code def} attribute
   */
  @Override
  public int def() {
    return def;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTr} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTr
        && equalTo(0, (ImmutableTr) another);
  }

  private boolean equalTo(int synthetic, ImmutableTr another) {
    return def == another.def;
  }

  /**
   * Computes a hash code from attributes: {@code def}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + def;
    return h;
  }

  /**
   * Prints the immutable value {@code Tr} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Tr")
        .omitNullValues()
        .add("def", def)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link TransientDerivedFields.Tr} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Tr instance
   */
  public static ImmutableTr copyOf(TransientDerivedFields.Tr instance) {
    if (instance instanceof ImmutableTr) {
      return (ImmutableTr) instance;
    }
    return ImmutableTr.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTr ImmutableTr}.
   * <pre>
   * ImmutableTr.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableTr builder
   */
  public static ImmutableTr.Builder builder() {
    return new ImmutableTr.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTr ImmutableTr}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TransientDerivedFields.Tr", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Tr} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TransientDerivedFields.Tr instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableTr ImmutableTr}.
     * @return An immutable instance of Tr
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTr build() {
      return new ImmutableTr(this);
    }
  }
}
