package org.immutables.fixture.style;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UnderrideObjectMethods}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUnderrideObjectMethods.builder()}.
 */
@Generated(from = "UnderrideObjectMethods", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUnderrideObjectMethods
    implements UnderrideObjectMethods {
  private final int a;

  private ImmutableUnderrideObjectMethods(int a) {
    this.a = a;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UnderrideObjectMethods#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUnderrideObjectMethods withA(int value) {
    if (this.a == value) return this;
    return new ImmutableUnderrideObjectMethods(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUnderrideObjectMethods} that have equal attribute values or
   * as defined by custom equality check method in supertype.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return another instanceof ImmutableUnderrideObjectMethods
        && UnderrideObjectMethods.super.equalTo((ImmutableUnderrideObjectMethods)another);
  }

  /**
   * Returns a hashCode computed by customized in supertype implementation.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return UnderrideObjectMethods.super.hash();
  }

  /**
   * Prints the immutable value {@code UnderrideObjectMethods} delegating to a customized method.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return UnderrideObjectMethods.super.stringify();
  }

  /**
   * Creates an immutable copy of a {@link UnderrideObjectMethods} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UnderrideObjectMethods instance
   */
  public static ImmutableUnderrideObjectMethods copyOf(UnderrideObjectMethods instance) {
    if (instance instanceof ImmutableUnderrideObjectMethods) {
      return (ImmutableUnderrideObjectMethods) instance;
    }
    return ImmutableUnderrideObjectMethods.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUnderrideObjectMethods ImmutableUnderrideObjectMethods}.
   * <pre>
   * ImmutableUnderrideObjectMethods.builder()
   *    .a(int) // required {@link UnderrideObjectMethods#a() a}
   *    .build();
   * </pre>
   * @return A new ImmutableUnderrideObjectMethods builder
   */
  public static ImmutableUnderrideObjectMethods.Builder builder() {
    return new ImmutableUnderrideObjectMethods.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUnderrideObjectMethods ImmutableUnderrideObjectMethods}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UnderrideObjectMethods", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private long initBits = 0x1L;

    private int a;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableUnderrideObjectMethods} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableUnderrideObjectMethods instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.aIsSet()) {
        a(instance.a());
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnderrideObjectMethods} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UnderrideObjectMethods instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableUnderrideObjectMethods) {
        return from((ModifiableUnderrideObjectMethods) instance);
      }
      a(instance.a());
      return this;
    }

    /**
     * Initializes the value for the {@link UnderrideObjectMethods#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUnderrideObjectMethods ImmutableUnderrideObjectMethods}.
     * @return An immutable instance of UnderrideObjectMethods
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUnderrideObjectMethods build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUnderrideObjectMethods(a);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build UnderrideObjectMethods, some of required attributes are not set " + attributes;
    }
  }
}
