package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * A modifiable implementation of the {@link LightOnAnnotations LightOnAnnotations} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableLightOnAnnotations is not thread-safe</em>
 * @param <X> generic parameter X
 * @see ImmutableLightOnAnnotations
 */
public final class ModifiableLightOnAnnotations<X>
    implements LightOnAnnotations<X> {
  private static final long INIT_BIT_A = 0x1L;
  private long initBits = 0x1L;

  private int a;
  private Optional<X> x = Optional.empty();

  private ModifiableLightOnAnnotations() {}

  /**
   * Construct a modifiable instance of {@code LightOnAnnotations}.
   * @param <X> generic parameter X
   * @return A new modifiable instance
   */
  public static <X> ModifiableLightOnAnnotations<X> create() {
    return new ModifiableLightOnAnnotations<>();
  }

  /**
   * @return value of {@code a} attribute
   */
  @Override
  public final int a() {
    if (!aIsSet()) {
      checkRequiredAttributes();
    }
    return a;
  }

  /**
   * @return value of {@code x} attribute
   */
  @Override
  public final Optional<X> x() {
    return x;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableLightOnAnnotations<X> clear() {
    initBits = 0x1L;
    a = 0;
    x = Optional.empty();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link LightOnAnnotations} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableLightOnAnnotations<X> from(LightOnAnnotations<X> instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableLightOnAnnotations<?>) {
      from((ModifiableLightOnAnnotations<X>) instance);
      return this;
    }
    setA(instance.a());
    Optional<X> xOptional = instance.x();
    if (xOptional.isPresent()) {
      setX(xOptional);
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link LightOnAnnotations} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableLightOnAnnotations<X> from(ModifiableLightOnAnnotations<X> instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.aIsSet()) {
      setA(instance.a());
    }
    Optional<X> xOptional = instance.x();
    if (xOptional.isPresent()) {
      setX(xOptional);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link LightOnAnnotations#a() a} attribute.
   * @param a The value for a
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableLightOnAnnotations<X> setA(int a) {
    this.a = a;
    initBits &= ~INIT_BIT_A;
    return this;
  }

  /**
   * Assigns a <i>present</i> value for the optional {@link LightOnAnnotations#x() x} attribute.
   * @param x A value for x
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableLightOnAnnotations<X> setX(X x) {
    this.x = Optional.of(x);
    return this;
  }

  /**
   * Assigns an optional value for {@link LightOnAnnotations#x() x}.
   * @param x A value for x
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableLightOnAnnotations<X> setX(Optional<X> x) {
    this.x = Objects.requireNonNull(x, "x");
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link LightOnAnnotations#a() a} is set.
   * @return {@code true} if set
   */
  public final boolean aIsSet() {
    return (initBits & INIT_BIT_A) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableLightOnAnnotations<X> unsetA() {
    initBits |= INIT_BIT_A;
    a = 0;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!aIsSet()) attributes.add("a");
    return "LightOnAnnotations is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableLightOnAnnotations ImmutableLightOnAnnotations}.
   * @return An immutable instance of LightOnAnnotations
   */
  public final ImmutableLightOnAnnotations<X> toImmutable() {
    checkRequiredAttributes();
    return ImmutableLightOnAnnotations.<X>copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableLightOnAnnotations<?>} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableLightOnAnnotations<?>)) return false;
    ModifiableLightOnAnnotations<?> other = (ModifiableLightOnAnnotations<?>) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableLightOnAnnotations<?> another) {
    return a == another.a
        && Objects.equals(x, another.x);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code x}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + x.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code LightOnAnnotations}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableLightOnAnnotations")
        .add("a", aIsSet() ? a() : "?")
        .add("x", x())
        .toString();
  }
}
