package org.immutables.fixture.style.depl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DepluralizeMergeDictionary.Inner}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableInner.builder()}.
 */
@Generated(from = "DepluralizeMergeDictionary.Inner", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableInner
    implements DepluralizeMergeDictionary.Inner {
  private final ImmutableList<String> feet;
  private final ImmutableSet<String> boats;
  private final ImmutableMap<String, String> people;
  private final ImmutableMultimap<String, String> peopleRepublics;
  private final ImmutableList<Integer> feetPeople;
  private final ImmutableMultiset<Boolean> goods;

  private ImmutableInner(
      ImmutableList<String> feet,
      ImmutableSet<String> boats,
      ImmutableMap<String, String> people,
      ImmutableMultimap<String, String> peopleRepublics,
      ImmutableList<Integer> feetPeople,
      ImmutableMultiset<Boolean> goods) {
    this.feet = feet;
    this.boats = boats;
    this.people = people;
    this.peopleRepublics = peopleRepublics;
    this.feetPeople = feetPeople;
    this.goods = goods;
  }

  /**
   * @return The value of the {@code feet} attribute
   */
  @Override
  public ImmutableList<String> feet() {
    return feet;
  }

  /**
   * @return The value of the {@code boats} attribute
   */
  @Override
  public ImmutableSet<String> boats() {
    return boats;
  }

  /**
   * @return The value of the {@code people} attribute
   */
  @Override
  public ImmutableMap<String, String> people() {
    return people;
  }

  /**
   * @return The value of the {@code peopleRepublics} attribute
   */
  @Override
  public ImmutableMultimap<String, String> peopleRepublics() {
    return peopleRepublics;
  }

  /**
   * @return The value of the {@code feetPeople} attribute
   */
  @Override
  public ImmutableList<Integer> feetPeople() {
    return feetPeople;
  }

  /**
   * @return The value of the {@code goods} attribute
   */
  @Override
  public ImmutableMultiset<Boolean> goods() {
    return goods;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DepluralizeMergeDictionary.Inner#feet() feet}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInner withFeet(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableInner(newValue, this.boats, this.people, this.peopleRepublics, this.feetPeople, this.goods);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DepluralizeMergeDictionary.Inner#feet() feet}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of feet elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInner withFeet(Iterable<String> elements) {
    if (this.feet == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableInner(newValue, this.boats, this.people, this.peopleRepublics, this.feetPeople, this.goods);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DepluralizeMergeDictionary.Inner#boats() boats}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInner withBoats(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableInner(this.feet, newValue, this.people, this.peopleRepublics, this.feetPeople, this.goods);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DepluralizeMergeDictionary.Inner#boats() boats}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of boats elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInner withBoats(Iterable<String> elements) {
    if (this.boats == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableInner(this.feet, newValue, this.people, this.peopleRepublics, this.feetPeople, this.goods);
  }

  /**
   * Copy the current immutable object by replacing the {@link DepluralizeMergeDictionary.Inner#people() people} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the people map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInner withPeople(Map<String, ? extends String> entries) {
    if (this.people == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableInner(this.feet, this.boats, newValue, this.peopleRepublics, this.feetPeople, this.goods);
  }

  /**
   * Copy the current immutable object by replacing the {@link DepluralizeMergeDictionary.Inner#peopleRepublics() peopleRepublics} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the peopleRepublics map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInner withPeopleRepublics(Multimap<String, ? extends String> entries) {
    if (this.peopleRepublics == entries) return this;
    ImmutableMultimap<String, String> newValue = ImmutableMultimap.copyOf(entries);
    return new ImmutableInner(this.feet, this.boats, this.people, newValue, this.feetPeople, this.goods);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DepluralizeMergeDictionary.Inner#feetPeople() feetPeople}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInner withFeetPeople(int... elements) {
    ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
    return new ImmutableInner(this.feet, this.boats, this.people, this.peopleRepublics, newValue, this.goods);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DepluralizeMergeDictionary.Inner#feetPeople() feetPeople}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of feetPeople elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInner withFeetPeople(Iterable<Integer> elements) {
    if (this.feetPeople == elements) return this;
    ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableInner(this.feet, this.boats, this.people, this.peopleRepublics, newValue, this.goods);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DepluralizeMergeDictionary.Inner#goods() goods}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInner withGoods(boolean... elements) {
    ImmutableMultiset<Boolean> newValue = ImmutableMultiset.copyOf(Booleans.asList(elements));
    return new ImmutableInner(this.feet, this.boats, this.people, this.peopleRepublics, this.feetPeople, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DepluralizeMergeDictionary.Inner#goods() goods}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of goods elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInner withGoods(Iterable<Boolean> elements) {
    if (this.goods == elements) return this;
    ImmutableMultiset<Boolean> newValue = ImmutableMultiset.copyOf(elements);
    return new ImmutableInner(this.feet, this.boats, this.people, this.peopleRepublics, this.feetPeople, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInner} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInner
        && equalTo(0, (ImmutableInner) another);
  }

  private boolean equalTo(int synthetic, ImmutableInner another) {
    return feet.equals(another.feet)
        && boats.equals(another.boats)
        && people.equals(another.people)
        && peopleRepublics.equals(another.peopleRepublics)
        && feetPeople.equals(another.feetPeople)
        && goods.equals(another.goods);
  }

  /**
   * Computes a hash code from attributes: {@code feet}, {@code boats}, {@code people}, {@code peopleRepublics}, {@code feetPeople}, {@code goods}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + feet.hashCode();
    h += (h << 5) + boats.hashCode();
    h += (h << 5) + people.hashCode();
    h += (h << 5) + peopleRepublics.hashCode();
    h += (h << 5) + feetPeople.hashCode();
    h += (h << 5) + goods.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Inner} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Inner")
        .omitNullValues()
        .add("feet", feet)
        .add("boats", boats)
        .add("people", people)
        .add("peopleRepublics", peopleRepublics)
        .add("feetPeople", feetPeople)
        .add("goods", goods)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DepluralizeMergeDictionary.Inner} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Inner instance
   */
  public static ImmutableInner copyOf(DepluralizeMergeDictionary.Inner instance) {
    if (instance instanceof ImmutableInner) {
      return (ImmutableInner) instance;
    }
    return ImmutableInner.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableInner ImmutableInner}.
   * <pre>
   * ImmutableInner.builder()
   *    .addFoot|addAllFeet(String) // {@link DepluralizeMergeDictionary.Inner#feet() feet} elements
   *    .addBoat|addAllBoats(String) // {@link DepluralizeMergeDictionary.Inner#boats() boats} elements
   *    .putPerson|putAllPeople(String =&gt; String) // {@link DepluralizeMergeDictionary.Inner#people() people} mappings
   *    .putPeopleRepublic|putAllPeopleRepublics(String =&gt; String) // {@link DepluralizeMergeDictionary.Inner#peopleRepublics() peopleRepublics} mappings
   *    .addFeetPerson|addAllFeetPeople(int) // {@link DepluralizeMergeDictionary.Inner#feetPeople() feetPeople} elements
   *    .addGoods|addAllGoods(boolean) // {@link DepluralizeMergeDictionary.Inner#goods() goods} elements
   *    .build();
   * </pre>
   * @return A new ImmutableInner builder
   */
  public static ImmutableInner.Builder builder() {
    return new ImmutableInner.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableInner ImmutableInner}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DepluralizeMergeDictionary.Inner", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<String> feet = ImmutableList.builder();
    private ImmutableSet.Builder<String> boats = ImmutableSet.builder();
    private ImmutableMap.Builder<String, String> people = ImmutableMap.builder();
    private ImmutableMultimap.Builder<String, String> peopleRepublics = ImmutableMultimap.builder();
    private ImmutableList.Builder<Integer> feetPeople = ImmutableList.builder();
    private ImmutableMultiset.Builder<Boolean> goods = ImmutableMultiset.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Inner} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DepluralizeMergeDictionary.Inner instance) {
      Objects.requireNonNull(instance, "instance");
      addAllFeet(instance.feet());
      addAllBoats(instance.boats());
      putAllPeople(instance.people());
      putAllPeopleRepublics(instance.peopleRepublics());
      addAllFeetPeople(instance.feetPeople());
      addAllGoods(instance.goods());
      return this;
    }

    /**
     * Adds one element to {@link DepluralizeMergeDictionary.Inner#feet() feet} list.
     * @param element A feet element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFoot(String element) {
      this.feet.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DepluralizeMergeDictionary.Inner#feet() feet} list.
     * @param elements An array of feet elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFeet(String... elements) {
      this.feet.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DepluralizeMergeDictionary.Inner#feet() feet} list.
     * @param elements An iterable of feet elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder feet(Iterable<String> elements) {
      this.feet = ImmutableList.builder();
      return addAllFeet(elements);
    }

    /**
     * Adds elements to {@link DepluralizeMergeDictionary.Inner#feet() feet} list.
     * @param elements An iterable of feet elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFeet(Iterable<String> elements) {
      this.feet.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link DepluralizeMergeDictionary.Inner#boats() boats} set.
     * @param element A boats element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBoat(String element) {
      this.boats.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DepluralizeMergeDictionary.Inner#boats() boats} set.
     * @param elements An array of boats elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBoats(String... elements) {
      this.boats.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DepluralizeMergeDictionary.Inner#boats() boats} set.
     * @param elements An iterable of boats elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder boats(Iterable<String> elements) {
      this.boats = ImmutableSet.builder();
      return addAllBoats(elements);
    }

    /**
     * Adds elements to {@link DepluralizeMergeDictionary.Inner#boats() boats} set.
     * @param elements An iterable of boats elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllBoats(Iterable<String> elements) {
      this.boats.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link DepluralizeMergeDictionary.Inner#people() people} map.
     * @param key The key in the people map
     * @param value The associated value in the people map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putPerson(String key, String value) {
      this.people.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link DepluralizeMergeDictionary.Inner#people() people} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putPerson(Map.Entry<String, ? extends String> entry) {
      this.people.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DepluralizeMergeDictionary.Inner#people() people} map. Nulls are not permitted
     * @param entries The entries that will be added to the people map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder people(Map<String, ? extends String> entries) {
      this.people = ImmutableMap.builder();
      return putAllPeople(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DepluralizeMergeDictionary.Inner#people() people} map. Nulls are not permitted
     * @param entries The entries that will be added to the people map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllPeople(Map<String, ? extends String> entries) {
      this.people.putAll(entries);
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link DepluralizeMergeDictionary.Inner#peopleRepublics() peopleRepublics} true. Nulls are not permitted
     * @param key The key for peopleRepublics
     * @param values The values for peopleRepublics
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putPeopleRepublics(String key, String... values) {
      this.peopleRepublics.putAll(key, Arrays.asList(values));
      return this;
    }

    /**
     * Put all mappings from the specified key to values for {@link DepluralizeMergeDictionary.Inner#peopleRepublics() peopleRepublics} true. Nulls are not permitted
     * @param key The key for peopleRepublics
     * @param values The values for peopleRepublics
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllPeopleRepublics(String key, Iterable<String> values) {
      this.peopleRepublics.putAll(key, values);
      return this;
    }

    /**
     * Put one entry to the {@link DepluralizeMergeDictionary.Inner#peopleRepublics() peopleRepublics} map.
     * @param key The key in the peopleRepublics map
     * @param value The associated value in the peopleRepublics map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putPeopleRepublic(String key, String value) {
      this.peopleRepublics.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link DepluralizeMergeDictionary.Inner#peopleRepublics() peopleRepublics} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putPeopleRepublic(Map.Entry<String, ? extends String> entry) {
      this.peopleRepublics.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DepluralizeMergeDictionary.Inner#peopleRepublics() peopleRepublics} map. Nulls are not permitted
     * @param entries The entries that will be added to the peopleRepublics map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder peopleRepublics(Multimap<String, ? extends String> entries) {
      this.peopleRepublics = ImmutableMultimap.builder();
      return putAllPeopleRepublics(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DepluralizeMergeDictionary.Inner#peopleRepublics() peopleRepublics} map. Nulls are not permitted
     * @param entries The entries that will be added to the peopleRepublics map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllPeopleRepublics(Multimap<String, ? extends String> entries) {
      this.peopleRepublics.putAll(entries);
      return this;
    }

    /**
     * Adds one element to {@link DepluralizeMergeDictionary.Inner#feetPeople() feetPeople} list.
     * @param element A feetPeople element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFeetPerson(int element) {
      this.feetPeople.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DepluralizeMergeDictionary.Inner#feetPeople() feetPeople} list.
     * @param elements An array of feetPeople elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFeetPeople(int... elements) {
      this.feetPeople.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DepluralizeMergeDictionary.Inner#feetPeople() feetPeople} list.
     * @param elements An iterable of feetPeople elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder feetPeople(Iterable<Integer> elements) {
      this.feetPeople = ImmutableList.builder();
      return addAllFeetPeople(elements);
    }

    /**
     * Adds elements to {@link DepluralizeMergeDictionary.Inner#feetPeople() feetPeople} list.
     * @param elements An iterable of feetPeople elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFeetPeople(Iterable<Integer> elements) {
      this.feetPeople.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link DepluralizeMergeDictionary.Inner#goods() goods} multiset.
     * @param element A goods element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGoods(boolean element) {
      this.goods.add(element);
      return this;
    }

    /**
     * Adds elements to {@link DepluralizeMergeDictionary.Inner#goods() goods} multiset.
     * @param elements An array of goods elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGoods(boolean... elements) {
      this.goods.addAll(Booleans.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DepluralizeMergeDictionary.Inner#goods() goods} multiset.
     * @param elements An iterable of goods elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder goods(Iterable<Boolean> elements) {
      this.goods = ImmutableMultiset.builder();
      return addAllGoods(elements);
    }

    /**
     * Adds elements to {@link DepluralizeMergeDictionary.Inner#goods() goods} multiset.
     * @param elements An iterable of goods elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGoods(Iterable<Boolean> elements) {
      this.goods.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableInner ImmutableInner}.
     * @return An immutable instance of Inner
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInner build() {
      return new ImmutableInner(
          feet.build(),
          boats.build(),
          people.build(),
          peopleRepublics.build(),
          feetPeople.build(),
          goods.build());
    }
  }
}
