package org.immutables.fixture.subpack;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SillySubstructure}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSillySubstructure.builder()}.
 */
@Generated(from = "SillySubstructure", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSillySubstructure extends SillySubstructure {
  private final RetentionPolicy enum1;
  private final ImmutableSet<ElementType> set2;
  private final ImmutableSet<Integer> set3;
  private final ImmutableList<Float> floats4;

  private ImmutableSillySubstructure(ImmutableSillySubstructure.Builder builder) {
    this.set2 = Sets.immutableEnumSet(builder.set2.build());
    this.set3 = builder.set3.build();
    this.floats4 = builder.floats4.build();
    this.enum1 = builder.enum1 != null
        ? builder.enum1
        : Objects.requireNonNull(super.enum1(), "enum1");
  }

  private ImmutableSillySubstructure(
      RetentionPolicy enum1,
      ImmutableSet<ElementType> set2,
      ImmutableSet<Integer> set3,
      ImmutableList<Float> floats4) {
    this.enum1 = enum1;
    this.set2 = set2;
    this.set3 = set3;
    this.floats4 = floats4;
  }

  /**
   * @return The value of the {@code enum1} attribute
   */
  @Override
  public RetentionPolicy enum1() {
    return enum1;
  }

  /**
   * @return The value of the {@code set2} attribute
   */
  @Override
  public ImmutableSet<ElementType> set2() {
    return set2;
  }

  /**
   * @return The value of the {@code set3} attribute
   */
  @Override
  public ImmutableSet<Integer> set3() {
    return set3;
  }

  /**
   * @return The value of the {@code floats4} attribute
   */
  @Override
  public ImmutableList<Float> floats4() {
    return floats4;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SillySubstructure#enum1() enum1} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enum1
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSillySubstructure withEnum1(RetentionPolicy value) {
    RetentionPolicy newValue = Objects.requireNonNull(value, "enum1");
    if (this.enum1 == newValue) return this;
    return new ImmutableSillySubstructure(newValue, this.set2, this.set3, this.floats4);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillySubstructure#set2() set2}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillySubstructure withSet2(ElementType... elements) {
    ImmutableSet<ElementType> newValue = Sets.immutableEnumSet(Arrays.asList(elements));
    return new ImmutableSillySubstructure(this.enum1, newValue, this.set3, this.floats4);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillySubstructure#set2() set2}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of set2 elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillySubstructure withSet2(Iterable<ElementType> elements) {
    if (this.set2 == elements) return this;
    ImmutableSet<ElementType> newValue = Sets.immutableEnumSet(elements);
    return new ImmutableSillySubstructure(this.enum1, newValue, this.set3, this.floats4);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillySubstructure#set3() set3}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillySubstructure withSet3(int... elements) {
    ImmutableSet<Integer> newValue = ImmutableSet.copyOf(Ints.asList(elements));
    return new ImmutableSillySubstructure(this.enum1, this.set2, newValue, this.floats4);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillySubstructure#set3() set3}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of set3 elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillySubstructure withSet3(Iterable<Integer> elements) {
    if (this.set3 == elements) return this;
    ImmutableSet<Integer> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableSillySubstructure(this.enum1, this.set2, newValue, this.floats4);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillySubstructure#floats4() floats4}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillySubstructure withFloats4(float... elements) {
    ImmutableList<Float> newValue = ImmutableList.copyOf(Floats.asList(elements));
    return new ImmutableSillySubstructure(this.enum1, this.set2, this.set3, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SillySubstructure#floats4() floats4}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of floats4 elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSillySubstructure withFloats4(Iterable<Float> elements) {
    if (this.floats4 == elements) return this;
    ImmutableList<Float> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSillySubstructure(this.enum1, this.set2, this.set3, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSillySubstructure} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSillySubstructure
        && equalTo(0, (ImmutableSillySubstructure) another);
  }

  private boolean equalTo(int synthetic, ImmutableSillySubstructure another) {
    return enum1.equals(another.enum1)
        && set2.equals(another.set2)
        && set3.equals(another.set3)
        && floats4.equals(another.floats4);
  }

  /**
   * Computes a hash code from attributes: {@code enum1}, {@code set2}, {@code set3}, {@code floats4}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + enum1.hashCode();
    h += (h << 5) + set2.hashCode();
    h += (h << 5) + set3.hashCode();
    h += (h << 5) + floats4.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SillySubstructure} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SillySubstructure")
        .omitNullValues()
        .add("enum1", enum1)
        .add("set2", set2)
        .add("set3", set3)
        .add("floats4", floats4)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SillySubstructure} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SillySubstructure instance
   */
  public static ImmutableSillySubstructure copyOf(SillySubstructure instance) {
    if (instance instanceof ImmutableSillySubstructure) {
      return (ImmutableSillySubstructure) instance;
    }
    return ImmutableSillySubstructure.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSillySubstructure ImmutableSillySubstructure}.
   * <pre>
   * ImmutableSillySubstructure.builder()
   *    .enum1(annotation.RetentionPolicy) // optional {@link SillySubstructure#enum1() enum1}
   *    .addSet2|addAllSet2(annotation.ElementType) // {@link SillySubstructure#set2() set2} elements
   *    .addSet3|addAllSet3(int) // {@link SillySubstructure#set3() set3} elements
   *    .addFloats4|addAllFloats4(float) // {@link SillySubstructure#floats4() floats4} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSillySubstructure builder
   */
  public static ImmutableSillySubstructure.Builder builder() {
    return new ImmutableSillySubstructure.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSillySubstructure ImmutableSillySubstructure}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SillySubstructure", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable RetentionPolicy enum1;
    private ImmutableSet.Builder<ElementType> set2 = ImmutableSet.builder();
    private ImmutableSet.Builder<Integer> set3 = ImmutableSet.builder();
    private ImmutableList.Builder<Float> floats4 = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SillySubstructure} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SillySubstructure instance) {
      Objects.requireNonNull(instance, "instance");
      enum1(instance.enum1());
      addAllSet2(instance.set2());
      addAllSet3(instance.set3());
      addAllFloats4(instance.floats4());
      return this;
    }

    /**
     * Initializes the value for the {@link SillySubstructure#enum1() enum1} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SillySubstructure#enum1() enum1}.</em>
     * @param enum1 The value for enum1 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder enum1(RetentionPolicy enum1) {
      this.enum1 = Objects.requireNonNull(enum1, "enum1");
      return this;
    }

    /**
     * Adds one element to {@link SillySubstructure#set2() set2} set.
     * @param element A set2 element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSet2(ElementType element) {
      this.set2.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SillySubstructure#set2() set2} set.
     * @param elements An array of set2 elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSet2(ElementType... elements) {
      this.set2.addAll(Arrays.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SillySubstructure#set2() set2} set.
     * @param elements An iterable of set2 elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder set2(Iterable<ElementType> elements) {
      this.set2 = ImmutableSet.builder();
      return addAllSet2(elements);
    }

    /**
     * Adds elements to {@link SillySubstructure#set2() set2} set.
     * @param elements An iterable of set2 elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSet2(Iterable<ElementType> elements) {
      this.set2.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link SillySubstructure#set3() set3} set.
     * @param element A set3 element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSet3(int element) {
      this.set3.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SillySubstructure#set3() set3} set.
     * @param elements An array of set3 elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSet3(int... elements) {
      this.set3.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SillySubstructure#set3() set3} set.
     * @param elements An iterable of set3 elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder set3(Iterable<Integer> elements) {
      this.set3 = ImmutableSet.builder();
      return addAllSet3(elements);
    }

    /**
     * Adds elements to {@link SillySubstructure#set3() set3} set.
     * @param elements An iterable of set3 elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSet3(Iterable<Integer> elements) {
      this.set3.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link SillySubstructure#floats4() floats4} list.
     * @param element A floats4 element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFloats4(float element) {
      this.floats4.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SillySubstructure#floats4() floats4} list.
     * @param elements An array of floats4 elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFloats4(float... elements) {
      this.floats4.addAll(Floats.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SillySubstructure#floats4() floats4} list.
     * @param elements An iterable of floats4 elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder floats4(Iterable<Float> elements) {
      this.floats4 = ImmutableList.builder();
      return addAllFloats4(elements);
    }

    /**
     * Adds elements to {@link SillySubstructure#floats4() floats4} list.
     * @param elements An iterable of floats4 elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFloats4(Iterable<Float> elements) {
      this.floats4.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSillySubstructure ImmutableSillySubstructure}.
     * @return An immutable instance of SillySubstructure
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSillySubstructure build() {
      return new ImmutableSillySubstructure(this);
    }
  }
}
