package org.immutables.fixture.with;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * {@code ImmutableEnc} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link Enc}.
 * @see ImmutableEnc.Suppied
 */
@Generated(from = "Enc", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableEnc {
  private ImmutableEnc() {}

  /**
   * Immutable implementation of {@link Enc.Suppied}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code new Enc.Suppied.Builder()}.
   */
  @Generated(from = "Enc.Suppied", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class Suppied<T extends Number> implements Enc.Suppied<T> {
    private final String a;
    private final T num;
    private final ImmutableMultimap<String, T> mm;
    private final @Nullable T opt;
    private final int[] array;
    private final @Nullable String[] nularr;

    private Suppied(
        String a,
        T num,
        ImmutableMultimap<String, T> mm,
        @Nullable T opt,
        int[] array,
        @Nullable String[] nularr) {
      this.a = a;
      this.num = num;
      this.mm = mm;
      this.opt = opt;
      this.array = array;
      this.nularr = nularr;
    }

    /**
     * @return The value of the {@code a} attribute
     */
    @JsonProperty("a")
    @Override
    public String a() {
      return a;
    }

    /**
     * @return The value of the {@code num} attribute
     */
    @JsonProperty("num")
    @Override
    public T num() {
      return num;
    }

    /**
     * @return The value of the {@code mm} attribute
     */
    @JsonProperty("mm")
    @Override
    public ImmutableMultimap<String, T> mm() {
      return mm;
    }

    /**
     * @return The value of the {@code opt} attribute
     */
    @JsonProperty("opt")
    @Override
    public Optional<T> opt() {
      return Optional.ofNullable(opt);
    }

    /**
     * @return A cloned {@code array} array
     */
    @JsonProperty("array")
    @Override
    public int[] array() {
      return array.clone();
    }

    /**
     * @return A cloned {@code nularr} array
     */
    @JsonProperty("nularr")
    @Override
    public @Nullable String[] nularr() {
      return nularr;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Enc.Suppied#a() a} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for a
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEnc.Suppied<T> withA(String value) {
      String newValue = Objects.requireNonNull(value, "a");
      if (this.a.equals(newValue)) return this;
      return new ImmutableEnc.Suppied<>(newValue, this.num, this.mm, this.opt, this.array, this.nularr);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Enc.Suppied#num() num} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for num
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableEnc.Suppied<T> withNum(T value) {
      if (this.num == value) return this;
      T newValue = Objects.requireNonNull(value, "num");
      return new ImmutableEnc.Suppied<>(this.a, newValue, this.mm, this.opt, this.array, this.nularr);
    }

    /**
     * Copy the current immutable object by replacing the {@link Enc.Suppied#mm() mm} map with the specified map.
     * Nulls are not permitted as keys or values.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param entries The entries to be added to the mm map
     * @return A modified copy of {@code this} object
     */
    public final ImmutableEnc.Suppied<T> withMm(Multimap<String, ? extends T> entries) {
      if (this.mm == entries) return this;
      ImmutableMultimap<String, T> newValue = ImmutableMultimap.copyOf(entries);
      return new ImmutableEnc.Suppied<>(this.a, this.num, newValue, this.opt, this.array, this.nularr);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Enc.Suppied#opt() opt} attribute.
     * @param value The value for opt
     * @return A modified copy of {@code this} object
     */
    public final ImmutableEnc.Suppied<T> withOpt(T value) {
      @Nullable T newValue = Objects.requireNonNull(value, "opt");
      if (this.opt == newValue) return this;
      return new ImmutableEnc.Suppied<>(this.a, this.num, this.mm, newValue, this.array, this.nularr);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link Enc.Suppied#opt() opt} attribute.
     * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
     * @param optional A value for opt
     * @return A modified copy of {@code this} object
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    public final ImmutableEnc.Suppied<T> withOpt(Optional<? extends T> optional) {
      @Nullable T value = optional.orElse(null);
      if (this.opt == value) return this;
      return new ImmutableEnc.Suppied<>(this.a, this.num, this.mm, value, this.array, this.nularr);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Enc.Suppied#array() array}.
     * The array is cloned before being saved as attribute values.
     * @param elements The non-null elements for array
     * @return A modified copy of {@code this} object
     */
    public final ImmutableEnc.Suppied<T> withArray(int... elements) {
      int[] newValue = elements.clone();
      return new ImmutableEnc.Suppied<>(this.a, this.num, this.mm, this.opt, newValue, this.nularr);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Enc.Suppied#nularr() nularr}.
     * The array is cloned before being saved as attribute values.
     * @param elements The non-null elements for nularr
     * @return A modified copy of {@code this} object
     */
    public final ImmutableEnc.Suppied<T> withNularr(@Nullable String... elements) {
      @Nullable String[] newValue = elements == null ? null : elements.clone();
      return new ImmutableEnc.Suppied<>(this.a, this.num, this.mm, this.opt, this.array, newValue);
    }

    /**
     * This instance is equal to all instances of {@code Suppied} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableEnc.Suppied<?>
          && equalTo(0, (ImmutableEnc.Suppied<?>) another);
    }

    private boolean equalTo(int synthetic, ImmutableEnc.Suppied<?> another) {
      return a.equals(another.a)
          && num.equals(another.num)
          && mm.equals(another.mm)
          && Objects.equals(opt, another.opt)
          && Arrays.equals(array, another.array)
          && Arrays.equals(nularr, another.nularr);
    }

    /**
     * Computes a hash code from attributes: {@code a}, {@code num}, {@code mm}, {@code opt}, {@code array}, {@code nularr}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + a.hashCode();
      h += (h << 5) + num.hashCode();
      h += (h << 5) + mm.hashCode();
      h += (h << 5) + Objects.hashCode(opt);
      h += (h << 5) + Arrays.hashCode(array);
      h += (h << 5) + Arrays.hashCode(nularr);
      return h;
    }

    /**
     * Prints the immutable value {@code Suppied} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Suppied")
          .omitNullValues()
          .add("a", a)
          .add("num", num)
          .add("mm", mm)
          .add("opt", opt)
          .add("array", Arrays.toString(array))
          .add("nularr", Arrays.toString(nularr))
          .toString();
    }

    /**
     * Utility type used to correctly read immutable object from JSON representation.
     * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Generated(from = "Enc.Suppied", generator = "Immutables")
    @Deprecated
    @SuppressWarnings("Immutable")
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
    static final class Json<T extends Number> implements Enc.Suppied<T> {
      @Nullable String a;
      @Nullable T num;
      @Nullable Multimap<String, T> mm = ImmutableMultimap.of();
      @Nullable Optional<T> opt = Optional.empty();
      @Nullable int[] array;
      @Nullable String[] nularr;
      @JsonProperty("a")
      public void setA(String a) {
        this.a = a;
      }
      @JsonProperty("num")
      public void setNum(T num) {
        this.num = num;
      }
      @JsonProperty("mm")
      public void setMm(Multimap<String, T> mm) {
        this.mm = mm;
      }
      @JsonProperty("opt")
      public void setOpt(Optional<T> opt) {
        this.opt = opt;
      }
      @JsonProperty("array")
      public void setArray(int[] array) {
        this.array = array;
      }
      @JsonProperty("nularr")
      public void setNularr(@Nullable String[] nularr) {
        this.nularr = nularr;
      }
      @Override
      public String a() { throw new UnsupportedOperationException(); }
      @Override
      public T num() { throw new UnsupportedOperationException(); }
      @Override
      public Multimap<String, T> mm() { throw new UnsupportedOperationException(); }
      @Override
      public Optional<T> opt() { throw new UnsupportedOperationException(); }
      @Override
      public int[] array() { throw new UnsupportedOperationException(); }
      @Override
      public String[] nularr() { throw new UnsupportedOperationException(); }
      @Override
      public Enc.Suppied<T> withA(String value) { throw new UnsupportedOperationException(); }
      @Override
      public Enc.Suppied<T> withNum(T value) { throw new UnsupportedOperationException(); }
      @Override
      public Enc.Suppied<T> withMm(Multimap<String, ? extends T> entries) { throw new UnsupportedOperationException(); }
      @Override
      public Enc.Suppied<T> withOpt(T value) { throw new UnsupportedOperationException(); }
      @Override
      public Enc.Suppied<T> withOpt(Optional<? extends T> optional) { throw new UnsupportedOperationException(); }
      @Override
      public final Enc.Suppied<T> withArray(int... elements) { throw new UnsupportedOperationException(); }
      @Override
      public final Enc.Suppied<T> withNularr(String... elements) { throw new UnsupportedOperationException(); }
    }

    /**
     * @param <T> generic parameter T
     * @param json A JSON-bindable data structure
     * @return An immutable value type
     * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Deprecated
    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    static <T extends Number> ImmutableEnc.Suppied<T> fromJson(Json<T> json) {
      Enc.Suppied.Builder<T> builder = new Enc.Suppied.Builder<T>();
      if (json.a != null) {
        builder.a(json.a);
      }
      if (json.num != null) {
        builder.num(json.num);
      }
      if (json.mm != null) {
        builder.putAllMm(json.mm);
      }
      if (json.opt != null) {
        builder.opt(json.opt);
      }
      if (json.array != null) {
        builder.array(json.array);
      }
      if (json.nularr != null) {
        builder.nularr(json.nularr);
      }
      return (ImmutableEnc.Suppied<T>) builder.build();
    }

    /**
     * Builds instances of type {@link ImmutableEnc.Suppied Suppied}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @Generated(from = "Enc.Suppied", generator = "Immutables")
    @NotThreadSafe
    public static class Builder<T extends Number> {
      private static final long INIT_BIT_A = 0x1L;
      private static final long INIT_BIT_NUM = 0x2L;
      private static final long INIT_BIT_ARRAY = 0x4L;
      private long initBits = 0x7L;

      private @Nullable String a;
      private @Nullable T num;
      private ImmutableMultimap.Builder<String, T> mm = ImmutableMultimap.builder();
      private @Nullable T opt;
      private @Nullable int[] array;
      private @Nullable String[] nularr;

      /**
       * Creates a builder for {@link ImmutableEnc.Suppied Suppied} instances.
       * <pre>
       * new Enc.Suppied.Builder&amp;lt;T&amp;gt;()
       *    .a(String) // required {@link Enc.Suppied#a() a}
       *    .num(T) // required {@link Enc.Suppied#num() num}
       *    .putMm|putAllMm(String =&gt; T) // {@link Enc.Suppied#mm() mm} mappings
       *    .opt(T) // optional {@link Enc.Suppied#opt() opt}
       *    .array(int) // required {@link Enc.Suppied#array() array}
       *    .nularr(String[] | null) // nullable {@link Enc.Suppied#nularr() nularr}
       *    .build();
       * </pre>
       */
      public Builder() {
        if (!(this instanceof Enc.Suppied.Builder<?>)) {
          throw new UnsupportedOperationException("Use: new Enc.Suppied.Builder<T>()");
        }
      }

      /**
       * Fill a builder with attribute values from the provided {@code Suppied} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * Collection elements and entries will be added, not replaced.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Enc.Suppied.Builder<T> from(Enc.Suppied<T> instance) {
        Objects.requireNonNull(instance, "instance");
        a(instance.a());
        num(instance.num());
        putAllMm(instance.mm());
        Optional<T> optOptional = instance.opt();
        if (optOptional.isPresent()) {
          opt(optOptional);
        }
        array(instance.array());
        @Nullable String[] nularrValue = instance.nularr();
        if (nularrValue != null) {
          nularr(nularrValue);
        }
        return (Enc.Suppied.Builder<T>) this;
      }

      /**
       * Initializes the value for the {@link Enc.Suppied#a() a} attribute.
       * @param a The value for a 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      @JsonProperty("a")
      public final Enc.Suppied.Builder<T> a(String a) {
        this.a = Objects.requireNonNull(a, "a");
        initBits &= ~INIT_BIT_A;
        return (Enc.Suppied.Builder<T>) this;
      }

      /**
       * Initializes the value for the {@link Enc.Suppied#num() num} attribute.
       * @param num The value for num 
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      @JsonProperty("num")
      public final Enc.Suppied.Builder<T> num(T num) {
        this.num = Objects.requireNonNull(num, "num");
        initBits &= ~INIT_BIT_NUM;
        return (Enc.Suppied.Builder<T>) this;
      }

      /**
       * Put all mappings from the specified key to values for {@link Enc.Suppied#mm() mm} true. Nulls are not permitted
       * @param key The key for mm
       * @param values The values for mm
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      @SafeVarargs @SuppressWarnings("varargs")
      public final Enc.Suppied.Builder<T> putMm(String key, T... values) {
        this.mm.putAll(key, Arrays.asList(values));
        return (Enc.Suppied.Builder<T>) this;
      }

      /**
       * Put all mappings from the specified key to values for {@link Enc.Suppied#mm() mm} true. Nulls are not permitted
       * @param key The key for mm
       * @param values The values for mm
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Enc.Suppied.Builder<T> putAllMm(String key, Iterable<T> values) {
        this.mm.putAll(key, values);
        return (Enc.Suppied.Builder<T>) this;
      }

      /**
       * Put one entry to the {@link Enc.Suppied#mm() mm} map.
       * @param key The key in the mm map
       * @param value The associated value in the mm map
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Enc.Suppied.Builder<T> putMm(String key, T value) {
        this.mm.put(key, value);
        return (Enc.Suppied.Builder<T>) this;
      }

      /**
       * Put one entry to the {@link Enc.Suppied#mm() mm} map. Nulls are not permitted
       * @param entry The key and value entry
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Enc.Suppied.Builder<T> putMm(Map.Entry<String, ? extends T> entry) {
        this.mm.put(entry);
        return (Enc.Suppied.Builder<T>) this;
      }

      /**
       * Sets or replaces all mappings from the specified map as entries for the {@link Enc.Suppied#mm() mm} map. Nulls are not permitted
       * @param entries The entries that will be added to the mm map
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      @JsonProperty("mm")
      public final Enc.Suppied.Builder<T> mm(Multimap<String, ? extends T> entries) {
        this.mm = ImmutableMultimap.builder();
        return putAllMm(entries);
      }

      /**
       * Put all mappings from the specified map as entries to {@link Enc.Suppied#mm() mm} map. Nulls are not permitted
       * @param entries The entries that will be added to the mm map
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      public final Enc.Suppied.Builder<T> putAllMm(Multimap<String, ? extends T> entries) {
        this.mm.putAll(entries);
        return (Enc.Suppied.Builder<T>) this;
      }

      /**
       * Initializes the optional value {@link Enc.Suppied#opt() opt} to opt.
       * @param opt The value for opt
       * @return {@code this} builder for chained invocation
       */
      @CanIgnoreReturnValue 
      public final Enc.Suppied.Builder<T> opt(T opt) {
        this.opt = Objects.requireNonNull(opt, "opt");
        return (Enc.Suppied.Builder<T>) this;
      }

      /**
       * Initializes the optional value {@link Enc.Suppied#opt() opt} to opt.
       * @param opt The value for opt
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      @JsonProperty("opt")
      public final Enc.Suppied.Builder<T> opt(Optional<? extends T> opt) {
        this.opt = opt.orElse(null);
        return (Enc.Suppied.Builder<T>) this;
      }

      /**
       * Initializes the value for the {@link Enc.Suppied#array() array} attribute.
       * @param array The elements for array
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      @JsonProperty("array")
      public final Enc.Suppied.Builder<T> array(int... array) {
        this.array = array.clone();
        initBits &= ~INIT_BIT_ARRAY;
        return (Enc.Suppied.Builder<T>) this;
      }

      /**
       * Initializes the value for the {@link Enc.Suppied#nularr() nularr} attribute.
       * @param nularr The elements for nularr
       * @return {@code this} builder for use in a chained invocation
       */
      @CanIgnoreReturnValue 
      @JsonProperty("nularr")
      public final Enc.Suppied.Builder<T> nularr(String... nularr) {
        this.nularr = nularr;
        return (Enc.Suppied.Builder<T>) this;
      }

      /**
       * Builds a new {@link ImmutableEnc.Suppied Suppied}.
       * @return An immutable instance of Suppied
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableEnc.Suppied<T> build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableEnc.Suppied<>(a, num, mm.build(), opt, array, nularr);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = new ArrayList<>();
        if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
        if ((initBits & INIT_BIT_NUM) != 0) attributes.add("num");
        if ((initBits & INIT_BIT_ARRAY) != 0) attributes.add("array");
        return "Cannot build Suppied, some of required attributes are not set " + attributes;
      }
    }
  }

  @Generated(from = "Enc.Suppied", generator = "Immutables")
  public interface WithSuppied<T extends Number> {

    /**
     * Copy the current immutable object by setting a value for the {@link Enc.Suppied#a() a} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for a
     * @return A modified copy of the {@code this} object
     */
    Enc.Suppied<T> withA(String value);

    /**
     * Copy the current immutable object by setting a value for the {@link Enc.Suppied#num() num} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for num
     * @return A modified copy of the {@code this} object
     */
    Enc.Suppied<T> withNum(T value);

    /**
     * Copy the current immutable object by replacing the {@link Enc.Suppied#mm() mm} map with the specified map.
     * Nulls are not permitted as keys or values.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param entries The entries to be added to the mm map
     * @return A modified copy of {@code this} object
     */
    Enc.Suppied<T> withMm(Multimap<String, ? extends T> entries);

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Enc.Suppied#opt() opt} attribute.
     * @param value The value for opt
     * @return A modified copy of {@code this} object
     */
    Enc.Suppied<T> withOpt(T value);

    /**
     * Copy the current immutable object by setting an optional value for the {@link Enc.Suppied#opt() opt} attribute.
     * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
     * @param optional A value for opt
     * @return A modified copy of {@code this} object
     */
    Enc.Suppied<T> withOpt(Optional<? extends T> optional);

    /**
     * Copy the current immutable object with elements that replace the content of {@link Enc.Suppied#array() array}.
     * The array is cloned before being saved as attribute values.
     * @param elements The non-null elements for array
     * @return A modified copy of {@code this} object
     */
    Enc.Suppied<T> withArray(int... elements);

    /**
     * Copy the current immutable object with elements that replace the content of {@link Enc.Suppied#nularr() nularr}.
     * The array is cloned before being saved as attribute values.
     * @param elements The non-null elements for nularr
     * @return A modified copy of {@code this} object
     */
    Enc.Suppied<T> withNularr(String... elements);
  }
}
