/*
 * Decompiled with CFR 0.152.
 */
package borg.immutables.fixture.packoutput.impl;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Member;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.bson.codecs.Encoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.fixture.packoutput.Packs;
import org.immutables.mongo.concurrent.FluentFuture;
import org.immutables.mongo.repository.Repositories;
import org.immutables.mongo.repository.RepositorySetup;
import org.immutables.mongo.repository.internal.Constraints;
import org.immutables.mongo.repository.internal.Support;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="org.immutables.fixture.packoutput.Packs", generator="Repositories")
@ThreadSafe
public class PacksRepository
extends Repositories.Repository<Packs> {
    private static final String DOCUMENT_COLLECTION_NAME = "packs";
    private final Serialization serialization = new Serialization(this.codecRegistry(), this.fieldNamingStrategy());
    private final Criteria anyCriteria = new Criteria(this.serialization, Constraints.nilConstraint());

    public PacksRepository(RepositorySetup configuration) {
        super(configuration, DOCUMENT_COLLECTION_NAME, Packs.class);
    }

    public FluentFuture<Integer> insert(Packs document) {
        return super.doInsert(ImmutableList.of((Object)document));
    }

    public FluentFuture<Integer> insert(Iterable<? extends Packs> documents) {
        return super.doInsert(ImmutableList.copyOf(documents));
    }

    @CheckReturnValue
    public Finder findAll() {
        return this.find(this.criteria());
    }

    @CheckReturnValue
    public Finder find(String jsonCriteria) {
        return new Finder(this, Support.jsonQuery((String)jsonCriteria));
    }

    @CheckReturnValue
    public Finder find(Criteria criteria) {
        return new Finder(this, (Constraints.ConstraintHost)criteria.constraint);
    }

    @CheckReturnValue
    public Updater update(Criteria criteria) {
        return new Updater(this, criteria);
    }

    @CheckReturnValue
    public Indexer index() {
        return new Indexer(this);
    }

    public Criteria criteria() {
        return this.anyCriteria;
    }

    @Beta
    Bson toBson(Criteria criteria) {
        return Support.convertToBson((Constraints.ConstraintHost)criteria.constraint);
    }

    @Generated(from="org.immutables.fixture.packoutput.Packs", generator="Repositories")
    private static class Serialization {
        final Encoder<Packs.Perk> perkEncoder;
        final CodecRegistry registry;
        final String perkName;

        Serialization(CodecRegistry registry, RepositorySetup.FieldNamingStrategy fieldNamingStrategy) {
            this.registry = registry;
            this.perkEncoder = this.registry.get(Packs.Perk.class);
            this.perkName = Serialization.translateName(fieldNamingStrategy, "perk");
        }

        private static String translateName(RepositorySetup.FieldNamingStrategy fieldNamingStrategy, String fieldName) {
            try {
                return fieldNamingStrategy.translateName((Member)PacksNamingFields.class.getField(fieldName));
            }
            catch (NoSuchFieldException noSuchField) {
                throw new AssertionError((Object)noSuchField);
            }
        }

        @Generated(from="org.immutables.fixture.packoutput.Packs", generator="Repositories")
        static final class PacksNamingFields {
            public Packs.Perk perk;

            PacksNamingFields() {
            }
        }
    }

    @Generated(from="org.immutables.fixture.packoutput.Packs", generator="Repositories")
    @Immutable
    public static final class Criteria
    extends Repositories.Criteria {
        private final Constraints.Constraint constraint;
        private final Serialization serialization;

        Criteria(Serialization serialization, Constraints.Constraint constraint) {
            this.constraint = constraint;
            this.serialization = serialization;
        }

        public Criteria perk(Packs.Perk value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.perkName, false, Support.writable(this.serialization.perkEncoder, (Object)value)));
        }

        public Criteria perkNot(Packs.Perk value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.perkName, true, Support.writable(this.serialization.perkEncoder, (Object)value)));
        }

        public Criteria perkIn(Iterable<Packs.Perk> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Packs.Perk value : values) {
                wrappedValues.add(Support.writable(this.serialization.perkEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.perkName, false, wrappedValues));
        }

        public Criteria perkIn(Packs.Perk first, Packs.Perk second, Packs.Perk ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.perkEncoder, (Object)first));
            values.add(Support.writable(this.serialization.perkEncoder, (Object)second));
            for (Packs.Perk value : rest) {
                values.add(Support.writable(this.serialization.perkEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.perkName, false, values));
        }

        public Criteria perkNotIn(Iterable<Packs.Perk> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Packs.Perk value : values) {
                wrappedValues.add(Support.writable(this.serialization.perkEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.perkName, true, wrappedValues));
        }

        public Criteria perkNotIn(Packs.Perk first, Packs.Perk second, Packs.Perk ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.perkEncoder, (Object)first));
            values.add(Support.writable(this.serialization.perkEncoder, (Object)second));
            for (Packs.Perk value : rest) {
                values.add(Support.writable(this.serialization.perkEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.perkName, true, values));
        }

        public Criteria or() {
            return new Criteria(this.serialization, this.constraint.disjunction());
        }

        public Criteria with(Criteria criteria) {
            return new Criteria(this.serialization, (Constraints.Constraint)criteria.constraint.accept((Constraints.ConstraintVisitor)this.constraint));
        }

        public String toString() {
            return "PacksRepository.criteria(" + Support.stringify((Constraints.ConstraintHost)this.constraint) + ")";
        }
    }

    @Generated(from="org.immutables.fixture.packoutput.Packs", generator="Repositories")
    @NotThreadSafe
    public static final class Indexer
    extends Repositories.Indexer<Packs, Indexer> {
        private final Serialization serialization;

        private Indexer(PacksRepository repository) {
            super((Repositories.Repository)repository);
            this.serialization = repository.serialization;
        }

        public Indexer withPerk() {
            this.fields = this.fields.equal(this.serialization.perkName, false, (Object)1);
            return this;
        }

        public Indexer withPerkDesceding() {
            this.fields = this.fields.equal(this.serialization.perkName, false, (Object)-1);
            return this;
        }
    }

    @Generated(from="org.immutables.fixture.packoutput.Packs", generator="Repositories")
    @NotThreadSafe
    public static final class Replacer
    extends Repositories.Replacer<Packs, Replacer> {
        protected Replacer(PacksRepository repository, Packs document, Constraints.ConstraintHost criteria, Constraints.Constraint ordering) {
            super((Repositories.Repository)repository, (Object)document, criteria, ordering);
        }
    }

    @Generated(from="org.immutables.fixture.packoutput.Packs", generator="Repositories")
    @NotThreadSafe
    public static final class Modifier
    extends Repositories.Modifier<Packs, Modifier> {
        private final Serialization serialization;

        private Modifier(PacksRepository repository, Constraints.ConstraintHost criteria, Constraints.Constraint ordering, Constraints.Constraint exclusion) {
            super((Repositories.Repository)repository);
            this.serialization = repository.serialization;
            this.criteria = criteria;
            this.ordering = ordering;
            this.exclusion = exclusion;
        }

        public Modifier setPerk(Packs.Perk value) {
            this.setFields = this.setFields.equal(this.serialization.perkName, false, Support.writable(this.serialization.perkEncoder, (Object)value));
            return this;
        }

        public Modifier initPerk(Packs.Perk value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.perkName, false, Support.writable(this.serialization.perkEncoder, (Object)value));
            return this;
        }
    }

    @Generated(from="org.immutables.fixture.packoutput.Packs", generator="Repositories")
    @NotThreadSafe
    public static final class Updater
    extends Repositories.Updater<Packs> {
        private final Serialization serialization;

        private Updater(PacksRepository repository, Criteria criteria) {
            super((Repositories.Repository)repository);
            this.criteria = criteria.constraint;
            this.serialization = repository.serialization;
        }

        public Updater setPerk(Packs.Perk value) {
            this.setFields = this.setFields.equal(this.serialization.perkName, false, Support.writable(this.serialization.perkEncoder, (Object)value));
            return this;
        }

        public Updater initPerk(Packs.Perk value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.perkName, false, Support.writable(this.serialization.perkEncoder, (Object)value));
            return this;
        }
    }

    @Generated(from="org.immutables.fixture.packoutput.Packs", generator="Repositories")
    @NotThreadSafe
    public static final class Finder
    extends Repositories.FinderWithDelete<Packs, Finder> {
        private final Serialization serialization;

        private Finder(PacksRepository repository, Constraints.ConstraintHost criteria) {
            super((Repositories.Repository)repository);
            this.criteria = criteria;
            this.serialization = repository.serialization;
        }

        public Finder orderByPerk() {
            this.ordering = this.ordering.equal(this.serialization.perkName, false, (Object)1);
            return this;
        }

        public Finder orderByPerkDesceding() {
            this.ordering = this.ordering.equal(this.serialization.perkName, false, (Object)-1);
            return this;
        }

        @CheckReturnValue
        public Modifier andModifyFirst() {
            return new Modifier((PacksRepository)this.repository, this.criteria, this.ordering, this.exclusion);
        }

        @CheckReturnValue
        public Replacer andReplaceFirst(Packs document) {
            return new Replacer((PacksRepository)this.repository, document, this.criteria, this.ordering);
        }
    }
}

