/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.fixture.HasNullable;
import org.immutables.fixture.ImmutableHasNullable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="org.immutables.fixture", generator="Gsons")
public final class GsonAdaptersHasNullable
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (HasNullableTypeAdapter.adapts(type)) {
            return new HasNullableTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersHasNullable(HasNullable)";
    }

    @Generated(from="HasNullable", generator="Gsons")
    private static class HasNullableTypeAdapter
    extends TypeAdapter<HasNullable> {
        public final Integer inTypeSample = null;
        private final TypeAdapter<Integer> inTypeAdapter;

        HasNullableTypeAdapter(Gson gson) {
            this.inTypeAdapter = gson.getAdapter(Integer.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return HasNullable.class == type.getRawType() || ImmutableHasNullable.class == type.getRawType();
        }

        public void write(JsonWriter out, HasNullable value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeHasNullable(out, value);
            }
        }

        public HasNullable read(JsonReader in) throws IOException {
            return this.readHasNullable(in);
        }

        private void writeHasNullable(JsonWriter out, HasNullable instance) throws IOException {
            out.beginObject();
            Integer inValue = instance.in();
            if (inValue != null) {
                out.name("in");
                this.inTypeAdapter.write(out, (Object)inValue);
            } else if (out.getSerializeNulls()) {
                out.name("in");
                out.nullValue();
            }
            String defValue = instance.def();
            if (defValue != null) {
                out.name("def");
                out.value(defValue);
            } else if (out.getSerializeNulls()) {
                out.name("def");
                out.nullValue();
            }
            String derValue = instance.der();
            if (derValue != null) {
                out.name("der");
                out.value(derValue);
            } else if (out.getSerializeNulls()) {
                out.name("der");
                out.nullValue();
            }
            out.endObject();
        }

        private HasNullable readHasNullable(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableHasNullable.Builder builder = ImmutableHasNullable.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableHasNullable.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'i': {
                    if (!"in".equals(attributeName)) break;
                    this.readInIn(in, builder);
                    return;
                }
                case 'd': {
                    if (!"def".equals(attributeName)) break;
                    this.readInDef(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInIn(JsonReader in, ImmutableHasNullable.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Integer value = (Integer)this.inTypeAdapter.read(in);
                builder.in(value);
            }
        }

        private void readInDef(JsonReader in, ImmutableHasNullable.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                builder.def(null);
            } else {
                builder.def(in.nextString());
            }
        }
    }
}

