/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.ErgonomicFailureData;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ErgonomicFailureData", generator="Immutables")
@Immutable
public final class ImmutableErgonomicFailureData
extends ErgonomicFailureData {
    private final String id;
    private final ImmutableList<String> listData;
    @Nullable
    private final ImmutableList<String> nullableData;
    private final Collection<String> collectionData;

    private ImmutableErgonomicFailureData(String id) {
        this.id = Objects.requireNonNull(id, "id");
        this.listData = ImmutableList.copyOf(super.listData());
        this.nullableData = super.nullableData() == null ? null : ImmutableList.copyOf(super.nullableData());
        this.collectionData = Objects.requireNonNull(super.collectionData(), "collectionData");
    }

    private ImmutableErgonomicFailureData(Builder builder) {
        this.id = builder.id;
        ImmutableList immutableList = this.listData = builder.listDataIsSet() ? builder.listData.build() : ImmutableList.copyOf(super.listData());
        this.nullableData = builder.nullableDataIsSet() ? (builder.nullableData == null ? null : builder.nullableData.build()) : (super.nullableData() == null ? null : ImmutableList.copyOf(super.nullableData()));
        this.collectionData = builder.collectionData != null ? builder.collectionData : Objects.requireNonNull(super.collectionData(), "collectionData");
    }

    private ImmutableErgonomicFailureData(String id, ImmutableList<String> listData, @Nullable ImmutableList<String> nullableData, Collection<String> collectionData) {
        this.id = id;
        this.listData = listData;
        this.nullableData = nullableData;
        this.collectionData = collectionData;
    }

    @Override
    public String id() {
        return this.id;
    }

    public ImmutableList<String> listData() {
        return this.listData;
    }

    @Nullable
    public ImmutableList<String> nullableData() {
        return this.nullableData;
    }

    @Override
    public Collection<String> collectionData() {
        return this.collectionData;
    }

    public final ImmutableErgonomicFailureData withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableErgonomicFailureData(newValue, this.listData, this.nullableData, this.collectionData);
    }

    public final ImmutableErgonomicFailureData withListData(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableErgonomicFailureData(this.id, (ImmutableList<String>)newValue, this.nullableData, this.collectionData);
    }

    public final ImmutableErgonomicFailureData withListData(Iterable<String> elements) {
        if (this.listData == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableErgonomicFailureData(this.id, (ImmutableList<String>)newValue, this.nullableData, this.collectionData);
    }

    public final ImmutableErgonomicFailureData withNullableData(String ... elements) {
        if (elements == null) {
            return new ImmutableErgonomicFailureData(this.id, this.listData, null, this.collectionData);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutableErgonomicFailureData(this.id, this.listData, (ImmutableList<String>)newValue, this.collectionData);
    }

    public final ImmutableErgonomicFailureData withNullableData(@Nullable Iterable<String> elements) {
        if (this.nullableData == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableErgonomicFailureData(this.id, this.listData, (ImmutableList<String>)newValue, this.collectionData);
    }

    public final ImmutableErgonomicFailureData withCollectionData(Collection<String> value) {
        if (this.collectionData == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "collectionData");
        return new ImmutableErgonomicFailureData(this.id, this.listData, this.nullableData, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErgonomicFailureData && this.equalTo(0, (ImmutableErgonomicFailureData)another);
    }

    private boolean equalTo(int synthetic, ImmutableErgonomicFailureData another) {
        return this.id.equals(another.id) && this.listData.equals(another.listData) && Objects.equals(this.nullableData, another.nullableData) && this.collectionData.equals(another.collectionData);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.listData.hashCode();
        h += (h << 5) + Objects.hashCode(this.nullableData);
        h += (h << 5) + this.collectionData.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ErgonomicFailureData").omitNullValues().add("id", (Object)this.id).add("listData", this.listData).add("nullableData", this.nullableData).add("collectionData", this.collectionData).toString();
    }

    public static ImmutableErgonomicFailureData of(String id) {
        return new ImmutableErgonomicFailureData(id);
    }

    public static ImmutableErgonomicFailureData copyOf(ErgonomicFailureData instance) {
        if (instance instanceof ImmutableErgonomicFailureData) {
            return (ImmutableErgonomicFailureData)instance;
        }
        return ImmutableErgonomicFailureData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ErgonomicFailureData", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long OPT_BIT_LIST_DATA = 1L;
        private static final long OPT_BIT_NULLABLE_DATA = 2L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String id;
        private ImmutableList.Builder<String> listData = ImmutableList.builder();
        private ImmutableList.Builder<String> nullableData = null;
        @Nullable
        private Collection<String> collectionData;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ErgonomicFailureData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.addAllListData(instance.listData());
            List<String> nullableDataValue = instance.nullableData();
            if (nullableDataValue != null) {
                this.addAllNullableData(nullableDataValue);
            }
            this.collectionData(instance.collectionData());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addListData(String element) {
            this.listData.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addListData(String ... elements) {
            this.listData.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder listData(Iterable<String> elements) {
            this.listData = ImmutableList.builder();
            return this.addAllListData(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllListData(Iterable<String> elements) {
            this.listData.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNullableData(String element) {
            if (this.nullableData == null) {
                this.nullableData = ImmutableList.builder();
            }
            this.nullableData.add((Object)element);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNullableData(String ... elements) {
            if (this.nullableData == null) {
                this.nullableData = ImmutableList.builder();
            }
            this.nullableData.add((Object[])elements);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nullableData(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.nullableData = null;
                this.optBits |= 2L;
                return this;
            }
            this.nullableData = ImmutableList.builder();
            return this.addAllNullableData(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNullableData(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nullableData element");
            if (this.nullableData == null) {
                this.nullableData = ImmutableList.builder();
            }
            this.nullableData.addAll(elements);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder collectionData(Collection<String> collectionData) {
            this.collectionData = Objects.requireNonNull(collectionData, "collectionData");
            return this;
        }

        public ImmutableErgonomicFailureData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableErgonomicFailureData(this);
        }

        private boolean listDataIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean nullableDataIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build ErgonomicFailureData, some of required attributes are not set " + attributes;
        }
    }
}

