/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.ExtendedBuilderInterface;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ExtendedBuilderInterface", generator="Immutables")
@Immutable
final class ImmutableExtendedBuilderInterface
implements ExtendedBuilderInterface {
    private final int a;
    private final int b;

    private ImmutableExtendedBuilderInterface(int a, int b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public int a() {
        return this.a;
    }

    @Override
    public int b() {
        return this.b;
    }

    public final ImmutableExtendedBuilderInterface withA(int value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableExtendedBuilderInterface(value, this.b);
    }

    public final ImmutableExtendedBuilderInterface withB(int value) {
        if (this.b == value) {
            return this;
        }
        return new ImmutableExtendedBuilderInterface(this.a, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExtendedBuilderInterface && this.equalTo(0, (ImmutableExtendedBuilderInterface)another);
    }

    private boolean equalTo(int synthetic, ImmutableExtendedBuilderInterface another) {
        return this.a == another.a && this.b == another.b;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.a;
        h += (h << 5) + this.b;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ExtendedBuilderInterface").omitNullValues().add("a", this.a).add("b", this.b).toString();
    }

    public static ImmutableExtendedBuilderInterface copyOf(ExtendedBuilderInterface instance) {
        if (instance instanceof ImmutableExtendedBuilderInterface) {
            return (ImmutableExtendedBuilderInterface)instance;
        }
        return ImmutableExtendedBuilderInterface.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExtendedBuilderInterface", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ExtendedBuilderInterface.Builder {
        private static final long INIT_BIT_A = 1L;
        private static final long INIT_BIT_B = 2L;
        private long initBits = 3L;
        private int a;
        private int b;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ExtendedBuilderInterface instance) {
            Objects.requireNonNull(instance, "instance");
            this.a(instance.a());
            this.b(instance.b());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder a(int a) {
            this.a = a;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder b(int b) {
            this.b = b;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutableExtendedBuilderInterface build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExtendedBuilderInterface(this.a, this.b);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("b");
            }
            return "Cannot build ExtendedBuilderInterface, some of required attributes are not set " + attributes;
        }
    }
}

