/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.ExtraCollection;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ExtraCollection", generator="Immutables")
@Immutable
public final class ImmutableExtraCollection
implements ExtraCollection {
    private final ImmutableMultiset<String> bag;
    private final ImmutableMultimap<Integer, String> index;
    private final ImmutableListMultimap<Integer, String> indexList;
    private final ImmutableSetMultimap<Integer, String> indexSet;
    private final ImmutableBiMap<Integer, String> biMap;
    private final transient int hashCode;
    private static final ImmutableExtraCollection INSTANCE = ImmutableExtraCollection.validate(new ImmutableExtraCollection());

    private ImmutableExtraCollection() {
        this.bag = ImmutableMultiset.of();
        this.index = ImmutableMultimap.of();
        this.indexList = ImmutableListMultimap.of();
        this.indexSet = ImmutableSetMultimap.of();
        this.biMap = ImmutableBiMap.of();
        this.hashCode = this.computeHashCode();
    }

    private ImmutableExtraCollection(Iterable<String> bag, Multimap<Integer, ? extends String> index, Multimap<Integer, ? extends String> indexList, Multimap<Integer, ? extends String> indexSet, Map<Integer, ? extends String> biMap) {
        this.bag = ImmutableMultiset.copyOf(bag);
        this.index = ImmutableMultimap.copyOf(index);
        this.indexList = ImmutableListMultimap.copyOf(indexList);
        this.indexSet = ImmutableSetMultimap.copyOf(indexSet);
        this.biMap = ImmutableBiMap.copyOf(biMap);
        this.hashCode = this.computeHashCode();
    }

    private ImmutableExtraCollection(ImmutableExtraCollection original, ImmutableMultiset<String> bag, ImmutableMultimap<Integer, String> index, ImmutableListMultimap<Integer, String> indexList, ImmutableSetMultimap<Integer, String> indexSet, ImmutableBiMap<Integer, String> biMap) {
        this.bag = bag;
        this.index = index;
        this.indexList = indexList;
        this.indexSet = indexSet;
        this.biMap = biMap;
        this.hashCode = this.computeHashCode();
    }

    public ImmutableMultiset<String> bag() {
        return this.bag;
    }

    public ImmutableMultimap<Integer, String> index() {
        return this.index;
    }

    public ImmutableListMultimap<Integer, String> indexList() {
        return this.indexList;
    }

    public ImmutableSetMultimap<Integer, String> indexSet() {
        return this.indexSet;
    }

    public ImmutableBiMap<Integer, String> biMap() {
        return this.biMap;
    }

    public final ImmutableExtraCollection withBag(String ... elements) {
        ImmutableMultiset newValue = ImmutableMultiset.copyOf((Object[])elements);
        return ImmutableExtraCollection.validate(new ImmutableExtraCollection(this, (ImmutableMultiset<String>)newValue, this.index, this.indexList, this.indexSet, this.biMap));
    }

    public final ImmutableExtraCollection withBag(Iterable<String> elements) {
        if (this.bag == elements) {
            return this;
        }
        ImmutableMultiset newValue = ImmutableMultiset.copyOf(elements);
        return ImmutableExtraCollection.validate(new ImmutableExtraCollection(this, (ImmutableMultiset<String>)newValue, this.index, this.indexList, this.indexSet, this.biMap));
    }

    public final ImmutableExtraCollection withIndex(Multimap<Integer, ? extends String> entries) {
        if (this.index == entries) {
            return this;
        }
        ImmutableMultimap newValue = ImmutableMultimap.copyOf(entries);
        return ImmutableExtraCollection.validate(new ImmutableExtraCollection(this, this.bag, (ImmutableMultimap<Integer, String>)newValue, this.indexList, this.indexSet, this.biMap));
    }

    public final ImmutableExtraCollection withIndexList(Multimap<Integer, ? extends String> entries) {
        if (this.indexList == entries) {
            return this;
        }
        ImmutableListMultimap newValue = ImmutableListMultimap.copyOf(entries);
        return ImmutableExtraCollection.validate(new ImmutableExtraCollection(this, this.bag, this.index, (ImmutableListMultimap<Integer, String>)newValue, this.indexSet, this.biMap));
    }

    public final ImmutableExtraCollection withIndexSet(Multimap<Integer, ? extends String> entries) {
        if (this.indexSet == entries) {
            return this;
        }
        ImmutableSetMultimap newValue = ImmutableSetMultimap.copyOf(entries);
        return ImmutableExtraCollection.validate(new ImmutableExtraCollection(this, this.bag, this.index, this.indexList, (ImmutableSetMultimap<Integer, String>)newValue, this.biMap));
    }

    public final ImmutableExtraCollection withBiMap(Map<Integer, ? extends String> entries) {
        if (this.biMap == entries) {
            return this;
        }
        ImmutableBiMap newValue = ImmutableBiMap.copyOf(entries);
        return ImmutableExtraCollection.validate(new ImmutableExtraCollection(this, this.bag, this.index, this.indexList, this.indexSet, (ImmutableBiMap<Integer, String>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExtraCollection && this.equalTo(0, (ImmutableExtraCollection)another);
    }

    private boolean equalTo(int synthetic, ImmutableExtraCollection another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.bag.equals(another.bag) && this.index.equals(another.index) && this.indexList.equals(another.indexList) && this.indexSet.equals(another.indexSet) && this.biMap.equals(another.biMap);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.bag.hashCode();
        h += (h << 5) + this.index.hashCode();
        h += (h << 5) + this.indexList.hashCode();
        h += (h << 5) + this.indexSet.hashCode();
        h += (h << 5) + this.biMap.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ExtraCollection").omitNullValues().add("bag", this.bag).add("index", this.index).add("indexList", this.indexList).add("indexSet", this.indexSet).add("biMap", this.biMap).toString();
    }

    public static ImmutableExtraCollection of() {
        return INSTANCE;
    }

    public static ImmutableExtraCollection of(Multiset<String> bag, Multimap<Integer, String> index, ListMultimap<Integer, String> indexList, SetMultimap<Integer, String> indexSet, BiMap<Integer, String> biMap) {
        return ImmutableExtraCollection.of(bag, index, indexList, indexSet, biMap);
    }

    public static ImmutableExtraCollection of(Iterable<String> bag, Multimap<Integer, ? extends String> index, Multimap<Integer, ? extends String> indexList, Multimap<Integer, ? extends String> indexSet, Map<Integer, ? extends String> biMap) {
        return ImmutableExtraCollection.validate(new ImmutableExtraCollection(bag, index, indexList, indexSet, biMap));
    }

    private static ImmutableExtraCollection validate(ImmutableExtraCollection instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableExtraCollection copyOf(ExtraCollection instance) {
        if (instance instanceof ImmutableExtraCollection) {
            return (ImmutableExtraCollection)instance;
        }
        return ImmutableExtraCollection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExtraCollection", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableMultiset.Builder<String> bag = ImmutableMultiset.builder();
        private ImmutableMultimap.Builder<Integer, String> index = ImmutableMultimap.builder();
        private ImmutableListMultimap.Builder<Integer, String> indexList = ImmutableListMultimap.builder();
        private ImmutableSetMultimap.Builder<Integer, String> indexSet = ImmutableSetMultimap.builder();
        private ImmutableBiMap.Builder<Integer, String> biMap = ImmutableBiMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ExtraCollection instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllBag((Iterable<String>)instance.bag());
            this.putAllIndex(instance.index());
            this.putAllIndexList((Multimap<Integer, ? extends String>)instance.indexList());
            this.putAllIndexSet((Multimap<Integer, ? extends String>)instance.indexSet());
            this.putAllBiMap((Map<Integer, ? extends String>)instance.biMap());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addBag(String element) {
            this.bag.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addBag(String ... elements) {
            this.bag.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bag(Iterable<String> elements) {
            this.bag = ImmutableMultiset.builder();
            return this.addAllBag(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllBag(Iterable<String> elements) {
            this.bag.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putIndex(int key, String ... values) {
            this.index.putAll((Object)key, Arrays.asList(values));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAllIndex(int key, Iterable<String> values) {
            this.index.putAll((Object)key, values);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putIndex(int key, String value) {
            this.index.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putIndex(Map.Entry<Integer, ? extends String> entry) {
            this.index.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder index(Multimap<Integer, ? extends String> entries) {
            this.index = ImmutableMultimap.builder();
            return this.putAllIndex(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllIndex(Multimap<Integer, ? extends String> entries) {
            this.index.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putIndexList(int key, String ... values) {
            this.indexList.putAll((Object)key, Arrays.asList(values));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAllIndexList(int key, Iterable<String> values) {
            this.indexList.putAll((Object)key, values);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putIndexList(int key, String value) {
            this.indexList.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putIndexList(Map.Entry<Integer, ? extends String> entry) {
            this.indexList.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder indexList(Multimap<Integer, ? extends String> entries) {
            this.indexList = ImmutableListMultimap.builder();
            return this.putAllIndexList(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllIndexList(Multimap<Integer, ? extends String> entries) {
            this.indexList.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putIndexSet(int key, String ... values) {
            this.indexSet.putAll((Object)key, Arrays.asList(values));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAllIndexSet(int key, Iterable<String> values) {
            this.indexSet.putAll((Object)key, values);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putIndexSet(int key, String value) {
            this.indexSet.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putIndexSet(Map.Entry<Integer, ? extends String> entry) {
            this.indexSet.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder indexSet(Multimap<Integer, ? extends String> entries) {
            this.indexSet = ImmutableSetMultimap.builder();
            return this.putAllIndexSet(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllIndexSet(Multimap<Integer, ? extends String> entries) {
            this.indexSet.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putBiMap(int key, String value) {
            this.biMap.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putBiMap(Map.Entry<Integer, ? extends String> entry) {
            this.biMap.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder biMap(Map<Integer, ? extends String> entries) {
            this.biMap = ImmutableBiMap.builder();
            return this.putAllBiMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllBiMap(Map<Integer, ? extends String> entries) {
            this.biMap.putAll(entries);
            return this;
        }

        public ImmutableExtraCollection build() {
            return ImmutableExtraCollection.validate(new ImmutableExtraCollection(null, this.bag.build(), this.index.build(), this.indexList.build(), this.indexSet.build(), this.biMap.build()));
        }
    }
}

