/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.MultipleChecks;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="MultipleChecks", generator="Immutables")
public final class ImmutableMultipleChecks {
    private ImmutableMultipleChecks() {
    }

    @CheckReturnValue
    @Generated(from="MultipleChecks.C", generator="Immutables")
    @Immutable
    public static final class C
    implements MultipleChecks.C {
        private final int a;
        private final int b;

        private C(int a, int b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public int a() {
            return this.a;
        }

        @Override
        public int b() {
            return this.b;
        }

        public final C withA(int value) {
            if (this.a == value) {
                return this;
            }
            return C.validate(new C(value, this.b));
        }

        public final C withB(int value) {
            if (this.b == value) {
                return this;
            }
            return C.validate(new C(this.a, value));
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof C && this.equalTo(0, (C)another);
        }

        private boolean equalTo(int synthetic, C another) {
            return this.a == another.a && this.b == another.b;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.a;
            h += (h << 5) + this.b;
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"C").omitNullValues().add("a", this.a).add("b", this.b).toString();
        }

        private static C validate(C instance) {
            instance.checkB();
            instance.checkA();
            return instance;
        }

        public static C copyOf(MultipleChecks.C instance) {
            if (instance instanceof C) {
                return (C)instance;
            }
            return C.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="MultipleChecks.C", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_A = 1L;
            private static final long INIT_BIT_B = 2L;
            private long initBits = 3L;
            private int a;
            private int b;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(MultipleChecks.A instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(MultipleChecks.B instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(MultipleChecks.C instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Object instance;
                long bits = 0L;
                if (object instanceof MultipleChecks.A) {
                    instance = (MultipleChecks.A)object;
                    if ((bits & 1L) == 0L) {
                        this.a(instance.a());
                        bits |= 1L;
                    }
                }
                if (object instanceof MultipleChecks.B) {
                    instance = (MultipleChecks.B)object;
                    if ((bits & 2L) == 0L) {
                        this.b(instance.b());
                        bits |= 2L;
                    }
                }
                if (object instanceof MultipleChecks.C) {
                    instance = (MultipleChecks.C)object;
                    if ((bits & 1L) == 0L) {
                        this.a(instance.a());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.b(instance.b());
                        bits |= 2L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder a(int a) {
                this.a = a;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder b(int b) {
                this.b = b;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public C build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return C.validate(new C(this.a, this.b));
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("a");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("b");
                }
                return "Cannot build C, some of required attributes are not set " + attributes;
            }
        }
    }
}

