/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.NullableArray;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NullableArray", generator="Immutables")
@Immutable
public final class ImmutableNullableArray
implements NullableArray {
    @Nullable
    private final byte[] array;

    private ImmutableNullableArray(@Nullable byte[] array) {
        this.array = array;
    }

    @Override
    @Nullable
    public byte[] array() {
        return this.array;
    }

    public final ImmutableNullableArray withArray(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return new ImmutableNullableArray(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNullableArray && this.equalTo(0, (ImmutableNullableArray)another);
    }

    private boolean equalTo(int synthetic, ImmutableNullableArray another) {
        return Arrays.equals(this.array, another.array);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.array);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NullableArray").omitNullValues().add("array", (Object)Arrays.toString(this.array)).toString();
    }

    public static ImmutableNullableArray copyOf(NullableArray instance) {
        if (instance instanceof ImmutableNullableArray) {
            return (ImmutableNullableArray)instance;
        }
        return ImmutableNullableArray.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NullableArray", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private byte[] array;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NullableArray instance) {
            Objects.requireNonNull(instance, "instance");
            byte[] arrayValue = instance.array();
            if (arrayValue != null) {
                this.array(arrayValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder array(byte ... array) {
            this.array = array;
            return this;
        }

        public ImmutableNullableArray build() {
            return new ImmutableNullableArray(this.array);
        }
    }
}

