/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.UnderwriteObjectMethods;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="UnderwriteObjectMethods.Underwrite", generator="Immutables")
@Immutable
public final class ImmutableUnderwrite
extends UnderwriteObjectMethods.Underwrite {
    private final int value;

    private ImmutableUnderwrite(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return this.value;
    }

    public final ImmutableUnderwrite withValue(int value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableUnderwrite(value);
    }

    public static ImmutableUnderwrite copyOf(UnderwriteObjectMethods.Underwrite instance) {
        if (instance instanceof ImmutableUnderwrite) {
            return (ImmutableUnderwrite)instance;
        }
        return ImmutableUnderwrite.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UnderwriteObjectMethods.Underwrite", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        private int value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UnderwriteObjectMethods.Underwrite instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.value());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(int value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableUnderwrite build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUnderwrite(this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build Underwrite, some of required attributes are not set " + attributes;
        }
    }
}

