/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.deep;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.deep.Canvas;
import org.immutables.fixture.deep.ImmutableColor;
import org.immutables.fixture.deep.ImmutablePoint;
import org.immutables.fixture.deep.ModifiableLine;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Canvas.Line", generator="Immutables")
@Immutable
public final class ImmutableLine
implements Canvas.Line {
    private final ImmutableList<Canvas.Point> points;
    private final ImmutableColor color;
    @Nullable
    private final Canvas.Color shadow;

    private ImmutableLine(ImmutableList<Canvas.Point> points, ImmutableColor color, @Nullable Canvas.Color shadow) {
        this.points = points;
        this.color = color;
        this.shadow = shadow;
    }

    public ImmutableList<Canvas.Point> points() {
        return this.points;
    }

    @Override
    public ImmutableColor color() {
        return this.color;
    }

    @Override
    public Optional<Canvas.Color> shadow() {
        return Optional.ofNullable(this.shadow);
    }

    public final ImmutableLine withPoints(Canvas.Point ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableLine((ImmutableList<Canvas.Point>)newValue, this.color, this.shadow);
    }

    public final ImmutableLine withPoints(Iterable<? extends Canvas.Point> elements) {
        if (this.points == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableLine((ImmutableList<Canvas.Point>)newValue, this.color, this.shadow);
    }

    public final ImmutableLine withColor(Canvas.Color value) {
        if (this.color == value) {
            return this;
        }
        ImmutableColor newValue = ImmutableColor.copyOf(value);
        return new ImmutableLine(this.points, newValue, this.shadow);
    }

    public final ImmutableLine withShadow(Canvas.Color value) {
        Canvas.Color newValue = Objects.requireNonNull(value, "shadow");
        if (this.shadow == newValue) {
            return this;
        }
        return new ImmutableLine(this.points, this.color, newValue);
    }

    public final ImmutableLine withShadow(Optional<? extends Canvas.Color> optional) {
        Canvas.Color value = optional.orElse(null);
        if (this.shadow == value) {
            return this;
        }
        return new ImmutableLine(this.points, this.color, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLine && this.equalTo(0, (ImmutableLine)another);
    }

    private boolean equalTo(int synthetic, ImmutableLine another) {
        return this.points.equals(another.points) && this.color.equals(another.color) && Objects.equals(this.shadow, another.shadow);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.points.hashCode();
        h += (h << 5) + this.color.hashCode();
        h += (h << 5) + Objects.hashCode(this.shadow);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Line").omitNullValues().add("points", this.points).add("color", (Object)this.color).add("shadow", (Object)this.shadow).toString();
    }

    public static ImmutableLine copyOf(Canvas.Line instance) {
        if (instance instanceof ImmutableLine) {
            return (ImmutableLine)instance;
        }
        return ImmutableLine.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Canvas.Line", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COLOR = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<Canvas.Point> points = ImmutableList.builder();
        @Nullable
        private Canvas.Color color;
        @Nullable
        private Canvas.Color shadow;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ModifiableLine instance) {
            Optional<Canvas.Color> shadowOptional;
            Objects.requireNonNull(instance, "instance");
            this.addAllPoints(instance.points());
            if (instance.colorIsSet()) {
                this.color(instance.color());
            }
            if ((shadowOptional = instance.shadow()).isPresent()) {
                this.shadow(shadowOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Canvas.Line instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableLine) {
                return this.from((ModifiableLine)instance);
            }
            this.addAllPoints(instance.points());
            this.color(instance.color());
            Optional<Canvas.Color> shadowOptional = instance.shadow();
            if (shadowOptional.isPresent()) {
                this.shadow(shadowOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPoint(Canvas.Point element) {
            element = ImmutablePoint.copyOf(element);
            this.points.add((Object)element);
            return this;
        }

        public final Builder addPoint(int x, int y) {
            return this.addPoint(ImmutablePoint.of(x, y));
        }

        @CanIgnoreReturnValue
        public final Builder addPoints(Canvas.Point ... elements) {
            for (Canvas.Point element : elements) {
                element = ImmutablePoint.copyOf(element);
                this.points.add((Object)Objects.requireNonNull(element, "points element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder points(Iterable<? extends Canvas.Point> elements) {
            this.points = ImmutableList.builder();
            return this.addAllPoints(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPoints(Iterable<? extends Canvas.Point> elements) {
            for (Canvas.Point point : elements) {
                ImmutablePoint immutablePoint = ImmutablePoint.copyOf(point);
                this.points.add((Object)Objects.requireNonNull(immutablePoint, "points element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder color(double red, double green, double blue) {
            return this.color(ImmutableColor.of(red, green, blue));
        }

        @CanIgnoreReturnValue
        public final Builder color(Canvas.Color color) {
            this.color = ImmutableColor.copyOf(color);
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder shadow(Canvas.Color shadow) {
            this.shadow = Objects.requireNonNull(shadow, "shadow");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder shadow(double red, double green, double blue) {
            return this.shadow(ImmutableColor.of(red, green, blue));
        }

        @CanIgnoreReturnValue
        public final Builder shadow(Optional<? extends Canvas.Color> shadow) {
            this.shadow = shadow.orElse(null);
            return this;
        }

        public ImmutableLine build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLine(this.points.build(), ImmutableColor.copyOf(this.color), this.shadow);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("color");
            }
            return "Cannot build Line, some of required attributes are not set " + attributes;
        }
    }
}

