/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.generics.FromGenericInh;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FromGenericInh.Baz", generator="Immutables")
@Immutable
public final class ImmutableBaz
implements FromGenericInh.Baz {
    private final FromGenericInh.Bar foo;
    private final String barId;
    private final String bazId;

    private ImmutableBaz(FromGenericInh.Bar foo, String barId, String bazId) {
        this.foo = foo;
        this.barId = barId;
        this.bazId = bazId;
    }

    @Override
    public FromGenericInh.Bar getFoo() {
        return this.foo;
    }

    @Override
    public String getBarId() {
        return this.barId;
    }

    @Override
    public String getBazId() {
        return this.bazId;
    }

    public final ImmutableBaz withFoo(FromGenericInh.Bar value) {
        if (this.foo == value) {
            return this;
        }
        FromGenericInh.Bar newValue = Objects.requireNonNull(value, "foo");
        return new ImmutableBaz(newValue, this.barId, this.bazId);
    }

    public final ImmutableBaz withBarId(String value) {
        String newValue = Objects.requireNonNull(value, "barId");
        if (this.barId.equals(newValue)) {
            return this;
        }
        return new ImmutableBaz(this.foo, newValue, this.bazId);
    }

    public final ImmutableBaz withBazId(String value) {
        String newValue = Objects.requireNonNull(value, "bazId");
        if (this.bazId.equals(newValue)) {
            return this;
        }
        return new ImmutableBaz(this.foo, this.barId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBaz && this.equalTo(0, (ImmutableBaz)another);
    }

    private boolean equalTo(int synthetic, ImmutableBaz another) {
        return this.foo.equals(another.foo) && this.barId.equals(another.barId) && this.bazId.equals(another.bazId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.foo.hashCode();
        h += (h << 5) + this.barId.hashCode();
        h += (h << 5) + this.bazId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Baz").omitNullValues().add("foo", (Object)this.foo).add("barId", (Object)this.barId).add("bazId", (Object)this.bazId).toString();
    }

    public static ImmutableBaz copyOf(FromGenericInh.Baz instance) {
        if (instance instanceof ImmutableBaz) {
            return (ImmutableBaz)instance;
        }
        return ImmutableBaz.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FromGenericInh.Baz", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FOO = 1L;
        private static final long INIT_BIT_BAR_ID = 2L;
        private static final long INIT_BIT_BAZ_ID = 4L;
        private long initBits = 7L;
        @Nullable
        private FromGenericInh.Bar foo;
        @Nullable
        private String barId;
        @Nullable
        private String bazId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FromGenericInh.Baz instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(FromGenericInh.Bar instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            FromGenericInh.Bar instance;
            long bits = 0L;
            if (object instanceof FromGenericInh.Baz) {
                instance = (FromGenericInh.Baz)object;
                this.bazId(instance.getBazId());
                if ((bits & 1L) == 0L) {
                    this.barId(instance.getBarId());
                    bits |= 1L;
                }
                this.foo((FromGenericInh.Bar)instance.getFoo());
            }
            if (object instanceof FromGenericInh.Bar) {
                instance = (FromGenericInh.Bar)object;
                if ((bits & 1L) == 0L) {
                    this.barId(instance.getBarId());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder foo(FromGenericInh.Bar foo) {
            this.foo = Objects.requireNonNull(foo, "foo");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder barId(String barId) {
            this.barId = Objects.requireNonNull(barId, "barId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bazId(String bazId) {
            this.bazId = Objects.requireNonNull(bazId, "bazId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableBaz build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBaz(this.foo, this.barId, this.bazId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("foo");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("barId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("bazId");
            }
            return "Cannot build Baz, some of required attributes are not set " + attributes;
        }
    }
}

