/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.PolymorphicMappings;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PolymorphicMappings.DatasetIdLocator", generator="Immutables")
@Immutable
final class ImmutableDatasetIdLocator
implements PolymorphicMappings.DatasetIdLocator {
    private final String datasetId;

    private ImmutableDatasetIdLocator(String datasetId) {
        this.datasetId = datasetId;
    }

    @Override
    @JsonProperty(value="datasetId")
    public String getDatasetId() {
        return this.datasetId;
    }

    public final ImmutableDatasetIdLocator withDatasetId(String value) {
        String newValue = Objects.requireNonNull(value, "datasetId");
        if (this.datasetId.equals(newValue)) {
            return this;
        }
        return new ImmutableDatasetIdLocator(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDatasetIdLocator && this.equalTo(0, (ImmutableDatasetIdLocator)another);
    }

    private boolean equalTo(int synthetic, ImmutableDatasetIdLocator another) {
        return this.datasetId.equals(another.datasetId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.datasetId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DatasetIdLocator").omitNullValues().add("datasetId", (Object)this.datasetId).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDatasetIdLocator fromJson(Json json) {
        PolymorphicMappings.DatasetIdLocator.Builder builder = new PolymorphicMappings.DatasetIdLocator.Builder();
        if (json.datasetId != null) {
            builder.datasetId(json.datasetId);
        }
        return builder.build();
    }

    public static ImmutableDatasetIdLocator copyOf(PolymorphicMappings.DatasetIdLocator instance) {
        if (instance instanceof ImmutableDatasetIdLocator) {
            return (ImmutableDatasetIdLocator)instance;
        }
        return new PolymorphicMappings.DatasetIdLocator.Builder().from(instance).build();
    }

    @Generated(from="PolymorphicMappings.DatasetIdLocator", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_DATASET_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String datasetId;

        public Builder() {
            if (!(this instanceof PolymorphicMappings.DatasetIdLocator.Builder)) {
                throw new UnsupportedOperationException("Use: new PolymorphicMappings.DatasetIdLocator.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final PolymorphicMappings.DatasetIdLocator.Builder from(PolymorphicMappings.DatasetIdLocator instance) {
            Objects.requireNonNull(instance, "instance");
            this.datasetId(instance.getDatasetId());
            return (PolymorphicMappings.DatasetIdLocator.Builder)this;
        }

        @JsonProperty(value="datasetId")
        @CanIgnoreReturnValue
        public final PolymorphicMappings.DatasetIdLocator.Builder datasetId(String datasetId) {
            this.datasetId = Objects.requireNonNull(datasetId, "datasetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (PolymorphicMappings.DatasetIdLocator.Builder)this;
        }

        public ImmutableDatasetIdLocator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDatasetIdLocator(this.datasetId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("datasetId");
            }
            return "Cannot build DatasetIdLocator, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PolymorphicMappings.DatasetIdLocator", generator="Immutables")
    static final class Json
    implements PolymorphicMappings.DatasetIdLocator {
        @Nullable
        String datasetId;

        Json() {
        }

        @JsonProperty(value="datasetId")
        public void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public String getDatasetId() {
            throw new UnsupportedOperationException();
        }
    }
}

