/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.PolymorphicMappings;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PolymorphicMappings.DatasetPathLocator", generator="Immutables")
@Immutable
final class ImmutableDatasetPathLocator
implements PolymorphicMappings.DatasetPathLocator {
    private final String datasetPath;

    private ImmutableDatasetPathLocator(String datasetPath) {
        this.datasetPath = datasetPath;
    }

    @Override
    @JsonProperty(value="datasetPath")
    public String getDatasetPath() {
        return this.datasetPath;
    }

    public final ImmutableDatasetPathLocator withDatasetPath(String value) {
        String newValue = Objects.requireNonNull(value, "datasetPath");
        if (this.datasetPath.equals(newValue)) {
            return this;
        }
        return new ImmutableDatasetPathLocator(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDatasetPathLocator && this.equalTo(0, (ImmutableDatasetPathLocator)another);
    }

    private boolean equalTo(int synthetic, ImmutableDatasetPathLocator another) {
        return this.datasetPath.equals(another.datasetPath);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.datasetPath.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DatasetPathLocator").omitNullValues().add("datasetPath", (Object)this.datasetPath).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDatasetPathLocator fromJson(Json json) {
        PolymorphicMappings.DatasetPathLocator.Builder builder = new PolymorphicMappings.DatasetPathLocator.Builder();
        if (json.datasetPath != null) {
            builder.datasetPath(json.datasetPath);
        }
        return builder.build();
    }

    public static ImmutableDatasetPathLocator copyOf(PolymorphicMappings.DatasetPathLocator instance) {
        if (instance instanceof ImmutableDatasetPathLocator) {
            return (ImmutableDatasetPathLocator)instance;
        }
        return new PolymorphicMappings.DatasetPathLocator.Builder().from(instance).build();
    }

    @Generated(from="PolymorphicMappings.DatasetPathLocator", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_DATASET_PATH = 1L;
        private long initBits = 1L;
        @Nullable
        private String datasetPath;

        public Builder() {
            if (!(this instanceof PolymorphicMappings.DatasetPathLocator.Builder)) {
                throw new UnsupportedOperationException("Use: new PolymorphicMappings.DatasetPathLocator.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final PolymorphicMappings.DatasetPathLocator.Builder from(PolymorphicMappings.DatasetPathLocator instance) {
            Objects.requireNonNull(instance, "instance");
            this.datasetPath(instance.getDatasetPath());
            return (PolymorphicMappings.DatasetPathLocator.Builder)this;
        }

        @JsonProperty(value="datasetPath")
        @CanIgnoreReturnValue
        public final PolymorphicMappings.DatasetPathLocator.Builder datasetPath(String datasetPath) {
            this.datasetPath = Objects.requireNonNull(datasetPath, "datasetPath");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (PolymorphicMappings.DatasetPathLocator.Builder)this;
        }

        public ImmutableDatasetPathLocator build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDatasetPathLocator(this.datasetPath);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("datasetPath");
            }
            return "Cannot build DatasetPathLocator, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PolymorphicMappings.DatasetPathLocator", generator="Immutables")
    static final class Json
    implements PolymorphicMappings.DatasetPathLocator {
        @Nullable
        String datasetPath;

        Json() {
        }

        @JsonProperty(value="datasetPath")
        public void setDatasetPath(String datasetPath) {
            this.datasetPath = datasetPath;
        }

        @Override
        public String getDatasetPath() {
            throw new UnsupportedOperationException();
        }
    }
}

