/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.GeoPoint;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GeoPoint", generator="Immutables")
@Immutable
public final class ImmutableGeoPoint
extends GeoPoint {
    private final double altitude;
    private final double longitude;
    private final double latitude;

    private ImmutableGeoPoint(double altitude, double longitude, double latitude) {
        this.altitude = altitude;
        this.longitude = longitude;
        this.latitude = latitude;
    }

    @Override
    @JsonProperty(value="altitude")
    public double altitude() {
        return this.altitude;
    }

    @Override
    @JsonProperty(value="longitude")
    public double longitude() {
        return this.longitude;
    }

    @Override
    @JsonProperty(value="latitude")
    public double latitude() {
        return this.latitude;
    }

    public final ImmutableGeoPoint withAltitude(double value) {
        if (Double.doubleToLongBits(this.altitude) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableGeoPoint(value, this.longitude, this.latitude);
    }

    public final ImmutableGeoPoint withLongitude(double value) {
        if (Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableGeoPoint(this.altitude, value, this.latitude);
    }

    public final ImmutableGeoPoint withLatitude(double value) {
        if (Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableGeoPoint(this.altitude, this.longitude, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGeoPoint && this.equalTo(0, (ImmutableGeoPoint)another);
    }

    private boolean equalTo(int synthetic, ImmutableGeoPoint another) {
        return Double.doubleToLongBits(this.altitude) == Double.doubleToLongBits(another.altitude) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(another.longitude) && Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(another.latitude);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Doubles.hashCode((double)this.altitude);
        h += (h << 5) + Doubles.hashCode((double)this.longitude);
        h += (h << 5) + Doubles.hashCode((double)this.latitude);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GeoPoint").omitNullValues().add("altitude", this.altitude).add("longitude", this.longitude).add("latitude", this.latitude).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGeoPoint fromJson(Json json) {
        Builder builder = ImmutableGeoPoint.builder();
        if (json.altitudeIsSet) {
            builder.altitude(json.altitude);
        }
        if (json.longitudeIsSet) {
            builder.longitude(json.longitude);
        }
        if (json.latitudeIsSet) {
            builder.latitude(json.latitude);
        }
        return builder.build();
    }

    public static ImmutableGeoPoint copyOf(GeoPoint instance) {
        if (instance instanceof ImmutableGeoPoint) {
            return (ImmutableGeoPoint)instance;
        }
        return ImmutableGeoPoint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GeoPoint", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ALTITUDE = 1L;
        private static final long INIT_BIT_LONGITUDE = 2L;
        private static final long INIT_BIT_LATITUDE = 4L;
        private long initBits = 7L;
        private double altitude;
        private double longitude;
        private double latitude;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GeoPoint instance) {
            Objects.requireNonNull(instance, "instance");
            this.altitude(instance.altitude());
            this.longitude(instance.longitude());
            this.latitude(instance.latitude());
            return this;
        }

        @JsonProperty(value="altitude")
        @CanIgnoreReturnValue
        public final Builder altitude(double altitude) {
            this.altitude = altitude;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="longitude")
        @CanIgnoreReturnValue
        public final Builder longitude(double longitude) {
            this.longitude = longitude;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="latitude")
        @CanIgnoreReturnValue
        public final Builder latitude(double latitude) {
            this.latitude = latitude;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGeoPoint build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGeoPoint(this.altitude, this.longitude, this.latitude);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("altitude");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("longitude");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("latitude");
            }
            return "Cannot build GeoPoint, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GeoPoint", generator="Immutables")
    static final class Json
    extends GeoPoint {
        double altitude;
        boolean altitudeIsSet;
        double longitude;
        boolean longitudeIsSet;
        double latitude;
        boolean latitudeIsSet;

        Json() {
        }

        @JsonProperty(value="altitude")
        public void setAltitude(double altitude) {
            this.altitude = altitude;
            this.altitudeIsSet = true;
        }

        @JsonProperty(value="longitude")
        public void setLongitude(double longitude) {
            this.longitude = longitude;
            this.longitudeIsSet = true;
        }

        @JsonProperty(value="latitude")
        public void setLatitude(double latitude) {
            this.latitude = latitude;
            this.latitudeIsSet = true;
        }

        @Override
        public double altitude() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double longitude() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double latitude() {
            throw new UnsupportedOperationException();
        }
    }
}

