/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Doubles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.GeoPoint2;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GeoPoint2", generator="Immutables")
@Immutable
public final class ImmutableGeoPoint2
extends GeoPoint2 {
    private final double lon;
    private final double lat;

    private ImmutableGeoPoint2(double lon, double lat) {
        this.lon = lon;
        this.lat = lat;
    }

    @Override
    @JsonProperty(value="lon")
    public double lon() {
        return this.lon;
    }

    @Override
    @JsonProperty(value="lat")
    public double lat() {
        return this.lat;
    }

    public final ImmutableGeoPoint2 withLon(double value) {
        if (Double.doubleToLongBits(this.lon) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableGeoPoint2(value, this.lat);
    }

    public final ImmutableGeoPoint2 withLat(double value) {
        if (Double.doubleToLongBits(this.lat) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableGeoPoint2(this.lon, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGeoPoint2 && this.equalTo(0, (ImmutableGeoPoint2)another);
    }

    private boolean equalTo(int synthetic, ImmutableGeoPoint2 another) {
        return Double.doubleToLongBits(this.lon) == Double.doubleToLongBits(another.lon) && Double.doubleToLongBits(this.lat) == Double.doubleToLongBits(another.lat);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Doubles.hashCode((double)this.lon);
        h += (h << 5) + Doubles.hashCode((double)this.lat);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GeoPoint2").omitNullValues().add("lon", this.lon).add("lat", this.lat).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGeoPoint2 fromJson(Json json) {
        Builder builder = ImmutableGeoPoint2.builder();
        if (json.lonIsSet) {
            builder.lon(json.lon);
        }
        if (json.latIsSet) {
            builder.lat(json.lat);
        }
        return builder.build();
    }

    public static ImmutableGeoPoint2 copyOf(GeoPoint2 instance) {
        if (instance instanceof ImmutableGeoPoint2) {
            return (ImmutableGeoPoint2)instance;
        }
        return ImmutableGeoPoint2.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GeoPoint2", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LON = 1L;
        private static final long INIT_BIT_LAT = 2L;
        private long initBits = 3L;
        private double lon;
        private double lat;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GeoPoint2 instance) {
            Objects.requireNonNull(instance, "instance");
            this.lon(instance.lon());
            this.lat(instance.lat());
            return this;
        }

        @JsonProperty(value="lon")
        @CanIgnoreReturnValue
        public final Builder lon(double lon) {
            this.lon = lon;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="lat")
        @CanIgnoreReturnValue
        public final Builder lat(double lat) {
            this.lat = lat;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGeoPoint2 build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGeoPoint2(this.lon, this.lat);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("lon");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("lat");
            }
            return "Cannot build GeoPoint2, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GeoPoint2", generator="Immutables")
    static final class Json
    extends GeoPoint2 {
        double lon;
        boolean lonIsSet;
        double lat;
        boolean latIsSet;

        Json() {
        }

        @JsonProperty(value="lon")
        public void setLon(double lon) {
            this.lon = lon;
            this.lonIsSet = true;
        }

        @JsonProperty(value="lat")
        public void setLat(double lat) {
            this.lat = lat;
            this.latIsSet = true;
        }

        @Override
        public double lon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double lat() {
            throw new UnsupportedOperationException();
        }
    }
}

