/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.JacksonGenerics;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JacksonGenerics", generator="Immutables")
@Immutable
public final class ImmutableJacksonGenerics<T extends Number>
implements JacksonGenerics<T> {
    private final T attr;
    private final String nm;

    private ImmutableJacksonGenerics(T attr, String nm) {
        this.attr = attr;
        this.nm = nm;
    }

    @Override
    @JsonProperty(value="attr")
    public T attr() {
        return this.attr;
    }

    @Override
    @JsonProperty(value="nm")
    public String nm() {
        return this.nm;
    }

    public final ImmutableJacksonGenerics<T> withAttr(T value) {
        if (this.attr == value) {
            return this;
        }
        Number newValue = (Number)Objects.requireNonNull(value, "attr");
        return new ImmutableJacksonGenerics<Number>(newValue, this.nm);
    }

    public final ImmutableJacksonGenerics<T> withNm(String value) {
        String newValue = Objects.requireNonNull(value, "nm");
        if (this.nm.equals(newValue)) {
            return this;
        }
        return new ImmutableJacksonGenerics<T>(this.attr, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJacksonGenerics && this.equalTo(0, (ImmutableJacksonGenerics)another);
    }

    private boolean equalTo(int synthetic, ImmutableJacksonGenerics<?> another) {
        return this.attr.equals(another.attr) && this.nm.equals(another.nm);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.attr.hashCode();
        h += (h << 5) + this.nm.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JacksonGenerics").omitNullValues().add("attr", this.attr).add("nm", (Object)this.nm).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <T extends Number> ImmutableJacksonGenerics<T> fromJson(Json<T> json) {
        Builder builder = ImmutableJacksonGenerics.builder();
        if (json.attr != null) {
            builder.attr(json.attr);
        }
        if (json.nm != null) {
            builder.nm(json.nm);
        }
        return builder.build();
    }

    public static <T extends Number> ImmutableJacksonGenerics<T> copyOf(JacksonGenerics<T> instance) {
        if (instance instanceof ImmutableJacksonGenerics) {
            return (ImmutableJacksonGenerics)instance;
        }
        return ImmutableJacksonGenerics.builder().from(instance).build();
    }

    public static <T extends Number> Builder<T> builder() {
        return new Builder();
    }

    /* synthetic */ ImmutableJacksonGenerics(Number x0, String x1, 1 x2) {
        this(x0, x1);
    }

    @Generated(from="JacksonGenerics", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T extends Number> {
        private static final long INIT_BIT_ATTR = 1L;
        private static final long INIT_BIT_NM = 2L;
        private long initBits = 3L;
        @Nullable
        private T attr;
        @Nullable
        private String nm;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(JacksonGenerics<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.attr(instance.attr());
            this.nm(instance.nm());
            return this;
        }

        @JsonProperty(value="attr")
        @CanIgnoreReturnValue
        public final Builder<T> attr(T attr) {
            this.attr = (Number)Objects.requireNonNull(attr, "attr");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="nm")
        @CanIgnoreReturnValue
        public final Builder<T> nm(String nm) {
            this.nm = Objects.requireNonNull(nm, "nm");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableJacksonGenerics<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJacksonGenerics((Number)this.attr, this.nm, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("attr");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("nm");
            }
            return "Cannot build JacksonGenerics, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="JacksonGenerics", generator="Immutables")
    static final class Json<T extends Number>
    implements JacksonGenerics<T> {
        @Nullable
        T attr;
        @Nullable
        String nm;

        Json() {
        }

        @JsonProperty(value="attr")
        public void setAttr(T attr) {
            this.attr = attr;
        }

        @JsonProperty(value="nm")
        public void setNm(String nm) {
            this.nm = nm;
        }

        @Override
        public T attr() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String nm() {
            throw new UnsupportedOperationException();
        }
    }
}

