/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.LazyAttributesSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LazyAttributesSafe", generator="Immutables")
@Immutable
public final class ImmutableLazyAttributesSafe
extends LazyAttributesSafe {
    private final int a;
    private final transient String derived;
    private final int defaults;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long LAZY_LAZY_INIT_BIT = 1L;
    private transient String lazy;

    private ImmutableLazyAttributesSafe(Builder builder) {
        this.a = builder.a;
        if (builder.defaultsIsSet()) {
            this.initShim.defaults(builder.defaults);
        }
        this.derived = this.initShim.getDerived();
        this.defaults = this.initShim.getDefaults();
        this.initShim = null;
    }

    private ImmutableLazyAttributesSafe(int a, int defaults) {
        this.a = a;
        this.initShim.defaults(defaults);
        this.derived = this.initShim.getDerived();
        this.defaults = this.initShim.getDefaults();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="a")
    public int getA() {
        return this.a;
    }

    @Override
    @JsonProperty(value="derived")
    public String getDerived() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDerived() : this.derived;
    }

    @Override
    @JsonProperty(value="defaults")
    public int getDefaults() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDefaults() : this.defaults;
    }

    public final ImmutableLazyAttributesSafe withA(int value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableLazyAttributesSafe(value, this.defaults);
    }

    public final ImmutableLazyAttributesSafe withDefaults(int value) {
        if (this.defaults == value) {
            return this;
        }
        return new ImmutableLazyAttributesSafe(this.a, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLazyAttributesSafe && this.equalTo(0, (ImmutableLazyAttributesSafe)another);
    }

    private boolean equalTo(int synthetic, ImmutableLazyAttributesSafe another) {
        return this.a == another.a && this.derived.equals(another.derived) && this.defaults == another.defaults;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.a;
        h += (h << 5) + this.derived.hashCode();
        h += (h << 5) + this.defaults;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LazyAttributesSafe").omitNullValues().add("a", this.a).add("derived", (Object)this.derived).add("defaults", this.defaults).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLazyAttributesSafe fromJson(Json json) {
        Builder builder = ImmutableLazyAttributesSafe.builder();
        if (json.aIsSet) {
            builder.a(json.a);
        }
        if (json.defaultsIsSet) {
            builder.defaults(json.defaults);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLazy() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableLazyAttributesSafe immutableLazyAttributesSafe = this;
            synchronized (immutableLazyAttributesSafe) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.lazy = Objects.requireNonNull(super.getLazy(), "lazy");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.lazy;
    }

    public static ImmutableLazyAttributesSafe copyOf(LazyAttributesSafe instance) {
        if (instance instanceof ImmutableLazyAttributesSafe) {
            return (ImmutableLazyAttributesSafe)instance;
        }
        return ImmutableLazyAttributesSafe.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LazyAttributesSafe", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private static final long OPT_BIT_DEFAULTS = 1L;
        private long initBits = 1L;
        private long optBits;
        private int a;
        private int defaults;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(LazyAttributesSafe instance) {
            Objects.requireNonNull(instance, "instance");
            this.a(instance.getA());
            this.defaults(instance.getDefaults());
            return this;
        }

        @JsonProperty(value="a")
        @CanIgnoreReturnValue
        public final Builder a(int a) {
            this.a = a;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="defaults")
        @CanIgnoreReturnValue
        public final Builder defaults(int defaults) {
            this.defaults = defaults;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableLazyAttributesSafe build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLazyAttributesSafe(this);
        }

        private boolean defaultsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            return "Cannot build LazyAttributesSafe, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LazyAttributesSafe", generator="Immutables")
    static final class Json
    extends LazyAttributesSafe {
        int a;
        boolean aIsSet;
        int defaults;
        boolean defaultsIsSet;

        Json() {
        }

        @JsonProperty(value="a")
        public void setA(int a) {
            this.a = a;
            this.aIsSet = true;
        }

        @JsonProperty(value="defaults")
        public void setDefaults(int defaults) {
            this.defaults = defaults;
            this.defaultsIsSet = true;
        }

        @Override
        public int getA() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getDerived() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDefaults() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLazy() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="LazyAttributesSafe", generator="Immutables")
    private final class InitShim {
        private byte derivedBuildStage = 0;
        private String derived;
        private byte defaultsBuildStage = 0;
        private int defaults;

        private InitShim() {
        }

        String getDerived() {
            if (this.derivedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.derivedBuildStage == 0) {
                this.derivedBuildStage = (byte)-1;
                this.derived = Objects.requireNonNull(ImmutableLazyAttributesSafe.super.getDerived(), "derived");
                this.derivedBuildStage = 1;
            }
            return this.derived;
        }

        int getDefaults() {
            if (this.defaultsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultsBuildStage == 0) {
                this.defaultsBuildStage = (byte)-1;
                this.defaults = ImmutableLazyAttributesSafe.super.getDefaults();
                this.defaultsBuildStage = 1;
            }
            return this.defaults;
        }

        void defaults(int defaults) {
            this.defaults = defaults;
            this.defaultsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.derivedBuildStage == -1) {
                attributes.add("derived");
            }
            if (this.defaultsBuildStage == -1) {
                attributes.add("defaults");
            }
            return "Cannot build LazyAttributesSafe, attribute initializers form cycle " + attributes;
        }
    }
}

