/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.Inherited;
import org.immutables.fixture.jackson.OptionIncludeNonEmpty;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OptionIncludeNonEmpty", generator="Immutables")
@Immutable
public final class ImmutableOptionIncludeNonEmpty
extends OptionIncludeNonEmpty {
    @Nullable
    private final Integer integer;
    private final Optional<String> relationships;
    private final ImmutableMap<String, Number> map;

    private ImmutableOptionIncludeNonEmpty(@Nullable Integer integer, Optional<String> relationships, ImmutableMap<String, Number> map) {
        this.integer = integer;
        this.relationships = relationships;
        this.map = map;
    }

    @Override
    @JsonProperty(value="integer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Integer getInteger() {
        return this.integer;
    }

    @Override
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Optional<String> getRelationships() {
        return this.relationships;
    }

    @JsonProperty(value="map")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public ImmutableMap<String, Number> getMap() {
        return this.map;
    }

    public final ImmutableOptionIncludeNonEmpty withInteger(@Nullable Integer value) {
        if (Objects.equals(this.integer, value)) {
            return this;
        }
        return new ImmutableOptionIncludeNonEmpty(value, this.relationships, this.map);
    }

    public final ImmutableOptionIncludeNonEmpty withRelationships(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.relationships.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableOptionIncludeNonEmpty(this.integer, (Optional<String>)newValue, this.map);
    }

    @Override
    public final ImmutableOptionIncludeNonEmpty withRelationships(Optional<String> optional) {
        Optional<String> value = optional;
        if (this.relationships.equals(value)) {
            return this;
        }
        return new ImmutableOptionIncludeNonEmpty(this.integer, value, this.map);
    }

    @Override
    public final ImmutableOptionIncludeNonEmpty withMap(Map<String, ? extends Number> entries) {
        if (this.map == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableOptionIncludeNonEmpty(this.integer, this.relationships, (ImmutableMap<String, Number>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOptionIncludeNonEmpty && this.equalTo(0, (ImmutableOptionIncludeNonEmpty)another);
    }

    private boolean equalTo(int synthetic, ImmutableOptionIncludeNonEmpty another) {
        return Objects.equals(this.integer, another.integer) && this.relationships.equals(another.relationships) && this.map.equals(another.map);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.integer);
        h += (h << 5) + this.relationships.hashCode();
        h += (h << 5) + this.map.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OptionIncludeNonEmpty").omitNullValues().add("integer", (Object)this.integer).add("relationships", this.relationships.orNull()).add("map", this.map).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOptionIncludeNonEmpty fromJson(Json json) {
        Builder builder = ImmutableOptionIncludeNonEmpty.builder();
        if (json.integer != null) {
            builder.integer(json.integer);
        }
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        if (json.map != null) {
            builder.putAllMap(json.map);
        }
        return builder.build();
    }

    public static ImmutableOptionIncludeNonEmpty copyOf(OptionIncludeNonEmpty instance) {
        if (instance instanceof ImmutableOptionIncludeNonEmpty) {
            return (ImmutableOptionIncludeNonEmpty)instance;
        }
        return ImmutableOptionIncludeNonEmpty.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OptionIncludeNonEmpty", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Integer integer;
        private Optional<String> relationships = Optional.absent();
        private ImmutableMap.Builder<String, Number> map = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OptionIncludeNonEmpty instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Inherited instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Integer integerValue;
            Inherited instance;
            if (object instanceof OptionIncludeNonEmpty) {
                instance = (OptionIncludeNonEmpty)object;
                Optional<String> relationshipsOptional = ((OptionIncludeNonEmpty)instance).getRelationships();
                if (relationshipsOptional.isPresent()) {
                    this.relationships(relationshipsOptional);
                }
                this.putAllMap(((OptionIncludeNonEmpty)instance).getMap());
            }
            if (object instanceof Inherited && (integerValue = (instance = (Inherited)object).getInteger()) != null) {
                this.integer(integerValue);
            }
        }

        @JsonProperty(value="integer")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @CanIgnoreReturnValue
        public final Builder integer(@Nullable Integer integer) {
            this.integer = integer;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder relationships(String relationships) {
            this.relationships = Optional.of((Object)relationships);
            return this;
        }

        @JsonProperty(value="relationships")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @CanIgnoreReturnValue
        public final Builder relationships(Optional<String> relationships) {
            this.relationships = relationships;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(String key, Number value) {
            this.map.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(Map.Entry<String, ? extends Number> entry) {
            this.map.put(entry);
            return this;
        }

        @JsonProperty(value="map")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @CanIgnoreReturnValue
        public final Builder map(Map<String, ? extends Number> entries) {
            this.map = ImmutableMap.builder();
            return this.putAllMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMap(Map<String, ? extends Number> entries) {
            this.map.putAll(entries);
            return this;
        }

        public ImmutableOptionIncludeNonEmpty build() {
            return new ImmutableOptionIncludeNonEmpty(this.integer, this.relationships, this.map.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OptionIncludeNonEmpty", generator="Immutables")
    static final class Json
    extends OptionIncludeNonEmpty {
        @Nullable
        Integer integer;
        @Nullable
        Optional<String> relationships = Optional.absent();
        @Nullable
        Map<String, Number> map = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="integer")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setInteger(@Nullable Integer integer) {
            this.integer = integer;
        }

        @JsonProperty(value="relationships")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setRelationships(Optional<String> relationships) {
            this.relationships = relationships;
        }

        @JsonProperty(value="map")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setMap(Map<String, Number> map) {
            this.map = map;
        }

        @Override
        public OptionIncludeNonEmpty withRelationships(Optional<String> number) {
            throw new UnsupportedOperationException();
        }

        @Override
        public OptionIncludeNonEmpty withMap(Map<String, ? extends Number> number) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getInteger() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRelationships() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Number> getMap() {
            throw new UnsupportedOperationException();
        }
    }
}

