/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson.poly2;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.poly2.Payload;
import org.immutables.fixture.jackson.poly2.PayloadOne;
import org.immutables.fixture.jackson.poly2.PayloadTwo;
import org.immutables.fixture.jackson.poly2._AbstractResponse;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="_AbstractResponse", generator="Immutables")
@Immutable
public final class AbstractResponse
extends _AbstractResponse {
    private final String type;
    private final Payload payload;

    private AbstractResponse(Builder builder) {
        this.type = builder.type;
        this.payload = builder.payload;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @Override
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(name="one", value=PayloadOne.class), @JsonSubTypes.Type(name="two", value=PayloadTwo.class)})
    @JsonProperty(value="payload")
    public Payload getPayload() {
        return this.payload;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AbstractResponse && this.equalTo(0, (AbstractResponse)another);
    }

    private boolean equalTo(int synthetic, AbstractResponse another) {
        return this.type.equals(another.type) && this.payload.equals(another.payload);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.payload.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AbstractResponse").omitNullValues().add("type", (Object)this.type).add("payload", (Object)this.payload).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static AbstractResponse fromJson(Json json) {
        Builder builder = AbstractResponse.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.payload != null) {
            builder.payload(json.payload);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_AbstractResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_PAYLOAD = 2L;
        private long initBits = 3L;
        @Nullable
        private String type;
        @Nullable
        private Payload payload;

        private Builder() {
        }

        public final Builder from(AbstractResponse instance) {
            return this.from((_AbstractResponse)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(_AbstractResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.getType());
            this.payload(instance.getPayload());
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="type")
        @JsonSubTypes(value={@JsonSubTypes.Type(name="one", value=PayloadOne.class), @JsonSubTypes.Type(name="two", value=PayloadTwo.class)})
        @JsonProperty(value="payload")
        @CanIgnoreReturnValue
        public final Builder payload(Payload payload) {
            this.payload = Objects.requireNonNull(payload, "payload");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public AbstractResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AbstractResponse(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("payload");
            }
            return "Cannot build AbstractResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_AbstractResponse", generator="Immutables")
    static final class Json
    extends _AbstractResponse {
        @Nullable
        String type;
        @Nullable
        Payload payload;

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="type")
        @JsonSubTypes(value={@JsonSubTypes.Type(name="one", value=PayloadOne.class), @JsonSubTypes.Type(name="two", value=PayloadTwo.class)})
        @JsonProperty(value="payload")
        public void setPayload(Payload payload) {
            this.payload = payload;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Payload getPayload() {
            throw new UnsupportedOperationException();
        }
    }
}

