/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jdkonly;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jdkonly.DefaultArray;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DefaultArray", generator="Immutables")
@Immutable
public final class ImmutableDefaultArray
extends DefaultArray {
    private final int[] prop;
    private final ImmutableSet<Integer> ints;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDefaultArray(Builder builder) {
        if (builder.prop != null) {
            this.initShim.prop(builder.prop);
        }
        if (builder.intsIsSet()) {
            this.initShim.ints((ImmutableSet<Integer>)builder.ints.build());
        }
        this.prop = this.initShim.prop();
        this.ints = this.initShim.ints();
        this.initShim = null;
    }

    private ImmutableDefaultArray(int[] prop, ImmutableSet<Integer> ints) {
        this.prop = prop;
        this.ints = ints;
        this.initShim = null;
    }

    @Override
    int[] prop() {
        InitShim shim = this.initShim;
        return shim != null ? (int[])shim.prop().clone() : (int[])this.prop.clone();
    }

    @Override
    ImmutableSet<Integer> ints() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ints() : this.ints;
    }

    public final ImmutableDefaultArray withProp(int ... elements) {
        int[] newValue = (int[])elements.clone();
        return new ImmutableDefaultArray(newValue, this.ints);
    }

    public final ImmutableDefaultArray withInts(int ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableDefaultArray(this.prop, (ImmutableSet<Integer>)newValue);
    }

    public final ImmutableDefaultArray withInts(Iterable<Integer> elements) {
        if (this.ints == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableDefaultArray(this.prop, (ImmutableSet<Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDefaultArray && this.equalTo(0, (ImmutableDefaultArray)another);
    }

    private boolean equalTo(int synthetic, ImmutableDefaultArray another) {
        return Arrays.equals(this.prop, another.prop) && this.ints.equals(another.ints);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.prop);
        h += (h << 5) + this.ints.hashCode();
        return h;
    }

    public String toString() {
        return "DefaultArray{prop=" + Arrays.toString(this.prop) + ", ints=" + this.ints + "}";
    }

    public static ImmutableDefaultArray copyOf(DefaultArray instance) {
        if (instance instanceof ImmutableDefaultArray) {
            return (ImmutableDefaultArray)instance;
        }
        return ImmutableDefaultArray.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DefaultArray", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_INTS = 1L;
        private long optBits;
        @Nullable
        private int[] prop;
        private ImmutableSet.Builder<Integer> ints = ImmutableSet.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DefaultArray instance) {
            Objects.requireNonNull(instance, "instance");
            this.prop(instance.prop());
            this.addAllInts((Iterable<Integer>)instance.ints());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prop(int ... prop) {
            this.prop = (int[])prop.clone();
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInts(int element) {
            this.ints.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInts(int ... elements) {
            this.ints.addAll((Iterable)Ints.asList((int[])elements));
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ints(Iterable<Integer> elements) {
            this.ints = ImmutableSet.builder();
            return this.addAllInts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInts(Iterable<Integer> elements) {
            this.ints.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        public ImmutableDefaultArray build() {
            return new ImmutableDefaultArray(this);
        }

        private boolean intsIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Generated(from="DefaultArray", generator="Immutables")
    private final class InitShim {
        private byte propBuildStage = 0;
        private int[] prop;
        private byte intsBuildStage = 0;
        private ImmutableSet<Integer> ints;

        private InitShim() {
        }

        int[] prop() {
            if (this.propBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.propBuildStage == 0) {
                this.propBuildStage = (byte)-1;
                this.prop = (int[])ImmutableDefaultArray.super.prop().clone();
                this.propBuildStage = 1;
            }
            return this.prop;
        }

        void prop(int[] prop) {
            this.prop = prop;
            this.propBuildStage = 1;
        }

        ImmutableSet<Integer> ints() {
            if (this.intsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.intsBuildStage == 0) {
                this.intsBuildStage = (byte)-1;
                this.ints = Objects.requireNonNull(ImmutableDefaultArray.super.ints(), "ints");
                this.intsBuildStage = 1;
            }
            return this.ints;
        }

        void ints(ImmutableSet<Integer> ints) {
            this.ints = ints;
            this.intsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.propBuildStage == -1) {
                attributes.add("prop");
            }
            if (this.intsBuildStage == -1) {
                attributes.add("ints");
            }
            return "Cannot build DefaultArray, attribute initializers form cycle " + attributes;
        }
    }
}

