/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jdkonly;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jdkonly.HasOptionalToString;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HasOptionalToString", generator="Immutables")
@Immutable
final class ImmutableHasOptionalToString
implements HasOptionalToString {
    @Nullable
    private final Integer into;
    private final String mandatory;
    @Nullable
    private final String nullable;
    @Nullable
    private final String optional;

    private ImmutableHasOptionalToString(@Nullable Integer into, String mandatory, @Nullable String nullable, @Nullable String optional) {
        this.into = into;
        this.mandatory = mandatory;
        this.nullable = nullable;
        this.optional = optional;
    }

    @Override
    public OptionalInt into() {
        return this.into != null ? OptionalInt.of(this.into) : OptionalInt.empty();
    }

    @Override
    public String mandatory() {
        return this.mandatory;
    }

    @Override
    @Nullable
    public String nullable() {
        return this.nullable;
    }

    @Override
    public Optional<String> optional() {
        return Optional.ofNullable(this.optional);
    }

    public final ImmutableHasOptionalToString withInto(int value) {
        Integer newValue = value;
        if (Objects.equals(this.into, newValue)) {
            return this;
        }
        return new ImmutableHasOptionalToString(newValue, this.mandatory, this.nullable, this.optional);
    }

    public final ImmutableHasOptionalToString withInto(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.into, value)) {
            return this;
        }
        return new ImmutableHasOptionalToString(value, this.mandatory, this.nullable, this.optional);
    }

    public final ImmutableHasOptionalToString withMandatory(String value) {
        String newValue = Objects.requireNonNull(value, "mandatory");
        if (this.mandatory.equals(newValue)) {
            return this;
        }
        return new ImmutableHasOptionalToString(this.into, newValue, this.nullable, this.optional);
    }

    public final ImmutableHasOptionalToString withNullable(@Nullable String value) {
        if (Objects.equals(this.nullable, value)) {
            return this;
        }
        return new ImmutableHasOptionalToString(this.into, this.mandatory, value, this.optional);
    }

    public final ImmutableHasOptionalToString withOptional(String value) {
        String newValue = Objects.requireNonNull(value, "optional");
        if (Objects.equals(this.optional, newValue)) {
            return this;
        }
        return new ImmutableHasOptionalToString(this.into, this.mandatory, this.nullable, newValue);
    }

    public final ImmutableHasOptionalToString withOptional(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.optional, value)) {
            return this;
        }
        return new ImmutableHasOptionalToString(this.into, this.mandatory, this.nullable, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHasOptionalToString && this.equalTo(0, (ImmutableHasOptionalToString)another);
    }

    private boolean equalTo(int synthetic, ImmutableHasOptionalToString another) {
        return Objects.equals(this.into, another.into) && this.mandatory.equals(another.mandatory) && Objects.equals(this.nullable, another.nullable) && Objects.equals(this.optional, another.optional);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.into);
        h += (h << 5) + this.mandatory.hashCode();
        h += (h << 5) + Objects.hashCode(this.nullable);
        h += (h << 5) + Objects.hashCode(this.optional);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("HasOptionalToString{");
        if (this.into != null) {
            builder.append("into=").append(this.into);
        }
        if (builder.length() > 20) {
            builder.append(", ");
        }
        builder.append("mandatory=").append(this.mandatory);
        if (this.nullable != null) {
            builder.append(", ");
            builder.append("nullable=").append(this.nullable);
        }
        if (this.optional != null) {
            builder.append(", ");
            builder.append("optional=").append(this.optional);
        }
        return builder.append("}").toString();
    }

    public static ImmutableHasOptionalToString copyOf(HasOptionalToString instance) {
        if (instance instanceof ImmutableHasOptionalToString) {
            return (ImmutableHasOptionalToString)instance;
        }
        return ImmutableHasOptionalToString.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HasOptionalToString", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MANDATORY = 1L;
        private long initBits = 1L;
        @Nullable
        private Integer into;
        @Nullable
        private String mandatory;
        @Nullable
        private String nullable;
        @Nullable
        private String optional;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HasOptionalToString instance) {
            Optional<String> optionalOptional;
            Objects.requireNonNull(instance, "instance");
            OptionalInt intoOptional = instance.into();
            if (intoOptional.isPresent()) {
                this.into(intoOptional);
            }
            this.mandatory(instance.mandatory());
            String nullableValue = instance.nullable();
            if (nullableValue != null) {
                this.nullable(nullableValue);
            }
            if ((optionalOptional = instance.optional()).isPresent()) {
                this.optional(optionalOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder into(int into) {
            this.into = into;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder into(OptionalInt into) {
            this.into = into.isPresent() ? Integer.valueOf(into.getAsInt()) : null;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mandatory(String mandatory) {
            this.mandatory = Objects.requireNonNull(mandatory, "mandatory");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nullable(@Nullable String nullable) {
            this.nullable = nullable;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder optional(String optional) {
            this.optional = Objects.requireNonNull(optional, "optional");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder optional(Optional<String> optional) {
            this.optional = optional.orElse(null);
            return this;
        }

        public ImmutableHasOptionalToString build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHasOptionalToString(this.into, this.mandatory, this.nullable, this.optional);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("mandatory");
            }
            return "Cannot build HasOptionalToString, some of required attributes are not set " + attributes;
        }
    }
}

