/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jdkonly;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jdkonly.JdkMaps;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="JdkMaps", generator="Immutables")
@NotThreadSafe
public final class JdkMapsBuilder {
    private Map<Long, Integer> just = new LinkedHashMap<Long, Integer>();
    private Map<Integer, String> ords = new LinkedHashMap<Integer, String>();
    private EnumMap<RetentionPolicy, Integer> pols = new EnumMap(RetentionPolicy.class);
    private Map<String, Integer> navs = new LinkedHashMap<String, Integer>();

    @CanIgnoreReturnValue
    public final JdkMapsBuilder from(JdkMaps instance) {
        Objects.requireNonNull(instance, "instance");
        this.putAllJust(instance.just());
        this.putAllOrds(instance.ords());
        this.putAllPols(instance.pols());
        this.putAllNavs(instance.navs());
        return this;
    }

    @CanIgnoreReturnValue
    public final JdkMapsBuilder putJust(long key, int value) {
        this.just.put(Objects.requireNonNull(Long.valueOf(key), "just key"), Objects.requireNonNull(Integer.valueOf(value), "just value"));
        return this;
    }

    @CanIgnoreReturnValue
    public final JdkMapsBuilder putJust(Map.Entry<Long, ? extends Integer> entry) {
        Long k = entry.getKey();
        Integer v = entry.getValue();
        this.just.put(Objects.requireNonNull(k, "just key"), Objects.requireNonNull(v, "just value"));
        return this;
    }

    @CanIgnoreReturnValue
    public final JdkMapsBuilder just(Map<Long, ? extends Integer> entries) {
        this.just.clear();
        return this.putAllJust(entries);
    }

    @CanIgnoreReturnValue
    public final JdkMapsBuilder putAllJust(Map<Long, ? extends Integer> entries) {
        for (Map.Entry<Long, ? extends Integer> e : entries.entrySet()) {
            Long k = e.getKey();
            Integer v = e.getValue();
            this.just.put(Objects.requireNonNull(k, "just key"), Objects.requireNonNull(v, "just value"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public final JdkMapsBuilder putOrds(int key, String value) {
        this.ords.put(Objects.requireNonNull(Integer.valueOf(key), "ords key"), Objects.requireNonNull(value, "ords value"));
        return this;
    }

    @CanIgnoreReturnValue
    public final JdkMapsBuilder putOrds(Map.Entry<Integer, ? extends String> entry) {
        Integer k = entry.getKey();
        String v = entry.getValue();
        this.ords.put(Objects.requireNonNull(k, "ords key"), Objects.requireNonNull(v, "ords value"));
        return this;
    }

    @CanIgnoreReturnValue
    public final JdkMapsBuilder ords(Map<Integer, ? extends String> entries) {
        this.ords.clear();
        return this.putAllOrds(entries);
    }

    @CanIgnoreReturnValue
    public final JdkMapsBuilder putAllOrds(Map<Integer, ? extends String> entries) {
        for (Map.Entry<Integer, ? extends String> e : entries.entrySet()) {
            Integer k = e.getKey();
            String v = e.getValue();
            this.ords.put(Objects.requireNonNull(k, "ords key"), Objects.requireNonNull(v, "ords value"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public final JdkMapsBuilder putPols(RetentionPolicy key, int value) {
        this.pols.put((RetentionPolicy)((Enum)Objects.requireNonNull(key, "pols key")), Objects.requireNonNull(Integer.valueOf(value), "pols value"));
        return this;
    }

    @CanIgnoreReturnValue
    public final JdkMapsBuilder putPols(Map.Entry<RetentionPolicy, ? extends Integer> entry) {
        RetentionPolicy k = entry.getKey();
        Integer v = entry.getValue();
        this.pols.put((RetentionPolicy)((Enum)Objects.requireNonNull(k, "pols key")), Objects.requireNonNull(v, "pols value"));
        return this;
    }

    @CanIgnoreReturnValue
    public final JdkMapsBuilder pols(Map<RetentionPolicy, ? extends Integer> entries) {
        this.pols.clear();
        return this.putAllPols(entries);
    }

    @CanIgnoreReturnValue
    public final JdkMapsBuilder putAllPols(Map<RetentionPolicy, ? extends Integer> entries) {
        for (Map.Entry<RetentionPolicy, ? extends Integer> e : entries.entrySet()) {
            RetentionPolicy k = e.getKey();
            Integer v = e.getValue();
            this.pols.put((RetentionPolicy)((Enum)Objects.requireNonNull(k, "pols key")), Objects.requireNonNull(v, "pols value"));
        }
        return this;
    }

    @CanIgnoreReturnValue
    public final JdkMapsBuilder putNavs(String key, int value) {
        this.navs.put(Objects.requireNonNull(key, "navs key"), Objects.requireNonNull(Integer.valueOf(value), "navs value"));
        return this;
    }

    @CanIgnoreReturnValue
    public final JdkMapsBuilder putNavs(Map.Entry<String, ? extends Integer> entry) {
        String k = entry.getKey();
        Integer v = entry.getValue();
        this.navs.put(Objects.requireNonNull(k, "navs key"), Objects.requireNonNull(v, "navs value"));
        return this;
    }

    @CanIgnoreReturnValue
    public final JdkMapsBuilder navs(Map<String, ? extends Integer> entries) {
        this.navs.clear();
        return this.putAllNavs(entries);
    }

    @CanIgnoreReturnValue
    public final JdkMapsBuilder putAllNavs(Map<String, ? extends Integer> entries) {
        for (Map.Entry<String, ? extends Integer> e : entries.entrySet()) {
            String k = e.getKey();
            Integer v = e.getValue();
            this.navs.put(Objects.requireNonNull(k, "navs key"), Objects.requireNonNull(v, "navs value"));
        }
        return this;
    }

    public JdkMaps build() {
        return ImmutableJdkMaps.validate(new ImmutableJdkMaps(this));
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    private static <K extends Enum<K>, V> Map<K, V> createUnmodifiableEnumMap(boolean checkNulls, boolean skipNulls, Map<K, ? extends V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        EnumMap<K, ? extends V> enumMap = new EnumMap<K, V>(map);
        if (checkNulls || skipNulls) {
            Iterator<V> it = map.values().iterator();
            while (it.hasNext()) {
                V v = it.next();
                if (checkNulls) {
                    Objects.requireNonNull(v, "value");
                    continue;
                }
                if (!skipNulls || v != null) continue;
                it.remove();
            }
        }
        return Collections.unmodifiableMap(enumMap);
    }

    private static <K extends Comparable<K>, V> NavigableMap<K, V> createUnmodifiableSortedMap(boolean reverse, boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        TreeMap sortedMap;
        TreeMap<Object, V> treeMap = sortedMap = reverse ? new TreeMap(Collections.reverseOrder()) : new TreeMap();
        if (checkNulls || skipNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                Comparable k = (Comparable)e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                sortedMap.put(k, v);
            }
        } else {
            sortedMap.putAll(map);
        }
        return Collections.unmodifiableNavigableMap(sortedMap);
    }

    @CheckReturnValue
    @Generated(from="JdkMaps", generator="Immutables")
    @Immutable
    private static final class ImmutableJdkMaps
    implements JdkMaps {
        private final Map<Long, Integer> just;
        private final SortedMap<Integer, String> ords;
        private final Map<RetentionPolicy, Integer> pols;
        private final NavigableMap<String, Integer> navs;
        private static final ImmutableJdkMaps INSTANCE = ImmutableJdkMaps.validate(new ImmutableJdkMaps());

        private ImmutableJdkMaps() {
            this.just = Collections.emptyMap();
            this.ords = JdkMapsBuilder.createUnmodifiableSortedMap(false, false, false, Collections.emptyMap());
            this.pols = Collections.emptyMap();
            this.navs = JdkMapsBuilder.createUnmodifiableSortedMap(true, false, false, Collections.emptyMap());
        }

        private ImmutableJdkMaps(JdkMapsBuilder builder) {
            this.just = JdkMapsBuilder.createUnmodifiableMap(false, false, builder.just);
            this.ords = JdkMapsBuilder.createUnmodifiableSortedMap(false, false, false, builder.ords);
            this.pols = JdkMapsBuilder.createUnmodifiableEnumMap(false, false, builder.pols);
            this.navs = JdkMapsBuilder.createUnmodifiableSortedMap(true, false, false, builder.navs);
        }

        @Override
        public Map<Long, Integer> just() {
            return this.just;
        }

        @Override
        public SortedMap<Integer, String> ords() {
            return this.ords;
        }

        @Override
        public Map<RetentionPolicy, Integer> pols() {
            return this.pols;
        }

        @Override
        public NavigableMap<String, Integer> navs() {
            return this.navs;
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableJdkMaps && this.equalTo(0, (ImmutableJdkMaps)another);
        }

        private boolean equalTo(int synthetic, ImmutableJdkMaps another) {
            return this.just.equals(another.just) && this.ords.equals(another.ords) && this.pols.equals(another.pols) && this.navs.equals(another.navs);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.just.hashCode();
            h += (h << 5) + this.ords.hashCode();
            h += (h << 5) + this.pols.hashCode();
            h += (h << 5) + this.navs.hashCode();
            return h;
        }

        public String toString() {
            return "JdkMaps{just=" + this.just + ", ords=" + this.ords + ", pols=" + this.pols + ", navs=" + this.navs + "}";
        }

        public static JdkMaps of() {
            return INSTANCE;
        }

        private static ImmutableJdkMaps validate(ImmutableJdkMaps instance) {
            return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
        }
    }
}

