/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.GenericHolder;
import org.immutables.fixture.modifiable.ModifiableGenericHolder;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GenericHolder", generator="Immutables")
@Immutable
public final class ImmutableGenericHolder<T>
implements GenericHolder<T> {
    private final T mandatory;
    @Nullable
    private final T optional;

    private ImmutableGenericHolder(T mandatory, @Nullable T optional) {
        this.mandatory = mandatory;
        this.optional = optional;
    }

    @Override
    public T mandatory() {
        return this.mandatory;
    }

    @Override
    @Nullable
    public T optional() {
        return this.optional;
    }

    public final ImmutableGenericHolder<T> withMandatory(T value) {
        if (this.mandatory == value) {
            return this;
        }
        T newValue = Objects.requireNonNull(value, "mandatory");
        return new ImmutableGenericHolder<T>(newValue, this.optional);
    }

    public final ImmutableGenericHolder<T> withOptional(@Nullable T value) {
        if (this.optional == value) {
            return this;
        }
        return new ImmutableGenericHolder<T>(this.mandatory, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGenericHolder && this.equalTo(0, (ImmutableGenericHolder)another);
    }

    private boolean equalTo(int synthetic, ImmutableGenericHolder<?> another) {
        return this.mandatory.equals(another.mandatory) && Objects.equals(this.optional, another.optional);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.mandatory.hashCode();
        h += (h << 5) + Objects.hashCode(this.optional);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GenericHolder").omitNullValues().add("mandatory", this.mandatory).add("optional", this.optional).toString();
    }

    public static <T> ImmutableGenericHolder<T> copyOf(GenericHolder<T> instance) {
        if (instance instanceof ImmutableGenericHolder) {
            return (ImmutableGenericHolder)instance;
        }
        return ImmutableGenericHolder.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="GenericHolder", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_MANDATORY = 1L;
        private long initBits = 1L;
        @Nullable
        private T mandatory;
        @Nullable
        private T optional;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(ModifiableGenericHolder<T> instance) {
            T optionalValue;
            Objects.requireNonNull(instance, "instance");
            if (instance.mandatoryIsSet()) {
                this.mandatory(instance.mandatory());
            }
            if ((optionalValue = instance.optional()) != null) {
                this.optional(optionalValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(GenericHolder<T> instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableGenericHolder) {
                return this.from((ModifiableGenericHolder)instance);
            }
            this.mandatory(instance.mandatory());
            T optionalValue = instance.optional();
            if (optionalValue != null) {
                this.optional(optionalValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> mandatory(T mandatory) {
            this.mandatory = Objects.requireNonNull(mandatory, "mandatory");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> optional(@Nullable T optional) {
            this.optional = optional;
            return this;
        }

        public ImmutableGenericHolder<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGenericHolder(this.mandatory, this.optional);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("mandatory");
            }
            return "Cannot build GenericHolder, some of required attributes are not set " + attributes;
        }
    }
}

