/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.ImmutableNullableList;
import org.immutables.fixture.modifiable.NullableList;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="NullableList", generator="Modifiables")
@NotThreadSafe
public final class ModifiableNullableList
implements NullableList {
    @Nullable
    private Object object;
    @Nullable
    private ArrayList<Object> objects = null;

    private ModifiableNullableList() {
    }

    public static ModifiableNullableList create() {
        return new ModifiableNullableList();
    }

    @Override
    @Nullable
    public final Object getObject() {
        return this.object;
    }

    @Override
    @Nullable
    public final List<Object> getObjects() {
        return this.objects;
    }

    @CanIgnoreReturnValue
    public ModifiableNullableList clear() {
        this.object = null;
        this.objects = null;
        return this;
    }

    public ModifiableNullableList from(NullableList instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableNullableList) {
            this.from((ModifiableNullableList)instance);
            return this;
        }
        Object objectValue = instance.getObject();
        if (objectValue != null) {
            this.setObject(objectValue);
        }
        this.addAllObjects(instance.getObjects());
        return this;
    }

    public ModifiableNullableList from(ModifiableNullableList instance) {
        Objects.requireNonNull(instance, "instance");
        Object objectValue = instance.getObject();
        if (objectValue != null) {
            this.setObject(objectValue);
        }
        this.addAllObjects(instance.getObjects());
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableNullableList setObject(@Nullable Object object) {
        this.object = object;
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableNullableList addObjects(Object element) {
        if (this.objects == null) {
            this.objects = new ArrayList();
        }
        Objects.requireNonNull(element, "objects element");
        this.objects.add(element);
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableNullableList addObjects(Object ... elements) {
        for (Object e : elements) {
            this.addObjects(e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableNullableList setObjects(@Nullable Iterable<? extends Object> elements) {
        if (elements == null) {
            this.objects = null;
            return this;
        }
        if (this.objects == null) {
            this.objects = new ArrayList();
        } else {
            this.objects.clear();
        }
        this.addAllObjects(elements);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableNullableList addAllObjects(Iterable<? extends Object> elements) {
        if (elements == null) {
            return this;
        }
        if (this.objects == null) {
            this.objects = new ArrayList();
        }
        for (Object object : elements) {
            this.addObjects(object);
        }
        return this;
    }

    public final boolean isInitialized() {
        return true;
    }

    public final ImmutableNullableList toImmutable() {
        return ImmutableNullableList.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableNullableList)) {
            return false;
        }
        ModifiableNullableList other = (ModifiableNullableList)another;
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableNullableList another) {
        return Objects.equals(this.object, another.object) && Objects.equals(this.objects, another.objects);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.object);
        h += (h << 5) + Objects.hashCode(this.objects);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ModifiableNullableList").add("object", this.getObject()).add("objects", this.getObjects()).toString();
    }
}

