/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.nullable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.nullable.FromSupertypeNullable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FromSupertypeNullable.Subtype", generator="Immutables")
@Immutable
public final class ImmutableSubtype
implements FromSupertypeNullable.Subtype {
    private final String a;
    private final String b;

    private ImmutableSubtype(String a, String b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public String a() {
        return this.a;
    }

    @Override
    public String b() {
        return this.b;
    }

    public final ImmutableSubtype withA(String value) {
        String newValue = Objects.requireNonNull(value, "a");
        if (this.a.equals(newValue)) {
            return this;
        }
        return new ImmutableSubtype(newValue, this.b);
    }

    public final ImmutableSubtype withB(String value) {
        String newValue = Objects.requireNonNull(value, "b");
        if (this.b.equals(newValue)) {
            return this;
        }
        return new ImmutableSubtype(this.a, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSubtype && this.equalTo(0, (ImmutableSubtype)another);
    }

    private boolean equalTo(int synthetic, ImmutableSubtype another) {
        return this.a.equals(another.a) && this.b.equals(another.b);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.a.hashCode();
        h += (h << 5) + this.b.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Subtype").omitNullValues().add("a", (Object)this.a).add("b", (Object)this.b).toString();
    }

    public static ImmutableSubtype copyOf(FromSupertypeNullable.Subtype instance) {
        if (instance instanceof ImmutableSubtype) {
            return (ImmutableSubtype)instance;
        }
        return ImmutableSubtype.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FromSupertypeNullable.Subtype", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_A = 1L;
        private static final long INIT_BIT_B = 2L;
        private long initBits = 3L;
        @Nullable
        private String a;
        @Nullable
        private String b;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FromSupertypeNullable.Subtype instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(FromSupertypeNullable.SuperB instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(FromSupertypeNullable.SuperA instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String bValue;
            String aValue;
            Object instance;
            long bits = 0L;
            if (object instanceof FromSupertypeNullable.Subtype) {
                instance = (FromSupertypeNullable.Subtype)object;
                if ((bits & 1L) == 0L) {
                    aValue = instance.a();
                    if (aValue != null) {
                        this.a(aValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    bValue = instance.b();
                    if (bValue != null) {
                        this.b(bValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof FromSupertypeNullable.SuperB) {
                instance = (FromSupertypeNullable.SuperB)object;
                if ((bits & 2L) == 0L) {
                    bValue = instance.b();
                    if (bValue != null) {
                        this.b(bValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof FromSupertypeNullable.SuperA) {
                instance = (FromSupertypeNullable.SuperA)object;
                if ((bits & 1L) == 0L) {
                    aValue = instance.a();
                    if (aValue != null) {
                        this.a(aValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder a(String a) {
            this.a = Objects.requireNonNull(a, "a");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder b(String b) {
            this.b = Objects.requireNonNull(b, "b");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSubtype build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSubtype(this.a, this.b);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("b");
            }
            return "Cannot build Subtype, some of required attributes are not set " + attributes;
        }
    }
}

