/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.ordered;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.ordered.SortedCollectionWrapper;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SortedCollectionWrapper.Elem", generator="Immutables")
@Immutable
public final class ImmutableElem
implements SortedCollectionWrapper.Elem {
    private final int value;

    private ImmutableElem(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public final ImmutableElem withValue(int value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableElem(value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableElem && this.equalTo(0, (ImmutableElem)another);
    }

    private boolean equalTo(int synthetic, ImmutableElem another) {
        return this.value == another.value;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Elem").omitNullValues().add("value", this.value).toString();
    }

    public static ImmutableElem copyOf(SortedCollectionWrapper.Elem instance) {
        if (instance instanceof ImmutableElem) {
            return (ImmutableElem)instance;
        }
        return ImmutableElem.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SortedCollectionWrapper.Elem", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        private int value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SortedCollectionWrapper.Elem instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.getValue());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(int value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableElem build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableElem(this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build Elem, some of required attributes are not set " + attributes;
        }
    }
}

