/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.ordered;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.ordered.ImmutableElem;
import org.immutables.fixture.ordered.SortedCollectionWrapper;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SortedCollectionWrapper", generator="Immutables")
@Immutable
public final class ImmutableSortedCollectionWrapper
implements SortedCollectionWrapper {
    private final ImmutableSortedSet<SortedCollectionWrapper.Elem> elemSet;
    private final ImmutableSortedSet<ImmutableElem> immutableElemSet;
    private final ImmutableSortedMultiset<SortedCollectionWrapper.Elem> elemMultiset;
    private final ImmutableSortedMultiset<ImmutableElem> immutableElemMultiset;
    private final ImmutableSortedMap<SortedCollectionWrapper.Elem, Void> elemMap;
    private final ImmutableSortedMap<ImmutableElem, Void> immutableElemMap;

    private ImmutableSortedCollectionWrapper(ImmutableSortedSet<SortedCollectionWrapper.Elem> elemSet, ImmutableSortedSet<ImmutableElem> immutableElemSet, ImmutableSortedMultiset<SortedCollectionWrapper.Elem> elemMultiset, ImmutableSortedMultiset<ImmutableElem> immutableElemMultiset, ImmutableSortedMap<SortedCollectionWrapper.Elem, Void> elemMap, ImmutableSortedMap<ImmutableElem, Void> immutableElemMap) {
        this.elemSet = elemSet;
        this.immutableElemSet = immutableElemSet;
        this.elemMultiset = elemMultiset;
        this.immutableElemMultiset = immutableElemMultiset;
        this.elemMap = elemMap;
        this.immutableElemMap = immutableElemMap;
    }

    @Override
    public ImmutableSortedSet<SortedCollectionWrapper.Elem> getElemSet() {
        return this.elemSet;
    }

    @Override
    public ImmutableSortedSet<ImmutableElem> getImmutableElemSet() {
        return this.immutableElemSet;
    }

    @Override
    public ImmutableSortedMultiset<SortedCollectionWrapper.Elem> getElemMultiset() {
        return this.elemMultiset;
    }

    @Override
    public ImmutableSortedMultiset<ImmutableElem> getImmutableElemMultiset() {
        return this.immutableElemMultiset;
    }

    @Override
    public ImmutableSortedMap<SortedCollectionWrapper.Elem, Void> getElemMap() {
        return this.elemMap;
    }

    @Override
    public ImmutableSortedMap<ImmutableElem, Void> getImmutableElemMap() {
        return this.immutableElemMap;
    }

    public final ImmutableSortedCollectionWrapper withElemSet(SortedCollectionWrapper.Elem ... elements) {
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), Arrays.asList(elements));
        return new ImmutableSortedCollectionWrapper((ImmutableSortedSet<SortedCollectionWrapper.Elem>)newValue, this.immutableElemSet, this.elemMultiset, this.immutableElemMultiset, this.elemMap, this.immutableElemMap);
    }

    public final ImmutableSortedCollectionWrapper withElemSet(Iterable<? extends SortedCollectionWrapper.Elem> elements) {
        if (this.elemSet == elements) {
            return this;
        }
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), elements);
        return new ImmutableSortedCollectionWrapper((ImmutableSortedSet<SortedCollectionWrapper.Elem>)newValue, this.immutableElemSet, this.elemMultiset, this.immutableElemMultiset, this.elemMap, this.immutableElemMap);
    }

    public final ImmutableSortedCollectionWrapper withImmutableElemSet(ImmutableElem ... elements) {
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), Arrays.asList(elements));
        return new ImmutableSortedCollectionWrapper(this.elemSet, (ImmutableSortedSet<ImmutableElem>)newValue, this.elemMultiset, this.immutableElemMultiset, this.elemMap, this.immutableElemMap);
    }

    public final ImmutableSortedCollectionWrapper withImmutableElemSet(Iterable<? extends ImmutableElem> elements) {
        if (this.immutableElemSet == elements) {
            return this;
        }
        ImmutableSortedSet newValue = ImmutableSortedSet.copyOf((Comparator)Ordering.natural(), elements);
        return new ImmutableSortedCollectionWrapper(this.elemSet, (ImmutableSortedSet<ImmutableElem>)newValue, this.elemMultiset, this.immutableElemMultiset, this.elemMap, this.immutableElemMap);
    }

    public final ImmutableSortedCollectionWrapper withElemMultiset(SortedCollectionWrapper.Elem ... elements) {
        ImmutableSortedMultiset newValue = ImmutableSortedMultiset.copyOf((Comparator)Ordering.natural().reverse(), Arrays.asList(elements));
        return new ImmutableSortedCollectionWrapper(this.elemSet, this.immutableElemSet, (ImmutableSortedMultiset<SortedCollectionWrapper.Elem>)newValue, this.immutableElemMultiset, this.elemMap, this.immutableElemMap);
    }

    public final ImmutableSortedCollectionWrapper withElemMultiset(Iterable<? extends SortedCollectionWrapper.Elem> elements) {
        if (this.elemMultiset == elements) {
            return this;
        }
        ImmutableSortedMultiset newValue = ImmutableSortedMultiset.copyOf((Comparator)Ordering.natural().reverse(), elements);
        return new ImmutableSortedCollectionWrapper(this.elemSet, this.immutableElemSet, (ImmutableSortedMultiset<SortedCollectionWrapper.Elem>)newValue, this.immutableElemMultiset, this.elemMap, this.immutableElemMap);
    }

    public final ImmutableSortedCollectionWrapper withImmutableElemMultiset(ImmutableElem ... elements) {
        ImmutableSortedMultiset newValue = ImmutableSortedMultiset.copyOf((Comparator)Ordering.natural().reverse(), Arrays.asList(elements));
        return new ImmutableSortedCollectionWrapper(this.elemSet, this.immutableElemSet, this.elemMultiset, (ImmutableSortedMultiset<ImmutableElem>)newValue, this.elemMap, this.immutableElemMap);
    }

    public final ImmutableSortedCollectionWrapper withImmutableElemMultiset(Iterable<? extends ImmutableElem> elements) {
        if (this.immutableElemMultiset == elements) {
            return this;
        }
        ImmutableSortedMultiset newValue = ImmutableSortedMultiset.copyOf((Comparator)Ordering.natural().reverse(), elements);
        return new ImmutableSortedCollectionWrapper(this.elemSet, this.immutableElemSet, this.elemMultiset, (ImmutableSortedMultiset<ImmutableElem>)newValue, this.elemMap, this.immutableElemMap);
    }

    public final ImmutableSortedCollectionWrapper withElemMap(Map<? extends SortedCollectionWrapper.Elem, ? extends Void> entries) {
        if (this.elemMap == entries) {
            return this;
        }
        ImmutableSortedMap newValue = ImmutableSortedMap.copyOf(entries, (Comparator)Ordering.natural());
        return new ImmutableSortedCollectionWrapper(this.elemSet, this.immutableElemSet, this.elemMultiset, this.immutableElemMultiset, (ImmutableSortedMap<SortedCollectionWrapper.Elem, Void>)newValue, this.immutableElemMap);
    }

    public final ImmutableSortedCollectionWrapper withImmutableElemMap(Map<? extends ImmutableElem, ? extends Void> entries) {
        if (this.immutableElemMap == entries) {
            return this;
        }
        ImmutableSortedMap newValue = ImmutableSortedMap.copyOf(entries, (Comparator)Ordering.natural());
        return new ImmutableSortedCollectionWrapper(this.elemSet, this.immutableElemSet, this.elemMultiset, this.immutableElemMultiset, this.elemMap, (ImmutableSortedMap<ImmutableElem, Void>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSortedCollectionWrapper && this.equalTo(0, (ImmutableSortedCollectionWrapper)another);
    }

    private boolean equalTo(int synthetic, ImmutableSortedCollectionWrapper another) {
        return this.elemSet.equals(another.elemSet) && this.immutableElemSet.equals(another.immutableElemSet) && this.elemMultiset.equals(another.elemMultiset) && this.immutableElemMultiset.equals(another.immutableElemMultiset) && this.elemMap.equals(another.elemMap) && this.immutableElemMap.equals(another.immutableElemMap);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.elemSet.hashCode();
        h += (h << 5) + this.immutableElemSet.hashCode();
        h += (h << 5) + this.elemMultiset.hashCode();
        h += (h << 5) + this.immutableElemMultiset.hashCode();
        h += (h << 5) + this.elemMap.hashCode();
        h += (h << 5) + this.immutableElemMap.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SortedCollectionWrapper").omitNullValues().add("elemSet", this.elemSet).add("immutableElemSet", this.immutableElemSet).add("elemMultiset", this.elemMultiset).add("immutableElemMultiset", this.immutableElemMultiset).add("elemMap", this.elemMap).add("immutableElemMap", this.immutableElemMap).toString();
    }

    public static ImmutableSortedCollectionWrapper copyOf(SortedCollectionWrapper instance) {
        if (instance instanceof ImmutableSortedCollectionWrapper) {
            return (ImmutableSortedCollectionWrapper)instance;
        }
        return ImmutableSortedCollectionWrapper.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SortedCollectionWrapper", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableSortedSet.Builder<SortedCollectionWrapper.Elem> elemSet = ImmutableSortedSet.naturalOrder();
        private ImmutableSortedSet.Builder<ImmutableElem> immutableElemSet = ImmutableSortedSet.naturalOrder();
        private ImmutableSortedMultiset.Builder<SortedCollectionWrapper.Elem> elemMultiset = ImmutableSortedMultiset.reverseOrder();
        private ImmutableSortedMultiset.Builder<ImmutableElem> immutableElemMultiset = ImmutableSortedMultiset.reverseOrder();
        private ImmutableSortedMap.Builder<SortedCollectionWrapper.Elem, Void> elemMap = ImmutableSortedMap.naturalOrder();
        private ImmutableSortedMap.Builder<ImmutableElem, Void> immutableElemMap = ImmutableSortedMap.naturalOrder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SortedCollectionWrapper instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllElemSet((Iterable<? extends SortedCollectionWrapper.Elem>)instance.getElemSet());
            this.addAllImmutableElemSet((Iterable<? extends ImmutableElem>)instance.getImmutableElemSet());
            this.addAllElemMultiset((Iterable<? extends SortedCollectionWrapper.Elem>)instance.getElemMultiset());
            this.addAllImmutableElemMultiset((Iterable<? extends ImmutableElem>)instance.getImmutableElemMultiset());
            this.putAllElemMap((Map<? extends SortedCollectionWrapper.Elem, ? extends Void>)instance.getElemMap());
            this.putAllImmutableElemMap((Map<? extends ImmutableElem, ? extends Void>)instance.getImmutableElemMap());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addElemSet(SortedCollectionWrapper.Elem element) {
            this.elemSet.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addElemSet(SortedCollectionWrapper.Elem ... elements) {
            this.elemSet.addAll(Arrays.asList(elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder elemSet(Iterable<? extends SortedCollectionWrapper.Elem> elements) {
            this.elemSet = ImmutableSortedSet.naturalOrder();
            return this.addAllElemSet(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllElemSet(Iterable<? extends SortedCollectionWrapper.Elem> elements) {
            this.elemSet.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addImmutableElemSet(ImmutableElem element) {
            this.immutableElemSet.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addImmutableElemSet(ImmutableElem ... elements) {
            this.immutableElemSet.addAll(Arrays.asList(elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder immutableElemSet(Iterable<? extends ImmutableElem> elements) {
            this.immutableElemSet = ImmutableSortedSet.naturalOrder();
            return this.addAllImmutableElemSet(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllImmutableElemSet(Iterable<? extends ImmutableElem> elements) {
            this.immutableElemSet.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addElemMultiset(SortedCollectionWrapper.Elem element) {
            this.elemMultiset.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addElemMultiset(SortedCollectionWrapper.Elem ... elements) {
            this.elemMultiset.addAll(Arrays.asList(elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder elemMultiset(Iterable<? extends SortedCollectionWrapper.Elem> elements) {
            this.elemMultiset = ImmutableSortedMultiset.reverseOrder();
            return this.addAllElemMultiset(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllElemMultiset(Iterable<? extends SortedCollectionWrapper.Elem> elements) {
            this.elemMultiset.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addImmutableElemMultiset(ImmutableElem element) {
            this.immutableElemMultiset.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addImmutableElemMultiset(ImmutableElem ... elements) {
            this.immutableElemMultiset.addAll(Arrays.asList(elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder immutableElemMultiset(Iterable<? extends ImmutableElem> elements) {
            this.immutableElemMultiset = ImmutableSortedMultiset.reverseOrder();
            return this.addAllImmutableElemMultiset(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllImmutableElemMultiset(Iterable<? extends ImmutableElem> elements) {
            this.immutableElemMultiset.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putElemMap(SortedCollectionWrapper.Elem key, Void value) {
            this.elemMap.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putElemMap(Map.Entry<? extends SortedCollectionWrapper.Elem, ? extends Void> entry) {
            this.elemMap.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder elemMap(Map<? extends SortedCollectionWrapper.Elem, ? extends Void> entries) {
            this.elemMap = ImmutableSortedMap.naturalOrder();
            return this.putAllElemMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllElemMap(Map<? extends SortedCollectionWrapper.Elem, ? extends Void> entries) {
            this.elemMap.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putImmutableElemMap(ImmutableElem key, Void value) {
            this.immutableElemMap.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putImmutableElemMap(Map.Entry<? extends ImmutableElem, ? extends Void> entry) {
            this.immutableElemMap.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder immutableElemMap(Map<? extends ImmutableElem, ? extends Void> entries) {
            this.immutableElemMap = ImmutableSortedMap.naturalOrder();
            return this.putAllImmutableElemMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllImmutableElemMap(Map<? extends ImmutableElem, ? extends Void> entries) {
            this.immutableElemMap.putAll(entries);
            return this;
        }

        public ImmutableSortedCollectionWrapper build() {
            return new ImmutableSortedCollectionWrapper(this.elemSet.build(), this.immutableElemSet.build(), this.elemMultiset.build(), this.immutableElemMultiset.build(), this.elemMap.build(), this.immutableElemMap.build());
        }
    }
}

