/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.strict;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.strict.Bar;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Bar", generator="Immutables")
@Immutable
final class ImmutableBar
implements Bar {
    private final ImmutableList<Integer> nums;
    private final ImmutableMap<String, Integer> map;
    private final ImmutableMap<String, Integer> immutableMap;
    private final SortedMap<String, Integer> sortedMap;
    private final ImmutableSortedMap<String, Integer> immutableSortedMap;
    private final ImmutableSet<String> set;
    private final ImmutableSet<String> immutableSet;
    private final SortedSet<String> sortedSet;
    private final ImmutableSortedSet<String> immutableSortedSet;
    private final Optional<Integer> opt;
    private final EnumMap<BoundType, Integer> enumMap;
    private final EnumSet<BoundType> enumSet;

    private ImmutableBar(ImmutableList<Integer> nums, ImmutableMap<String, Integer> map, ImmutableMap<String, Integer> immutableMap, SortedMap<String, Integer> sortedMap, ImmutableSortedMap<String, Integer> immutableSortedMap, ImmutableSet<String> set, ImmutableSet<String> immutableSet, SortedSet<String> sortedSet, ImmutableSortedSet<String> immutableSortedSet, Optional<Integer> opt, EnumMap<BoundType, Integer> enumMap, EnumSet<BoundType> enumSet) {
        this.nums = nums;
        this.map = map;
        this.immutableMap = immutableMap;
        this.sortedMap = sortedMap;
        this.immutableSortedMap = immutableSortedMap;
        this.set = set;
        this.immutableSet = immutableSet;
        this.sortedSet = sortedSet;
        this.immutableSortedSet = immutableSortedSet;
        this.opt = opt;
        this.enumMap = enumMap;
        this.enumSet = enumSet;
    }

    public ImmutableList<Integer> nums() {
        return this.nums;
    }

    public ImmutableMap<String, Integer> map() {
        return this.map;
    }

    @Override
    public ImmutableMap<String, Integer> immutableMap() {
        return this.immutableMap;
    }

    @Override
    public SortedMap<String, Integer> sortedMap() {
        return this.sortedMap;
    }

    @Override
    public ImmutableSortedMap<String, Integer> immutableSortedMap() {
        return this.immutableSortedMap;
    }

    public ImmutableSet<String> set() {
        return this.set;
    }

    @Override
    public ImmutableSet<String> immutableSet() {
        return this.immutableSet;
    }

    @Override
    public SortedSet<String> sortedSet() {
        return this.sortedSet;
    }

    @Override
    public ImmutableSortedSet<String> immutableSortedSet() {
        return this.immutableSortedSet;
    }

    @Override
    public Optional<Integer> opt() {
        return this.opt;
    }

    @Override
    public EnumMap<BoundType, Integer> enumMap() {
        return this.enumMap;
    }

    @Override
    public EnumSet<BoundType> enumSet() {
        return this.enumSet;
    }

    public final ImmutableBar withNums(int ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableBar((ImmutableList<Integer>)newValue, this.map, this.immutableMap, this.sortedMap, this.immutableSortedMap, this.set, this.immutableSet, this.sortedSet, this.immutableSortedSet, this.opt, this.enumMap, this.enumSet);
    }

    public final ImmutableBar withNums(Iterable<Integer> elements) {
        if (this.nums == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableBar((ImmutableList<Integer>)newValue, this.map, this.immutableMap, this.sortedMap, this.immutableSortedMap, this.set, this.immutableSet, this.sortedSet, this.immutableSortedSet, this.opt, this.enumMap, this.enumSet);
    }

    public final ImmutableBar withMap(Map<String, ? extends Integer> entries) {
        if (this.map == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableBar(this.nums, (ImmutableMap<String, Integer>)newValue, this.immutableMap, this.sortedMap, this.immutableSortedMap, this.set, this.immutableSet, this.sortedSet, this.immutableSortedSet, this.opt, this.enumMap, this.enumSet);
    }

    public final ImmutableBar withImmutableMap(Map<String, ? extends Integer> entries) {
        if (this.immutableMap == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableBar(this.nums, this.map, (ImmutableMap<String, Integer>)newValue, this.sortedMap, this.immutableSortedMap, this.set, this.immutableSet, this.sortedSet, this.immutableSortedSet, this.opt, this.enumMap, this.enumSet);
    }

    public final ImmutableBar withSortedMap(SortedMap<String, Integer> value) {
        if (this.sortedMap == value) {
            return this;
        }
        SortedMap<String, Integer> newValue = Objects.requireNonNull(value, "sortedMap");
        return new ImmutableBar(this.nums, this.map, this.immutableMap, newValue, this.immutableSortedMap, this.set, this.immutableSet, this.sortedSet, this.immutableSortedSet, this.opt, this.enumMap, this.enumSet);
    }

    public final ImmutableBar withImmutableSortedMap(ImmutableSortedMap<String, Integer> value) {
        if (this.immutableSortedMap == value) {
            return this;
        }
        ImmutableSortedMap<String, Integer> newValue = Objects.requireNonNull(value, "immutableSortedMap");
        return new ImmutableBar(this.nums, this.map, this.immutableMap, this.sortedMap, newValue, this.set, this.immutableSet, this.sortedSet, this.immutableSortedSet, this.opt, this.enumMap, this.enumSet);
    }

    public final ImmutableBar withSet(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableBar(this.nums, this.map, this.immutableMap, this.sortedMap, this.immutableSortedMap, (ImmutableSet<String>)newValue, this.immutableSet, this.sortedSet, this.immutableSortedSet, this.opt, this.enumMap, this.enumSet);
    }

    public final ImmutableBar withSet(Iterable<String> elements) {
        if (this.set == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableBar(this.nums, this.map, this.immutableMap, this.sortedMap, this.immutableSortedMap, (ImmutableSet<String>)newValue, this.immutableSet, this.sortedSet, this.immutableSortedSet, this.opt, this.enumMap, this.enumSet);
    }

    public final ImmutableBar withImmutableSet(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutableBar(this.nums, this.map, this.immutableMap, this.sortedMap, this.immutableSortedMap, this.set, (ImmutableSet<String>)newValue, this.sortedSet, this.immutableSortedSet, this.opt, this.enumMap, this.enumSet);
    }

    public final ImmutableBar withImmutableSet(Iterable<String> elements) {
        if (this.immutableSet == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutableBar(this.nums, this.map, this.immutableMap, this.sortedMap, this.immutableSortedMap, this.set, (ImmutableSet<String>)newValue, this.sortedSet, this.immutableSortedSet, this.opt, this.enumMap, this.enumSet);
    }

    public final ImmutableBar withSortedSet(SortedSet<String> value) {
        if (this.sortedSet == value) {
            return this;
        }
        SortedSet<String> newValue = Objects.requireNonNull(value, "sortedSet");
        return new ImmutableBar(this.nums, this.map, this.immutableMap, this.sortedMap, this.immutableSortedMap, this.set, this.immutableSet, newValue, this.immutableSortedSet, this.opt, this.enumMap, this.enumSet);
    }

    public final ImmutableBar withImmutableSortedSet(ImmutableSortedSet<String> value) {
        if (this.immutableSortedSet == value) {
            return this;
        }
        ImmutableSortedSet<String> newValue = Objects.requireNonNull(value, "immutableSortedSet");
        return new ImmutableBar(this.nums, this.map, this.immutableMap, this.sortedMap, this.immutableSortedMap, this.set, this.immutableSet, this.sortedSet, newValue, this.opt, this.enumMap, this.enumSet);
    }

    public final ImmutableBar withOpt(int value) {
        Optional newValue = Optional.of((Object)value);
        if (this.opt.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableBar(this.nums, this.map, this.immutableMap, this.sortedMap, this.immutableSortedMap, this.set, this.immutableSet, this.sortedSet, this.immutableSortedSet, (Optional<Integer>)newValue, this.enumMap, this.enumSet);
    }

    public final ImmutableBar withOpt(Optional<Integer> optional) {
        Optional<Integer> value = optional;
        if (this.opt.equals(value)) {
            return this;
        }
        return new ImmutableBar(this.nums, this.map, this.immutableMap, this.sortedMap, this.immutableSortedMap, this.set, this.immutableSet, this.sortedSet, this.immutableSortedSet, value, this.enumMap, this.enumSet);
    }

    public final ImmutableBar withEnumMap(EnumMap<BoundType, Integer> value) {
        if (this.enumMap == value) {
            return this;
        }
        EnumMap<BoundType, Integer> newValue = Objects.requireNonNull(value, "enumMap");
        return new ImmutableBar(this.nums, this.map, this.immutableMap, this.sortedMap, this.immutableSortedMap, this.set, this.immutableSet, this.sortedSet, this.immutableSortedSet, this.opt, newValue, this.enumSet);
    }

    public final ImmutableBar withEnumSet(EnumSet<BoundType> value) {
        if (this.enumSet == value) {
            return this;
        }
        EnumSet<BoundType> newValue = Objects.requireNonNull(value, "enumSet");
        return new ImmutableBar(this.nums, this.map, this.immutableMap, this.sortedMap, this.immutableSortedMap, this.set, this.immutableSet, this.sortedSet, this.immutableSortedSet, this.opt, this.enumMap, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBar && this.equalTo(0, (ImmutableBar)another);
    }

    private boolean equalTo(int synthetic, ImmutableBar another) {
        return this.nums.equals(another.nums) && this.map.equals(another.map) && this.immutableMap.equals(another.immutableMap) && this.sortedMap.equals(another.sortedMap) && this.immutableSortedMap.equals(another.immutableSortedMap) && this.set.equals(another.set) && this.immutableSet.equals(another.immutableSet) && this.sortedSet.equals(another.sortedSet) && this.immutableSortedSet.equals(another.immutableSortedSet) && this.opt.equals(another.opt) && this.enumMap.equals((Object)another.enumMap) && this.enumSet.equals(another.enumSet);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nums.hashCode();
        h += (h << 5) + this.map.hashCode();
        h += (h << 5) + this.immutableMap.hashCode();
        h += (h << 5) + this.sortedMap.hashCode();
        h += (h << 5) + this.immutableSortedMap.hashCode();
        h += (h << 5) + this.set.hashCode();
        h += (h << 5) + this.immutableSet.hashCode();
        h += (h << 5) + this.sortedSet.hashCode();
        h += (h << 5) + this.immutableSortedSet.hashCode();
        h += (h << 5) + this.opt.hashCode();
        h += (h << 5) + this.enumMap.hashCode();
        h += (h << 5) + this.enumSet.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Bar").omitNullValues().add("nums", this.nums).add("map", this.map).add("immutableMap", this.immutableMap).add("sortedMap", this.sortedMap).add("immutableSortedMap", this.immutableSortedMap).add("set", this.set).add("immutableSet", this.immutableSet).add("sortedSet", this.sortedSet).add("immutableSortedSet", this.immutableSortedSet).add("opt", this.opt.orNull()).add("enumMap", this.enumMap).add("enumSet", this.enumSet).toString();
    }

    public static ImmutableBar copyOf(Bar instance) {
        if (instance instanceof ImmutableBar) {
            return (ImmutableBar)instance;
        }
        return ImmutableBar.builder().addAllNums(instance.nums()).putAllMap(instance.map()).putAllImmutableMap((Map<String, ? extends Integer>)instance.immutableMap()).sortedMap(instance.sortedMap()).immutableSortedMap(instance.immutableSortedMap()).addAllSet(instance.set()).addAllImmutableSet((Iterable<String>)instance.immutableSet()).sortedSet(instance.sortedSet()).immutableSortedSet(instance.immutableSortedSet()).opt(instance.opt()).enumMap(instance.enumMap()).enumSet(instance.enumSet()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Bar", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SORTED_MAP = 1L;
        private static final long INIT_BIT_IMMUTABLE_SORTED_MAP = 2L;
        private static final long INIT_BIT_SORTED_SET = 4L;
        private static final long INIT_BIT_IMMUTABLE_SORTED_SET = 8L;
        private static final long INIT_BIT_ENUM_MAP = 16L;
        private static final long INIT_BIT_ENUM_SET = 32L;
        private static final long OPT_BIT_OPT = 1L;
        private long initBits = 63L;
        private long optBits;
        private final ImmutableList.Builder<Integer> nums = ImmutableList.builder();
        private final ImmutableMap.Builder<String, Integer> map = ImmutableMap.builder();
        private final ImmutableMap.Builder<String, Integer> immutableMap = ImmutableMap.builder();
        @Nullable
        private SortedMap<String, Integer> sortedMap;
        @Nullable
        private ImmutableSortedMap<String, Integer> immutableSortedMap;
        private final ImmutableSet.Builder<String> set = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> immutableSet = ImmutableSet.builder();
        @Nullable
        private SortedSet<String> sortedSet;
        @Nullable
        private ImmutableSortedSet<String> immutableSortedSet;
        private Optional<Integer> opt = Optional.absent();
        @Nullable
        private EnumMap<BoundType, Integer> enumMap;
        @Nullable
        private EnumSet<BoundType> enumSet;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder addNums(int element) {
            this.nums.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNums(int ... elements) {
            this.nums.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllNums(Iterable<Integer> elements) {
            this.nums.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(String key, int value) {
            this.map.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMap(Map.Entry<String, ? extends Integer> entry) {
            this.map.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAllMap(Map<String, ? extends Integer> entries) {
            this.map.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putImmutableMap(String key, int value) {
            this.immutableMap.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putImmutableMap(Map.Entry<String, ? extends Integer> entry) {
            this.immutableMap.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAllImmutableMap(Map<String, ? extends Integer> entries) {
            this.immutableMap.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sortedMap(SortedMap<String, Integer> sortedMap) {
            Builder.checkNotIsSet(this.sortedMapIsSet(), "sortedMap");
            this.sortedMap = Objects.requireNonNull(sortedMap, "sortedMap");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder immutableSortedMap(ImmutableSortedMap<String, Integer> immutableSortedMap) {
            Builder.checkNotIsSet(this.immutableSortedMapIsSet(), "immutableSortedMap");
            this.immutableSortedMap = Objects.requireNonNull(immutableSortedMap, "immutableSortedMap");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSet(String element) {
            this.set.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSet(String ... elements) {
            this.set.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllSet(Iterable<String> elements) {
            this.set.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addImmutableSet(String element) {
            this.immutableSet.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addImmutableSet(String ... elements) {
            this.immutableSet.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAllImmutableSet(Iterable<String> elements) {
            this.immutableSet.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sortedSet(SortedSet<String> sortedSet) {
            Builder.checkNotIsSet(this.sortedSetIsSet(), "sortedSet");
            this.sortedSet = Objects.requireNonNull(sortedSet, "sortedSet");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder immutableSortedSet(ImmutableSortedSet<String> immutableSortedSet) {
            Builder.checkNotIsSet(this.immutableSortedSetIsSet(), "immutableSortedSet");
            this.immutableSortedSet = Objects.requireNonNull(immutableSortedSet, "immutableSortedSet");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder opt(int opt) {
            Builder.checkNotIsSet(this.optIsSet(), "opt");
            this.opt = Optional.of((Object)opt);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder opt(Optional<Integer> opt) {
            Builder.checkNotIsSet(this.optIsSet(), "opt");
            this.opt = opt;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enumMap(EnumMap<BoundType, Integer> enumMap) {
            Builder.checkNotIsSet(this.enumMapIsSet(), "enumMap");
            this.enumMap = Objects.requireNonNull(enumMap, "enumMap");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enumSet(EnumSet<BoundType> enumSet) {
            Builder.checkNotIsSet(this.enumSetIsSet(), "enumSet");
            this.enumSet = Objects.requireNonNull(enumSet, "enumSet");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableBar build() {
            this.checkRequiredAttributes();
            return new ImmutableBar(this.nums.build(), this.map.build(), this.immutableMap.build(), this.sortedMap, this.immutableSortedMap, this.set.build(), this.immutableSet.build(), this.sortedSet, this.immutableSortedSet, this.opt, this.enumMap, this.enumSet);
        }

        private boolean optIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean sortedMapIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean immutableSortedMapIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean sortedSetIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean immutableSortedSetIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean enumMapIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean enumSetIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Bar is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.sortedMapIsSet()) {
                attributes.add("sortedMap");
            }
            if (!this.immutableSortedMapIsSet()) {
                attributes.add("immutableSortedMap");
            }
            if (!this.sortedSetIsSet()) {
                attributes.add("sortedSet");
            }
            if (!this.immutableSortedSetIsSet()) {
                attributes.add("immutableSortedSet");
            }
            if (!this.enumMapIsSet()) {
                attributes.add("enumMap");
            }
            if (!this.enumSetIsSet()) {
                attributes.add("enumSet");
            }
            return "Cannot build Bar, some of required attributes are not set " + attributes;
        }
    }
}

