/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.style.ForceEqualsInWithers;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ForceEqualsInWithers", generator="Immutables")
@Immutable
public final class ImmutableForceEqualsInWithers
implements ForceEqualsInWithers {
    private final float f;
    private final double d;
    private final String s;
    private final boolean b;
    private final char c;
    @Nullable
    private final String o;
    private final ImmutableList<Integer> l;
    @Nullable
    private final ImmutableSet<String> st;
    private final ImmutableMap<String, Integer> mp;

    private ImmutableForceEqualsInWithers(float f, double d, String s, boolean b, char c, @Nullable String o, ImmutableList<Integer> l, @Nullable ImmutableSet<String> st, ImmutableMap<String, Integer> mp) {
        this.f = f;
        this.d = d;
        this.s = s;
        this.b = b;
        this.c = c;
        this.o = o;
        this.l = l;
        this.st = st;
        this.mp = mp;
    }

    @Override
    public float f() {
        return this.f;
    }

    @Override
    public double d() {
        return this.d;
    }

    @Override
    public String s() {
        return this.s;
    }

    @Override
    public boolean b() {
        return this.b;
    }

    @Override
    public char c() {
        return this.c;
    }

    @Override
    public Optional<String> o() {
        return Optional.ofNullable(this.o);
    }

    public ImmutableList<Integer> l() {
        return this.l;
    }

    @Nullable
    public ImmutableSet<String> st() {
        return this.st;
    }

    public ImmutableMap<String, Integer> mp() {
        return this.mp;
    }

    public final ImmutableForceEqualsInWithers withF(float value) {
        if (Float.floatToIntBits(this.f) == Float.floatToIntBits(value)) {
            return this;
        }
        return new ImmutableForceEqualsInWithers(value, this.d, this.s, this.b, this.c, this.o, this.l, this.st, this.mp);
    }

    public final ImmutableForceEqualsInWithers withD(double value) {
        if (Double.doubleToLongBits(this.d) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableForceEqualsInWithers(this.f, value, this.s, this.b, this.c, this.o, this.l, this.st, this.mp);
    }

    public final ImmutableForceEqualsInWithers withS(String value) {
        if (Objects.equals(this.s, value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "s");
        return new ImmutableForceEqualsInWithers(this.f, this.d, newValue, this.b, this.c, this.o, this.l, this.st, this.mp);
    }

    public final ImmutableForceEqualsInWithers withB(boolean value) {
        if (this.b == value) {
            return this;
        }
        return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, value, this.c, this.o, this.l, this.st, this.mp);
    }

    public final ImmutableForceEqualsInWithers withC(char value) {
        if (this.c == value) {
            return this;
        }
        return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, value, this.o, this.l, this.st, this.mp);
    }

    public final ImmutableForceEqualsInWithers withO(String value) {
        String newValue = Objects.requireNonNull(value, "o");
        if (Objects.equals(this.o, newValue)) {
            return this;
        }
        return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, this.c, newValue, this.l, this.st, this.mp);
    }

    public final ImmutableForceEqualsInWithers withO(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.o, value)) {
            return this;
        }
        return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, this.c, value, this.l, this.st, this.mp);
    }

    public final ImmutableForceEqualsInWithers withL(int ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, this.c, this.o, (ImmutableList<Integer>)newValue, this.st, this.mp);
    }

    public final ImmutableForceEqualsInWithers withL(Iterable<Integer> elements) {
        if (Objects.equals(this.l, elements)) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, this.c, this.o, (ImmutableList<Integer>)newValue, this.st, this.mp);
    }

    public final ImmutableForceEqualsInWithers withSt(String ... elements) {
        if (elements == null) {
            return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, this.c, this.o, this.l, null, this.mp);
        }
        ImmutableSet newValue = elements == null ? null : ImmutableSet.copyOf((Object[])elements);
        return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, this.c, this.o, this.l, (ImmutableSet<String>)newValue, this.mp);
    }

    public final ImmutableForceEqualsInWithers withSt(@Nullable Iterable<String> elements) {
        if (Objects.equals(this.st, elements)) {
            return this;
        }
        ImmutableSet newValue = elements == null ? null : ImmutableSet.copyOf(elements);
        return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, this.c, this.o, this.l, (ImmutableSet<String>)newValue, this.mp);
    }

    public final ImmutableForceEqualsInWithers withMp(Map<String, ? extends Integer> entries) {
        if (Objects.equals(this.mp, entries)) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, this.c, this.o, this.l, this.st, (ImmutableMap<String, Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableForceEqualsInWithers && this.equalTo(0, (ImmutableForceEqualsInWithers)another);
    }

    private boolean equalTo(int synthetic, ImmutableForceEqualsInWithers another) {
        return Float.floatToIntBits(this.f) == Float.floatToIntBits(another.f) && Double.doubleToLongBits(this.d) == Double.doubleToLongBits(another.d) && this.s.equals(another.s) && this.b == another.b && this.c == another.c && Objects.equals(this.o, another.o) && this.l.equals(another.l) && Objects.equals(this.st, another.st) && this.mp.equals(another.mp);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Floats.hashCode((float)this.f);
        h += (h << 5) + Doubles.hashCode((double)this.d);
        h += (h << 5) + this.s.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.b);
        h += (h << 5) + Chars.hashCode((char)this.c);
        h += (h << 5) + Objects.hashCode(this.o);
        h += (h << 5) + this.l.hashCode();
        h += (h << 5) + Objects.hashCode(this.st);
        h += (h << 5) + this.mp.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ForceEqualsInWithers").omitNullValues().add("f", this.f).add("d", this.d).add("s", (Object)this.s).add("b", this.b).add("c", this.c).add("o", (Object)this.o).add("l", this.l).add("st", this.st).add("mp", this.mp).toString();
    }

    public static ImmutableForceEqualsInWithers copyOf(ForceEqualsInWithers instance) {
        if (instance instanceof ImmutableForceEqualsInWithers) {
            return (ImmutableForceEqualsInWithers)instance;
        }
        return ImmutableForceEqualsInWithers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ForceEqualsInWithers", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_F = 1L;
        private static final long INIT_BIT_D = 2L;
        private static final long INIT_BIT_S = 4L;
        private static final long INIT_BIT_B = 8L;
        private static final long INIT_BIT_C = 16L;
        private long initBits = 31L;
        private float f;
        private double d;
        @Nullable
        private String s;
        private boolean b;
        private char c;
        @Nullable
        private String o;
        private ImmutableList.Builder<Integer> l = ImmutableList.builder();
        private ImmutableSet.Builder<String> st = null;
        private ImmutableMap.Builder<String, Integer> mp = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ForceEqualsInWithers instance) {
            Objects.requireNonNull(instance, "instance");
            this.f(instance.f());
            this.d(instance.d());
            this.s(instance.s());
            this.b(instance.b());
            this.c(instance.c());
            Optional<String> oOptional = instance.o();
            if (oOptional.isPresent()) {
                this.o(oOptional);
            }
            this.addAllL(instance.l());
            Set<String> stValue = instance.st();
            if (stValue != null) {
                this.addAllSt(stValue);
            }
            this.putAllMp(instance.mp());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder f(float f) {
            this.f = f;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder d(double d) {
            this.d = d;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder s(String s) {
            this.s = Objects.requireNonNull(s, "s");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder b(boolean b) {
            this.b = b;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder c(char c) {
            this.c = c;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder o(String o) {
            this.o = Objects.requireNonNull(o, "o");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder o(Optional<String> o) {
            this.o = o.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addL(int element) {
            this.l.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addL(int ... elements) {
            this.l.addAll((Iterable)Ints.asList((int[])elements));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder l(Iterable<Integer> elements) {
            this.l = ImmutableList.builder();
            return this.addAllL(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllL(Iterable<Integer> elements) {
            this.l.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSt(String element) {
            if (this.st == null) {
                this.st = ImmutableSet.builder();
            }
            this.st.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSt(String ... elements) {
            if (this.st == null) {
                this.st = ImmutableSet.builder();
            }
            this.st.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder st(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.st = null;
                return this;
            }
            this.st = ImmutableSet.builder();
            return this.addAllSt(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSt(Iterable<String> elements) {
            Objects.requireNonNull(elements, "st element");
            if (this.st == null) {
                this.st = ImmutableSet.builder();
            }
            this.st.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMp(String key, int value) {
            this.mp.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMp(Map.Entry<String, ? extends Integer> entry) {
            this.mp.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mp(Map<String, ? extends Integer> entries) {
            this.mp = ImmutableMap.builder();
            return this.putAllMp(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMp(Map<String, ? extends Integer> entries) {
            this.mp.putAll(entries);
            return this;
        }

        public ImmutableForceEqualsInWithers build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, this.c, this.o, this.l.build(), this.st == null ? null : this.st.build(), this.mp.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("f");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("d");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("s");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("b");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("c");
            }
            return "Cannot build ForceEqualsInWithers, some of required attributes are not set " + attributes;
        }
    }
}

