/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.with;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.with.WithEnums;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="WithEnums", generator="Immutables")
@Immutable
public final class ImmutableWithEnums
extends WithEnums {
    private final RoundingMode roundingMode;
    @Nullable
    private final RoundingMode nullableRoundingMode;
    @Nullable
    private final RoundingMode maybeRoundingMode;

    private ImmutableWithEnums(RoundingMode roundingMode, @Nullable RoundingMode nullableRoundingMode, @Nullable RoundingMode maybeRoundingMode) {
        this.roundingMode = roundingMode;
        this.nullableRoundingMode = nullableRoundingMode;
        this.maybeRoundingMode = maybeRoundingMode;
    }

    @Override
    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    @Override
    @Nullable
    public RoundingMode getNullableRoundingMode() {
        return this.nullableRoundingMode;
    }

    @Override
    public Optional<RoundingMode> getMaybeRoundingMode() {
        return Optional.ofNullable(this.maybeRoundingMode);
    }

    public final ImmutableWithEnums withRoundingMode(RoundingMode value) {
        RoundingMode newValue = Objects.requireNonNull(value, "roundingMode");
        if (this.roundingMode == newValue) {
            return this;
        }
        return new ImmutableWithEnums(newValue, this.nullableRoundingMode, this.maybeRoundingMode);
    }

    public final ImmutableWithEnums withNullableRoundingMode(@Nullable RoundingMode value) {
        if (this.nullableRoundingMode == value) {
            return this;
        }
        return new ImmutableWithEnums(this.roundingMode, value, this.maybeRoundingMode);
    }

    public final ImmutableWithEnums withMaybeRoundingMode(RoundingMode value) {
        RoundingMode newValue = Objects.requireNonNull(value, "maybeRoundingMode");
        if (this.maybeRoundingMode == newValue) {
            return this;
        }
        return new ImmutableWithEnums(this.roundingMode, this.nullableRoundingMode, newValue);
    }

    public final ImmutableWithEnums withMaybeRoundingMode(Optional<? extends RoundingMode> optional) {
        RoundingMode value = optional.orElse(null);
        if (this.maybeRoundingMode == value) {
            return this;
        }
        return new ImmutableWithEnums(this.roundingMode, this.nullableRoundingMode, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWithEnums && this.equalTo(0, (ImmutableWithEnums)another);
    }

    private boolean equalTo(int synthetic, ImmutableWithEnums another) {
        return this.roundingMode.equals((Object)another.roundingMode) && Objects.equals((Object)this.nullableRoundingMode, (Object)another.nullableRoundingMode) && Objects.equals((Object)this.maybeRoundingMode, (Object)another.maybeRoundingMode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.roundingMode.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.nullableRoundingMode);
        h += (h << 5) + Objects.hashCode((Object)this.maybeRoundingMode);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WithEnums").omitNullValues().add("roundingMode", (Object)this.roundingMode).add("nullableRoundingMode", (Object)this.nullableRoundingMode).add("maybeRoundingMode", (Object)this.maybeRoundingMode).toString();
    }

    public static ImmutableWithEnums copyOf(WithEnums instance) {
        if (instance instanceof ImmutableWithEnums) {
            return (ImmutableWithEnums)instance;
        }
        return ImmutableWithEnums.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WithEnums", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ROUNDING_MODE = 1L;
        private long initBits = 1L;
        @Nullable
        private RoundingMode roundingMode;
        @Nullable
        private RoundingMode nullableRoundingMode;
        @Nullable
        private RoundingMode maybeRoundingMode;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(WithEnums instance) {
            Optional<RoundingMode> maybeRoundingModeOptional;
            Objects.requireNonNull(instance, "instance");
            this.roundingMode(instance.getRoundingMode());
            RoundingMode nullableRoundingModeValue = instance.getNullableRoundingMode();
            if (nullableRoundingModeValue != null) {
                this.nullableRoundingMode(nullableRoundingModeValue);
            }
            if ((maybeRoundingModeOptional = instance.getMaybeRoundingMode()).isPresent()) {
                this.maybeRoundingMode(maybeRoundingModeOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder roundingMode(RoundingMode roundingMode) {
            this.roundingMode = Objects.requireNonNull(roundingMode, "roundingMode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nullableRoundingMode(@Nullable RoundingMode nullableRoundingMode) {
            this.nullableRoundingMode = nullableRoundingMode;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maybeRoundingMode(RoundingMode maybeRoundingMode) {
            this.maybeRoundingMode = Objects.requireNonNull(maybeRoundingMode, "maybeRoundingMode");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maybeRoundingMode(Optional<? extends RoundingMode> maybeRoundingMode) {
            this.maybeRoundingMode = maybeRoundingMode.orElse(null);
            return this;
        }

        public ImmutableWithEnums build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWithEnums(this.roundingMode, this.nullableRoundingMode, this.maybeRoundingMode);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("roundingMode");
            }
            return "Cannot build WithEnums, some of required attributes are not set " + attributes;
        }
    }
}

