package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Reporter}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableReporter.of()}.
 */
@Generated(from = "Reporter", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableReporter extends Reporter {
  private final Messager messager;
  private final Optional<Element> element;
  private final Optional<AnnotationMirror> annotation;

  private ImmutableReporter(Messager messager) {
    this.messager = Objects.requireNonNull(messager, "messager");
    this.element = Optional.absent();
    this.annotation = Optional.absent();
  }

  private ImmutableReporter(
      Messager messager,
      Optional<Element> element,
      Optional<AnnotationMirror> annotation) {
    this.messager = messager;
    this.element = element;
    this.annotation = annotation;
  }

  /**
   * @return The value of the {@code messager} attribute
   */
  @Override
  Messager messager() {
    return messager;
  }

  /**
   * @return The value of the {@code element} attribute
   */
  @Override
  Optional<Element> element() {
    return element;
  }

  /**
   * @return The value of the {@code annotation} attribute
   */
  @Override
  Optional<AnnotationMirror> annotation() {
    return annotation;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Reporter#messager() messager} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for messager
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReporter withMessager(Messager value) {
    if (this.messager == value) return this;
    Messager newValue = Objects.requireNonNull(value, "messager");
    return new ImmutableReporter(newValue, this.element, this.annotation);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Reporter#element() element} attribute.
   * @param value The value for element
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReporter withElement(Element value) {
    Optional<Element> newValue = Optional.of(value);
    if (this.element.isPresent() && this.element.get() == value) return this;
    return new ImmutableReporter(this.messager, newValue, this.annotation);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Reporter#element() element} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for element
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableReporter withElement(Optional<? extends Element> optional) {
    Optional<Element> value = (Optional<Element>) optional;
    if (!this.element.isPresent() && !value.isPresent()) return this;
    if (this.element.isPresent() && value.isPresent() && this.element.get() == value.get()) return this;
    return new ImmutableReporter(this.messager, value, this.annotation);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Reporter#annotation() annotation} attribute.
   * @param value The value for annotation
   * @return A modified copy of {@code this} object
   */
  public final ImmutableReporter withAnnotation(AnnotationMirror value) {
    Optional<AnnotationMirror> newValue = Optional.of(value);
    if (this.annotation.isPresent() && this.annotation.get() == value) return this;
    return new ImmutableReporter(this.messager, this.element, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Reporter#annotation() annotation} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for annotation
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableReporter withAnnotation(Optional<? extends AnnotationMirror> optional) {
    Optional<AnnotationMirror> value = (Optional<AnnotationMirror>) optional;
    if (!this.annotation.isPresent() && !value.isPresent()) return this;
    if (this.annotation.isPresent() && value.isPresent() && this.annotation.get() == value.get()) return this;
    return new ImmutableReporter(this.messager, this.element, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReporter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReporter
        && equalTo((ImmutableReporter) another);
  }

  private boolean equalTo(ImmutableReporter another) {
    return messager.equals(another.messager)
        && element.equals(another.element)
        && annotation.equals(another.annotation);
  }

  /**
   * Computes a hash code from attributes: {@code messager}, {@code element}, {@code annotation}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + messager.hashCode();
    h += (h << 5) + element.hashCode();
    h += (h << 5) + annotation.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Reporter} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Reporter")
        .omitNullValues()
        .add("messager", messager)
        .add("element", element.orNull())
        .add("annotation", annotation.orNull())
        .toString();
  }

  /**
   * Construct a new immutable {@code Reporter} instance.
   * @param messager The value for the {@code messager} attribute
   * @return An immutable Reporter instance
   */
  public static ImmutableReporter of(Messager messager) {
    return new ImmutableReporter(messager);
  }

  /**
   * Creates an immutable copy of a {@link Reporter} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Reporter instance
   */
  public static ImmutableReporter copyOf(Reporter instance) {
    if (instance instanceof ImmutableReporter) {
      return (ImmutableReporter) instance;
    }
    return ImmutableReporter.of(instance.messager())
        .withElement(instance.element())
        .withAnnotation(instance.annotation());
  }
}
