/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.encode;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.immutables.value.Value;
import org.immutables.value.internal.;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Predicate;
import org.immutables.value.internal.$guava$.base.$Verify;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.collect.$ImmutableSet;
import org.immutables.value.internal.$guava$.collect.$Iterables;
import org.immutables.value.internal.$guava$.collect.$Iterators;
import org.immutables.value.internal.$guava$.collect.$PeekingIterator;

@Value.Enclosing
final class $Structurizer {
    private static final $ImmutableSet<String> modifiers = $Structurizer.allModifiers();
    private final $PeekingIterator<.processor..Code.Term> terms;
    private final WhitespaceEnabler whitespaces = new WhitespaceEnabler();

    $Structurizer(Iterable<.processor..Code.Term> terms) {
        this.terms = $Iterators.peekingIterator($Iterators.filter(terms.iterator(), this.whitespaces));
    }

    List<Statement> structurize() {
        ArrayList<Statement> result = new ArrayList<Statement>();
        while (this.terms.hasNext()) {
            result.add(this.statement());
        }
        return result;
    }

    private Statement statement() {
        Statement.Builder builder = new Statement.Builder();
        boolean classDecl = false;
        boolean wasParameters = false;
        while (true) {
            .processor..Code.Term t;
            if ((t = this.terms.peek()).is("=")) {
                this.terms.next();
                this.expressionUpToSemicolon(builder);
                return builder.build();
            }
            if (t.is("(") && !wasParameters) {
                builder.addAllParameters(this.collectUntilMatching(")"));
                wasParameters = true;
                continue;
            }
            if (t.is("{")) {
                this.block(builder, classDecl);
                return builder.build();
            }
            if (t.is(";")) {
                this.terms.next();
                return builder.build();
            }
            if (wasParameters) {
                this.terms.next();
                continue;
            }
            if (!this.signature(builder)) continue;
            classDecl = true;
            builder.name($Optional.of(this.terms.peek().toString()));
        }
    }

    private List<.processor..Code.Term> collectUntilMatching(String end) {
        ArrayList<.processor..Code.Term> result = new ArrayList<.processor..Code.Term>();
        this.doCollectMatching(result, this.terms.peek().toString(), end);
        return result;
    }

    private void doCollectMatching(List<.processor..Code.Term> accumulator, String start, String end) {
        this.whitespaces.on();
        try {
            accumulator.add(this.terms.next());
            while (true) {
                .processor..Code.Term t;
                if ((t = this.terms.peek()).is(start)) {
                    this.doCollectMatching(accumulator, start, end);
                    continue;
                }
                if (t.is(end)) {
                    accumulator.add(this.terms.next());
                    return;
                }
                accumulator.add(this.terms.next());
            }
        }
        finally {
            this.whitespaces.off();
        }
    }

    private void expressionUpToSemicolon(Statement.Builder builder) {
        this.terms.peek();
        this.whitespaces.on();
        try {
            ArrayList<.processor..Code.Term> result = new ArrayList<.processor..Code.Term>();
            while (true) {
                .processor..Code.Term t;
                if ((t = this.terms.peek()).is("(")) {
                    this.doCollectMatching(result, "(", ")");
                    continue;
                }
                if (t.is("{")) {
                    this.doCollectMatching(result, "{", "}");
                    continue;
                }
                if (t.is("[")) {
                    this.doCollectMatching(result, "[", "]");
                    continue;
                }
                if (t.is(";")) {
                    builder.addAllExpression(result);
                    return;
                }
                result.add(this.terms.next());
            }
        }
        finally {
            this.whitespaces.off();
        }
    }

    private void block(Statement.Builder builder, boolean classDecl) {
        if (classDecl) {
            $Verify.verify(this.terms.peek().is("{"));
            this.terms.next();
            while (this.terms.hasNext() && !this.terms.peek().is("}")) {
                builder.addDefinitions(this.statement());
            }
            $Verify.verify(this.terms.next().is("}"));
        } else {
            builder.addAllBlock(this.collectUntilMatching("}"));
        }
    }

    private boolean signature(Statement.Builder builder) {
        .processor..Code.Term t = this.terms.peek();
        if (t.is("@")) {
            do {
                builder.addAnnotations(this.terms.next());
                $Verify.verify(this.terms.peek().isWordOrNumber());
                builder.addAnnotations(this.terms.next());
            } while (this.terms.peek().is("."));
            if (this.terms.peek().is("(")) {
                builder.addAllAnnotations(this.collectUntilMatching(")"));
            }
            return false;
        }
        if (t.is("<")) {
            builder.addAllSignature(this.collectUntilMatching(">"));
            return false;
        }
        if (t.is("class") || t.is("interface")) {
            builder.addSignature(this.terms.next());
            return true;
        }
        builder.addSignature(this.terms.next());
        return false;
    }

    private static List<.processor..Code.Term> parseReturnType(List<.processor..Code.Term> signature) {
        if (signature.isEmpty()) {
            return $ImmutableList.of();
        }
        ArrayDeque<.processor..Code.Term> terms = new ArrayDeque<.processor..Code.Term>(signature);
        .processor..Code.Term last = (.processor..Code.Term)terms.removeLast();
        if (!last.isWordOrNumber() || last.is("static")) {
            return $ImmutableList.of();
        }
        while (!terms.isEmpty()) {
            .processor..Code.Term t = (.processor..Code.Term)terms.peek();
            if (t.is("<")) {
                $Structurizer.removeTillMatching(terms, "<", ">");
                continue;
            }
            if (modifiers.contains(t.toString())) {
                terms.remove();
                continue;
            }
            $Structurizer.removeCommentsAndWhitespace(terms);
            return $ImmutableList.copyOf(terms);
        }
        return $ImmutableList.of();
    }

    private static void removeCommentsAndWhitespace(Deque<.processor..Code.Term> terms) {
        Iterator<.processor..Code.Term> it = terms.iterator();
        while (it.hasNext()) {
            .processor..Code.Term n = it.next();
            if (!n.isComment() && !n.isWhitespace()) continue;
            it.remove();
        }
    }

    private static void removeTillMatching(Deque<.processor..Code.Term> terms, String begin, String end) {
        assert (terms.peek().is(begin));
        terms.remove();
        while (true) {
            if (terms.peek().is(begin)) {
                $Structurizer.removeTillMatching(terms, begin, end);
                continue;
            }
            if (terms.remove().is(end)) break;
        }
    }

    private static $ImmutableSet<String> allModifiers() {
        $ImmutableSet.Builder b = $ImmutableSet.builder();
        for (Modifier m : Modifier.values()) {
            b.add(m.toString());
        }
        return b.build();
    }

    @Value.Immutable
    static abstract class Statement {
        Statement() {
        }

        abstract List<.processor..Code.Term> annotations();

        abstract List<.processor..Code.Term> signature();

        abstract List<.processor..Code.Term> parameters();

        abstract List<.processor..Code.Term> expression();

        abstract List<.processor..Code.Term> block();

        abstract List<Statement> definitions();

        @Value.Derived
        boolean isClassOrInterface() {
            for (.processor..Code.Term t : this.signature()) {
                if (!t.is("class") && !t.is("interface")) continue;
                return true;
            }
            return false;
        }

        @Value.Lazy
        List<.processor..Code.Term> returnType() {
            return $Structurizer.parseReturnType(this.signature());
        }

        @Value.Default
        $Optional<String> name() {
            if (this.signature().isEmpty()) {
                return $Optional.absent();
            }
            .processor..Code.Term last = $Iterables.getLast(this.signature());
            if (last.isWordOrNumber() && !last.is("static")) {
                return $Optional.of(last.toString());
            }
            return $Optional.absent();
        }

        static class Builder
        extends .processor..ImmutableStructurizer.Statement.Builder {
            Builder() {
            }
        }
    }

    private final class WhitespaceEnabler
    implements $Predicate<.processor..Code.Term> {
        private int count;

        private WhitespaceEnabler() {
        }

        void on() {
            ++this.count;
        }

        void off() {
            if (--this.count < 0) {
                throw new IllegalStateException("unmatched off");
            }
        }

        @Override
        public boolean apply(.processor..Code.Term input) {
            return this.count > 0 || !input.isWhitespace() && !input.isComment();
        }
    }
}

