/*
 * Decompiled with CFR 0.152.
 */
package org.incava.diff;

public class Difference {
    public static final Integer NONE = -1;
    private final Integer delStart;
    private final Integer delEnd;
    private final Integer addStart;
    private final Integer addEnd;

    public Difference(Integer delStart, Integer delEnd, Integer addStart, Integer addEnd) {
        this.delStart = delStart;
        this.delEnd = delEnd;
        this.addStart = addStart;
        this.addEnd = addEnd;
    }

    public Integer getDeletedStart() {
        return this.delStart;
    }

    public Integer getDeletedEnd() {
        return this.delEnd;
    }

    public Integer getAddedStart() {
        return this.addStart;
    }

    public Integer getAddedEnd() {
        return this.addEnd;
    }

    public boolean isAdd() {
        return this.delEnd == NONE;
    }

    public boolean isDelete() {
        return this.addEnd == NONE;
    }

    public boolean isChange() {
        return this.addEnd != NONE && this.delEnd != NONE;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Difference) {
            Difference other = (Difference)obj;
            return this.delStart == other.delStart && this.delEnd == other.delEnd && this.addStart == other.addStart && this.addEnd == other.addEnd;
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        for (Integer i : new Integer[]{this.delStart, this.delEnd, this.addStart, this.addEnd}) {
            hash = hash * 17 + i.hashCode();
        }
        return hash;
    }

    public String toStringOrig() {
        StringBuilder sb = new StringBuilder();
        sb.append("del: [").append(this.delStart).append(", ").append(this.delEnd).append(']');
        sb.append(' ');
        sb.append("add: [").append(this.addStart).append(", ").append(this.addEnd).append(']');
        sb.append("add: [").append(this.addStart).append(", ").append(this.addEnd).append(']');
        return sb.toString();
    }

    protected String toString(int from, int to) {
        StringBuilder sb = new StringBuilder("[");
        if (from != NONE) {
            sb.append(from);
            if (to != NONE) {
                sb.append(", ").append(to);
            }
        } else {
            sb.append(to);
        }
        sb.append(']');
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString(this.delStart, this.delEnd));
        sb.append(" => ");
        sb.append(this.toString(this.addStart, this.addEnd));
        return sb.toString();
    }
}

