/*
 * Decompiled with CFR 0.152.
 */
package org.incava.diff;

import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Thresholds
extends TreeMap<Integer, Integer> {
    public static final long serialVersionUID = 1L;

    protected static boolean isNonzero(Integer i) {
        return i != null && i != 0;
    }

    protected boolean isGreaterThan(Integer index, Integer val) {
        Integer lhs = (Integer)this.get(index);
        return lhs != null && val != null && lhs.compareTo(val) > 0;
    }

    protected boolean isLessThan(Integer index, Integer val) {
        Integer lhs = (Integer)this.get(index);
        return lhs != null && (val == null || lhs.compareTo(val) < 0);
    }

    protected Integer getLastValue() {
        return (Integer)this.get(this.lastKey());
    }

    protected void append(Integer value) {
        Integer addIdx = null;
        if (this.isEmpty()) {
            addIdx = 0;
        } else {
            Integer lastKey = (Integer)this.lastKey();
            addIdx = lastKey + 1;
        }
        this.put(addIdx, value);
    }

    public Integer insert(Integer j, Integer k) {
        if (Thresholds.isNonzero(k) && this.isGreaterThan(k, j) && this.isLessThan(k - 1, j)) {
            this.put(k, j);
            return k;
        }
        int hi = -1;
        if (Thresholds.isNonzero(k)) {
            hi = k;
        } else if (!this.isEmpty()) {
            hi = (Integer)this.lastKey();
        }
        if (hi == -1 || j.compareTo(this.getLastValue()) > 0) {
            this.append(j);
            return hi + 1;
        }
        int lo = 0;
        while (lo <= hi) {
            int index = (hi + lo) / 2;
            Integer val = (Integer)this.get(index);
            int cmp = j.compareTo(val);
            if (cmp == 0) {
                return null;
            }
            if (cmp > 0) {
                lo = index + 1;
                continue;
            }
            hi = index - 1;
        }
        this.put(lo, j);
        return lo;
    }
}

