/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.source;

import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.inferred.freebuilder.processor.source.AnnotationSource;
import org.inferred.freebuilder.processor.source.CompilationUnitBuilder;
import org.inferred.freebuilder.processor.source.CompilerReflection;
import org.inferred.freebuilder.processor.source.ElementAppender;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.IsInvalidTypeVisitor;
import org.inferred.freebuilder.processor.source.QualifiedName;
import org.inferred.freebuilder.processor.source.RuntimeReflection;
import org.inferred.freebuilder.processor.source.Scope;
import org.inferred.freebuilder.processor.source.ScopeHandler;
import org.inferred.freebuilder.processor.source.TemplateApplier;
import org.inferred.freebuilder.processor.source.TypeMirrorAppender;
import org.inferred.freebuilder.processor.source.feature.EnvironmentFeatureSet;
import org.inferred.freebuilder.processor.source.feature.Feature;
import org.inferred.freebuilder.processor.source.feature.FeatureSet;
import org.inferred.freebuilder.processor.source.feature.FeatureType;
import org.inferred.freebuilder.processor.source.feature.StaticFeatureSet;
import org.inferred.freebuilder.shaded.com.google.common.annotations.VisibleForTesting;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;

public class SourceBuilder {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final CompilationUnitBuilder source;

    public static SourceBuilder forEnvironment(ProcessingEnvironment env, FeatureSet features) {
        return new SourceBuilder(new CompilerReflection(env.getElementUtils()), Optional.ofNullable(features).orElseGet(() -> new EnvironmentFeatureSet(env)));
    }

    @VisibleForTesting
    public static SourceBuilder forTesting(Feature<?> ... features) {
        return SourceBuilder.forTesting(new StaticFeatureSet(features));
    }

    @VisibleForTesting
    public static SourceBuilder forTesting(FeatureSet features) {
        return new SourceBuilder(new RuntimeReflection(ClassLoader.getSystemClassLoader()), features);
    }

    private SourceBuilder(ScopeHandler.Reflection reflect, FeatureSet features) {
        this.source = new CompilationUnitBuilder(reflect, features);
    }

    public SourceBuilder add(String fmt, Object ... args) {
        TemplateApplier.withParams(args).onText(this.source::append).onParam(this::add).parse(fmt);
        return this;
    }

    public SourceBuilder add(Excerpt excerpt) {
        excerpt.addTo(this);
        return this;
    }

    public SourceBuilder addLine(String fmt, Object ... args) {
        this.add(fmt, args);
        this.source.append(LINE_SEPARATOR);
        return this;
    }

    public <T extends Feature<T>> T feature(FeatureType<T> featureType) {
        return this.source.feature(featureType);
    }

    public Scope scope() {
        return this.source.scope();
    }

    public QualifiedName typename() {
        return this.source.typename();
    }

    public String toString() {
        return this.source.toString();
    }

    private void add(Object arg) {
        if (arg instanceof Excerpt) {
            ((Excerpt)arg).addTo(this);
        } else if (arg instanceof Package) {
            this.source.append(((Package)arg).getName());
        } else if (arg instanceof Element) {
            ElementAppender.appendShortened((Element)arg, this.source);
        } else if (arg instanceof Class) {
            this.source.append(QualifiedName.of((Class)arg));
        } else if (arg instanceof TypeMirror) {
            TypeMirror mirror = (TypeMirror)arg;
            Preconditions.checkArgument(IsInvalidTypeVisitor.isLegalType(mirror), "Cannot write unknown type %s", mirror);
            TypeMirrorAppender.appendShortened(mirror, this.source);
        } else if (arg instanceof QualifiedName) {
            this.source.append((QualifiedName)arg);
        } else if (arg instanceof AnnotationMirror) {
            AnnotationSource.addSource(this, (AnnotationMirror)arg);
        } else if (arg instanceof CharSequence) {
            this.source.append((CharSequence)arg);
        } else {
            this.source.append(arg.toString());
        }
    }
}

