/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.common.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    ANNOTATION,
    BATCH_SIZE,
    CONNECTION_URL,
    CREATE_ON_START,
    DIALECT,
    DB_MAJOR_VERSION,
    DB_MINOR_VERSION,
    DELETE_ALL,
    DELETE_SINGLE,
    JNDI_URL,
    DRIVER,
    DROP_ON_EXIT,
    EMBEDDED_KEY,
    FETCH_SIZE,
    FILE_NAME,
    KEY_COLUMNS,
    KEY_MESSAGE_NAME,
    KEY_TO_STRING_MAPPER,
    MESSAGE_NAME,
    NAME,
    PACKAGE,
    PASSIVATION,
    PASSWORD,
    PREFIX,
    PROPERTIES_FILE,
    READ_QUERY_TIMEOUT,
    SELECT_ALL,
    SELECT_SINGLE,
    SIZE,
    TABLE_NAME,
    TYPE,
    UPSERT,
    USERNAME,
    WRITE_QUERY_TIMEOUT;

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    private Attribute() {
        this.name = this.name().toLowerCase().replace('_', '-');
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

