/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.persistence.jdbc.common.configuration.AbstractJdbcStoreConfigurationSerializer;
import org.infinispan.persistence.jdbc.common.configuration.Attribute;
import org.infinispan.persistence.jdbc.common.configuration.Element;
import org.infinispan.persistence.jdbc.configuration.DataColumnConfiguration;
import org.infinispan.persistence.jdbc.configuration.IdColumnConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.SegmentColumnConfiguration;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.configuration.TimestampColumnConfiguration;

public class JdbcStringBasedStoreConfigurationSerializer
extends AbstractJdbcStoreConfigurationSerializer
implements ConfigurationSerializer<JdbcStringBasedStoreConfiguration> {
    public void serialize(ConfigurationWriter writer, JdbcStringBasedStoreConfiguration configuration) {
        writer.writeStartElement((Enum)Element.STRING_KEYED_JDBC_STORE);
        writer.writeDefaultNamespace("urn:infinispan:config:store:jdbc:" + Version.getMajorMinor());
        this.writeJdbcStoreAttributes(writer, configuration);
        this.writeCommonStoreSubAttributes(writer, (AbstractStoreConfiguration)configuration);
        this.writeJDBCStoreTable(writer, Element.STRING_KEYED_TABLE, configuration.table());
        this.writeJDBCStoreConnection(writer, configuration);
        this.writeCommonStoreElements(writer, (StoreConfiguration)configuration);
        writer.writeEndElement();
    }

    protected void writeJDBCStoreTable(ConfigurationWriter writer, Element element, TableManipulationConfiguration configuration) {
        AttributeSet attributes = configuration.attributes();
        writer.writeStartElement((Enum)element);
        attributes.write(writer, TableManipulationConfiguration.TABLE_NAME_PREFIX, (Enum)Attribute.PREFIX);
        attributes.write(writer, TableManipulationConfiguration.BATCH_SIZE, (Enum)Attribute.BATCH_SIZE);
        attributes.write(writer, TableManipulationConfiguration.FETCH_SIZE, (Enum)Attribute.FETCH_SIZE);
        attributes.write(writer, TableManipulationConfiguration.CREATE_ON_START, (Enum)Attribute.CREATE_ON_START);
        attributes.write(writer, TableManipulationConfiguration.DROP_ON_EXIT, (Enum)Attribute.DROP_ON_EXIT);
        this.writeJDBCStoreColumn(writer, Element.ID_COLUMN, configuration.idColumnConfiguration().attributes(), IdColumnConfiguration.ID_COLUMN_NAME, IdColumnConfiguration.ID_COLUMN_TYPE);
        this.writeJDBCStoreColumn(writer, Element.DATA_COLUMN, configuration.dataColumnConfiguration().attributes(), DataColumnConfiguration.DATA_COLUMN_NAME, DataColumnConfiguration.DATA_COLUMN_TYPE);
        this.writeJDBCStoreColumn(writer, Element.TIMESTAMP_COLUMN, configuration.timeStampColumnConfiguration().attributes(), TimestampColumnConfiguration.TIMESTAMP_COLUMN_NAME, TimestampColumnConfiguration.TIMESTAMP_COLUMN_TYPE);
        this.writeJDBCStoreColumn(writer, Element.SEGMENT_COLUMN, configuration.segmentColumnConfiguration().attributes(), SegmentColumnConfiguration.SEGMENT_COLUMN_NAME, SegmentColumnConfiguration.SEGMENT_COLUMN_TYPE);
        writer.writeEndElement();
    }

    private void writeJDBCStoreColumn(ConfigurationWriter writer, Element element, AttributeSet attributes, AttributeDefinition<?> columnName, AttributeDefinition<?> columnType) {
        writer.writeStartElement((Enum)element);
        attributes.write(writer, columnName, (Enum)Attribute.NAME);
        attributes.write(writer, columnType, (Enum)Attribute.TYPE);
        writer.writeEndElement();
    }
}

