/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.common.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class BeanManagerProvider
implements Extension {
    private static final Logger LOG = Logger.getLogger(BeanManagerProvider.class.getName());
    private static BeanManagerProvider bmpSingleton = null;
    private volatile Map<ClassLoader, BeanManagerInfo> bmInfos = new ConcurrentHashMap<ClassLoader, BeanManagerInfo>();

    public static boolean isActive() {
        return bmpSingleton != null;
    }

    public static BeanManagerProvider getInstance() {
        if (bmpSingleton == null) {
            throw new IllegalStateException("No " + BeanManagerProvider.class.getName() + " in place! Please ensure that you configured the CDI implementation of your choice properly. If your setup is correct, please clear all caches and compiled artifacts.");
        }
        return bmpSingleton;
    }

    public void setBeanManager(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        BeanManagerProvider.setBeanManagerProvider(this);
        BeanManagerInfo bmi = this.getBeanManagerInfo(BeanManagerProvider.getClassLoader(null));
        bmi.loadTimeBm = beanManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanManager getBeanManager() {
        BeanManager result;
        BeanManagerInfo bmi = this.getBeanManagerInfo(BeanManagerProvider.getClassLoader(null));
        if (!bmi.booted) {
            LOG.warning("When using the BeanManager to retrieve Beans before the Container is started, non-portable behaviour results!");
        }
        if ((result = bmi.finalBm) == null) {
            BeanManagerProvider beanManagerProvider = this;
            synchronized (beanManagerProvider) {
                result = bmi.finalBm;
                if (result == null) {
                    result = this.resolveBeanManagerViaJndi();
                    if (result == null) {
                        result = bmi.loadTimeBm;
                    }
                    if (result == null) {
                        throw new IllegalStateException("Unable to find BeanManager. Please ensure that you configured the CDI implementation of your choice properly.");
                    }
                    bmi.finalBm = result;
                }
            }
        }
        return result;
    }

    public static ClassLoader getClassLoader(Object o) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new GetClassLoaderAction(o));
        }
        return BeanManagerProvider.getClassLoaderInternal(o);
    }

    private static ClassLoader getClassLoaderInternal(Object o) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null && o != null) {
            loader = o.getClass().getClassLoader();
        }
        if (loader == null) {
            loader = BeanManagerProvider.class.getClassLoader();
        }
        return loader;
    }

    public void cleanupFinalBeanManagers(@Observes AfterDeploymentValidation adv) {
        for (BeanManagerInfo bmi : BeanManagerProvider.bmpSingleton.bmInfos.values()) {
            bmi.finalBm = null;
            bmi.booted = true;
        }
    }

    public void cleanupStoredBeanManagerOnShutdown(@Observes BeforeShutdown beforeShutdown) {
        if (bmpSingleton == null) {
            return;
        }
        ClassLoader classLoader = BeanManagerProvider.getClassLoader(null);
        BeanManagerProvider.bmpSingleton.bmInfos.remove(classLoader);
    }

    private BeanManager resolveBeanManagerViaJndi() {
        try {
            return (BeanManager)new InitialContext().lookup("java:comp/BeanManager");
        }
        catch (NamingException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BeanManagerInfo getBeanManagerInfo(ClassLoader cl) {
        BeanManagerInfo bmi = BeanManagerProvider.bmpSingleton.bmInfos.get(cl);
        if (bmi == null) {
            BeanManagerProvider beanManagerProvider = this;
            synchronized (beanManagerProvider) {
                bmi = BeanManagerProvider.bmpSingleton.bmInfos.get(cl);
                if (bmi == null) {
                    bmi = new BeanManagerInfo();
                    BeanManagerProvider.bmpSingleton.bmInfos.put(cl, bmi);
                }
            }
        }
        return bmi;
    }

    private static BeanManagerProvider setBeanManagerProvider(BeanManagerProvider beanManagerProvider) {
        if (bmpSingleton == null) {
            bmpSingleton = beanManagerProvider;
        }
        return bmpSingleton;
    }

    private static class BeanManagerInfo {
        private BeanManager loadTimeBm = null;
        private BeanManager finalBm = null;
        private boolean booted = false;

        private BeanManagerInfo() {
        }
    }

    static class GetClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        private Object object;

        GetClassLoaderAction(Object object) {
            this.object = object;
        }

        @Override
        public ClassLoader run() {
            try {
                return BeanManagerProvider.getClassLoaderInternal(this.object);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

