/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.Callable;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.command.shell.Shell;
import org.aesh.io.Resource;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.impl.ExitCodeResultHandler;
import org.infinispan.cli.logging.Messages;
import org.infinispan.commons.util.StringPropertyReplacer;

@CommandDefinition(name="run", description="Reads and executes commands from one or more files", resultHandler=ExitCodeResultHandler.class)
public class Run
extends CliCommand {
    @Arguments(required=true, completer=FileOptionCompleter.class)
    private List<Resource> arguments;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) throws CommandException {
        if (this.arguments != null && this.arguments.size() > 0) {
            for (Resource resource : this.arguments) {
                boolean stdin = "-".equals(resource.getName());
                if (stdin) {
                    Shell shell = invocation.getShell();
                    this.processInput("<STDIN>", () -> ((Shell)shell).readLine(), invocation);
                    continue;
                }
                try (BufferedReader br = new BufferedReader(new InputStreamReader(resource.read()));){
                    this.processInput(resource.getAbsolutePath(), br::readLine, invocation);
                }
                catch (IOException e) {
                    throw Messages.MSG.batchError(resource.getAbsolutePath(), 0, "", e);
                }
            }
        }
        return CommandResult.SUCCESS;
    }

    private void processInput(String source, Callable<String> lineSupplier, ContextAwareCommandInvocation invocation) throws CommandException {
        int lineCount = 0;
        String line = null;
        try {
            line = lineSupplier.call();
            while (line != null) {
                ++lineCount;
                if (!line.startsWith("#")) {
                    invocation.executeCommand("batch " + StringPropertyReplacer.replaceProperties((String)line));
                }
                line = lineSupplier.call();
            }
        }
        catch (Throwable e) {
            throw Messages.MSG.batchError(source, lineCount, line, e);
        }
    }
}

