/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.io.File;
import java.util.concurrent.CompletionStage;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.completers.CacheConfigurationCompleter;
import org.infinispan.cli.completers.CounterStorageCompleter;
import org.infinispan.cli.completers.CounterTypeCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;
import org.infinispan.client.rest.RestCacheClient;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;

@GroupCommandDefinition(name="create", description="Creates a cache or a counter", activator=ConnectionActivator.class, groupCommands={Cache.class, Counter.class})
public class Create
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        invocation.println(invocation.getHelpInfo());
        return CommandResult.FAILURE;
    }

    @CommandDefinition(name="counter", description="Create a counter", activator=ConnectionActivator.class)
    public static class Counter
    extends RestCliCommand {
        @Argument(required=true)
        String name;
        @Option(shortName=116, defaultValue={""}, completer=CounterTypeCompleter.class, description="Type of counter [weak|strong]")
        String type;
        @Option(shortName=105, name="initial-value", defaultValue={"0"}, description="Initial value for the counter (defaults to 0)")
        Long initialValue;
        @Option(shortName=115, defaultValue={"VOLATILE"}, completer=CounterStorageCompleter.class, description="persistent state PERSISTENT | VOLATILE (default)")
        String storage;
        @Option(shortName=117, name="upper-bound")
        Long upperBound;
        @Option(shortName=108, name="lower-bound")
        Long lowerBound;
        @Option(shortName=99, name="concurrency-level", defaultValue={"16"}, description="concurrency level for weak counters, defaults to 16")
        Integer concurrencyLevel;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) {
            Json counterBody = Json.object().set("initial-value", (Object)this.initialValue).set("concurrency-level", (Object)this.concurrencyLevel).set("storage", (Object)this.storage);
            if (this.upperBound != null) {
                counterBody.set("upper-bound", (Object)this.upperBound);
            }
            if (this.lowerBound != null) {
                counterBody.set("lower-bound", (Object)this.lowerBound);
            }
            Json counter = Json.object().set(this.type + "-counter", counterBody);
            return client.counter(this.name).create(RestEntity.create((MediaType)MediaType.APPLICATION_JSON, (String)counter.toString()));
        }
    }

    @CommandDefinition(name="cache", description="Create a cache", activator=ConnectionActivator.class)
    public static class Cache
    extends RestCliCommand {
        @Argument(required=true)
        String name;
        @Option(completer=CacheConfigurationCompleter.class, shortName=116)
        String template;
        @Option(completer=FileOptionCompleter.class, shortName=102)
        Resource file;
        @Option(defaultValue={"false"}, name="volatile", shortName=118)
        boolean volatileCache;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, org.infinispan.cli.resources.Resource resource) {
            CacheContainerAdmin.AdminFlag[] flags;
            CacheContainerAdmin.AdminFlag[] adminFlagArray;
            if (this.template != null && this.file != null) {
                throw Messages.MSG.mutuallyExclusiveOptions("template", "file");
            }
            if (this.template == null && this.file == null) {
                throw Messages.MSG.requiresOneOf("template", "file");
            }
            RestCacheClient cache = client.cache(this.name);
            if (this.volatileCache) {
                CacheContainerAdmin.AdminFlag[] adminFlagArray2 = new CacheContainerAdmin.AdminFlag[1];
                adminFlagArray = adminFlagArray2;
                adminFlagArray2[0] = CacheContainerAdmin.AdminFlag.VOLATILE;
            } else {
                adminFlagArray = flags = new CacheContainerAdmin.AdminFlag[]{};
            }
            if (this.template != null) {
                return cache.createWithTemplate(this.template, flags);
            }
            return cache.createWithConfiguration(RestEntity.create((File)new File(this.file.getAbsolutePath())), flags);
        }
    }
}

