package org.infinispan.cli.logging;

import java.util.Locale;
import java.nio.file.Path;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import javax.annotation.Generated;
import org.infinispan.cli.patching.PatchInfo;
import java.lang.SecurityException;
import java.lang.String;
import java.io.IOException;
import org.infinispan.cli.user.UserTool.Encryption;
import org.aesh.command.CommandException;
import java.lang.Exception;
import java.lang.RuntimeException;
import org.aesh.command.parser.RequiredOptionException;
import org.infinispan.cli.patching.PatchOperation;
import java.lang.Throwable;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.util.NoSuchElementException;
import java.net.ConnectException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2022-04-29T05:14:48-0400")
public class Messages_$bundle implements Messages, Serializable {
    private static final long serialVersionUID = 1L;
    protected Messages_$bundle() {}
    public static final Messages_$bundle INSTANCE = new Messages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String username = "Username: ";
    protected String username$str() {
        return username;
    }
    @Override
    public final String username() {
        return String.format(getLoggingLocale(), username$str());
    }
    private static final String password = "Password: ";
    protected String password$str() {
        return password;
    }
    @Override
    public final String password() {
        return String.format(getLoggingLocale(), password$str());
    }
    private static final String notFound = "Not Found: %s";
    protected String notFound$str() {
        return notFound;
    }
    @Override
    public final IOException notFound(final String s) {
        final IOException result = new IOException(String.format(getLoggingLocale(), notFound$str(), s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unauthorized = "The supplied credentials are invalid %s";
    protected String unauthorized$str() {
        return unauthorized;
    }
    @Override
    public final AccessDeniedException unauthorized(final String s) {
        final AccessDeniedException result = new AccessDeniedException(String.format(getLoggingLocale(), unauthorized$str(), s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String error = "Error: %s";
    protected String error$str() {
        return error;
    }
    @Override
    public final IOException error(final String s) {
        final IOException result = new IOException(String.format(getLoggingLocale(), error$str(), s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String forbidden = "The user is not allowed to access the server resource: %s";
    protected String forbidden$str() {
        return forbidden;
    }
    @Override
    public final AccessDeniedException forbidden(final String s) {
        final AccessDeniedException result = new AccessDeniedException(String.format(getLoggingLocale(), forbidden$str(), s));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String keyStoreError = "Error while loading trust store '%s'";
    protected String keyStoreError$str() {
        return keyStoreError;
    }
    @Override
    public final String keyStoreError(final String trustStorePath, final Exception e) {
        return String.format(getLoggingLocale(), keyStoreError$str(), trustStorePath);
    }
    private static final String noSuchResource = "No such resource '%s'";
    protected String noSuchResource$str() {
        return noSuchResource;
    }
    @Override
    public final IllegalArgumentException noSuchResource(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noSuchResource$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalContext = "Command invoked from the wrong context";
    protected String illegalContext$str() {
        return illegalContext;
    }
    @Override
    public final IllegalStateException illegalContext() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalCommandArguments = "Illegal arguments for command";
    protected String illegalCommandArguments$str() {
        return illegalCommandArguments;
    }
    @Override
    public final IllegalArgumentException illegalCommandArguments() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalCommandArguments$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mutuallyExclusiveOptions = "The options '%s' and '%s' are mutually exclusive";
    protected String mutuallyExclusiveOptions$str() {
        return mutuallyExclusiveOptions;
    }
    @Override
    public final IllegalArgumentException mutuallyExclusiveOptions(final String arg1, final String arg2) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mutuallyExclusiveOptions$str(), arg1, arg2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiresOneOf = "One of the '%s' and '%s' options are required";
    protected String requiresOneOf$str() {
        return requiresOneOf;
    }
    @Override
    public final RequiredOptionException requiresOneOf(final String arg1, final String arg2) {
        final RequiredOptionException result = new RequiredOptionException(String.format(getLoggingLocale(), requiresOneOf$str(), arg1, arg2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String connectionFailed = "Could not connect to server: %s";
    protected String connectionFailed$str() {
        return connectionFailed;
    }
    @Override
    public final ConnectException connectionFailed(final String message) {
        final ConnectException result = new ConnectException(String.format(getLoggingLocale(), connectionFailed$str(), message));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidResource = "Invalid resource '%s'";
    protected String invalidResource$str() {
        return invalidResource;
    }
    @Override
    public final IllegalArgumentException invalidResource(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidResource$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchNoPatchesInstalled = "No patches installed";
    protected String patchNoPatchesInstalled$str() {
        return patchNoPatchesInstalled;
    }
    @Override
    public final String patchNoPatchesInstalled() {
        return String.format(getLoggingLocale(), patchNoPatchesInstalled$str());
    }
    private static final String patchInfo = "%s";
    protected String patchInfo$str() {
        return patchInfo;
    }
    @Override
    public final String patchInfo(final PatchInfo patchInfo) {
        return String.format(getLoggingLocale(), patchInfo$str(), patchInfo);
    }
    private static final String patchCannotApply = "The supplied patch cannot be applied to %s %s";
    protected String patchCannotApply$str() {
        return patchCannotApply;
    }
    @Override
    public final IllegalStateException patchCannotApply(final String brandName, final String version) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchCannotApply$str(), brandName, version));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchShaMismatch = "File %s SHA mismatch. Expected = %s, Actual = %s";
    protected String patchShaMismatch$str() {
        return patchShaMismatch;
    }
    @Override
    public final String patchShaMismatch(final Path path, final String digest, final String sha256) {
        return String.format(getLoggingLocale(), patchShaMismatch$str(), path, digest, sha256);
    }
    private static final String patchValidationErrors = "The following errors were encountered while validating the installation:%n%s";
    protected String patchValidationErrors$str() {
        return patchValidationErrors;
    }
    @Override
    public final IllegalStateException patchValidationErrors(final String errors) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchValidationErrors$str(), errors));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchNoPatchesInstalledToRollback = "No installed patches to roll back";
    protected String patchNoPatchesInstalledToRollback$str() {
        return patchNoPatchesInstalledToRollback;
    }
    @Override
    public final IllegalStateException patchNoPatchesInstalledToRollback() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchNoPatchesInstalledToRollback$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchCannotFindCommons = "Cannot find the infinispan-commons jar under %s";
    protected String patchCannotFindCommons$str() {
        return patchCannotFindCommons;
    }
    @Override
    public final IllegalStateException patchCannotFindCommons(final Path lib) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchCannotFindCommons$str(), lib));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchIncompatibleProduct = "Cannot create patch %s with patches for %s";
    protected String patchIncompatibleProduct$str() {
        return patchIncompatibleProduct;
    }
    @Override
    public final IllegalStateException patchIncompatibleProduct(final String localBrand, final String patchBrand) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchIncompatibleProduct$str(), localBrand, patchBrand));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchCannotWritePatchesFile = "Could not write patches file";
    protected String patchCannotWritePatchesFile$str() {
        return patchCannotWritePatchesFile;
    }
    @Override
    public final IllegalStateException patchCannotWritePatchesFile(final IOException e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchCannotWritePatchesFile$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchRollback = "Rolled back patch %s";
    protected String patchRollback$str() {
        return patchRollback;
    }
    @Override
    public final String patchRollback(final PatchInfo patchInfo) {
        return String.format(getLoggingLocale(), patchRollback$str(), patchInfo);
    }
    private static final String patchDryRun = "[Dry run] ";
    protected String patchDryRun$str() {
        return patchDryRun;
    }
    @Override
    public final String patchDryRun() {
        return String.format(getLoggingLocale(), patchDryRun$str());
    }
    private static final String patchBackup = "Backing up '%s' to '%s'";
    protected String patchBackup$str() {
        return patchBackup;
    }
    @Override
    public final String patchBackup(final Path from, final Path to) {
        return String.format(getLoggingLocale(), patchBackup$str(), from, to);
    }
    private static final String patchCreateError = "Error while creating patch";
    protected String patchCreateError$str() {
        return patchCreateError;
    }
    @Override
    public final RuntimeException patchCreateError(final IOException e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), patchCreateError$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchCreateAdd = "Adding file '%s'";
    protected String patchCreateAdd$str() {
        return patchCreateAdd;
    }
    @Override
    public final String patchCreateAdd(final Path target) {
        return String.format(getLoggingLocale(), patchCreateAdd$str(), target);
    }
    private static final String patchRollbackFile = "Rolling back file '%s'";
    protected String patchRollbackFile$str() {
        return patchRollbackFile;
    }
    @Override
    public final String patchRollbackFile(final Path file) {
        return String.format(getLoggingLocale(), patchRollbackFile$str(), file);
    }
    private static final String patchCannotRead = "Could not read %s";
    protected String patchCannotRead$str() {
        return patchCannotRead;
    }
    @Override
    public final IllegalStateException patchCannotRead(final Path patchesFile, final IOException e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchCannotRead$str(), patchesFile), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchFileAlreadyExists = "File '%s' already exists";
    protected String patchFileAlreadyExists$str() {
        return patchFileAlreadyExists;
    }
    @Override
    public final FileAlreadyExistsException patchFileAlreadyExists(final Path patch) {
        final FileAlreadyExistsException result = new FileAlreadyExistsException(String.format(getLoggingLocale(), patchFileAlreadyExists$str(), patch));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchCreateArgumentsRequired = "At least three arguments are required: the patch file, the target server path and one or more source server paths";
    protected String patchCreateArgumentsRequired$str() {
        return patchCreateArgumentsRequired;
    }
    @Override
    public final IllegalArgumentException patchCreateArgumentsRequired() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), patchCreateArgumentsRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchArchiveArgumentRequired = "You must specify the path to a patch archive";
    protected String patchArchiveArgumentRequired$str() {
        return patchArchiveArgumentRequired;
    }
    @Override
    public final IllegalArgumentException patchArchiveArgumentRequired() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), patchArchiveArgumentRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchServerAndTargetMustBeDifferent = "Cannot create a patch from identical source and target server versions: %s";
    protected String patchServerAndTargetMustBeDifferent$str() {
        return patchServerAndTargetMustBeDifferent;
    }
    @Override
    public final IllegalArgumentException patchServerAndTargetMustBeDifferent(final String version) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), patchServerAndTargetMustBeDifferent$str(), version));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchCorruptArchive = "The patch archive appears to have a corrupt entry for: %s";
    protected String patchCorruptArchive$str() {
        return patchCorruptArchive;
    }
    @Override
    public final String patchCorruptArchive(final PatchOperation operation) {
        return String.format(getLoggingLocale(), patchCorruptArchive$str(), operation);
    }
    private static final String downloadedFile = "Downloaded file '%s'";
    protected String downloadedFile$str() {
        return downloadedFile;
    }
    @Override
    public final String downloadedFile(final String filename) {
        return String.format(getLoggingLocale(), downloadedFile$str(), filename);
    }
    private static final String userToolUsername = "Specify a username: ";
    protected String userToolUsername$str() {
        return userToolUsername;
    }
    @Override
    public final String userToolUsername() {
        return String.format(getLoggingLocale(), userToolUsername$str());
    }
    private static final String userToolPassword = "Set a password for the user: ";
    protected String userToolPassword$str() {
        return userToolPassword;
    }
    @Override
    public final String userToolPassword() {
        return String.format(getLoggingLocale(), userToolPassword$str());
    }
    private static final String userToolPasswordConfirm = "Confirm the password for the user: ";
    protected String userToolPasswordConfirm$str() {
        return userToolPasswordConfirm;
    }
    @Override
    public final String userToolPasswordConfirm() {
        return String.format(getLoggingLocale(), userToolPasswordConfirm$str());
    }
    private static final String userToolUserExists = "User `%s` already exists";
    protected String userToolUserExists$str() {
        return userToolUserExists;
    }
    @Override
    public final IllegalStateException userToolUserExists(final String username) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), userToolUserExists$str(), username));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String userToolIOError = "Error accessing file '%s'";
    protected String userToolIOError$str() {
        return userToolIOError;
    }
    @Override
    public final RuntimeException userToolIOError(final Path path, final IOException e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), userToolIOError$str(), path), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String userToolUnknownAlgorithm = "Unkown password encryption algorithm: '%s'";
    protected String userToolUnknownAlgorithm$str() {
        return userToolUnknownAlgorithm;
    }
    @Override
    public final IllegalArgumentException userToolUnknownAlgorithm(final String algorithm) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), userToolUnknownAlgorithm$str(), algorithm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String userToolNoSuchUser = "User `%s` does not exist";
    protected String userToolNoSuchUser$str() {
        return userToolNoSuchUser;
    }
    @Override
    public final IllegalArgumentException userToolNoSuchUser(final String username) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), userToolNoSuchUser$str(), username));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String userDescribe = "{ username: \"%s\", realm: \"%s\", groups = %s }";
    protected String userDescribe$str() {
        return userDescribe;
    }
    @Override
    public final String userDescribe(final String username, final String realm, final String[] userGroups) {
        return String.format(getLoggingLocale(), userDescribe$str(), username, realm, Arrays.toString(userGroups));
    }
    private static final String invalidUnicodeSequence = "Invalid Unicode sequence '%s'";
    protected String invalidUnicodeSequence$str() {
        return invalidUnicodeSequence;
    }
    @Override
    public final IOException invalidUnicodeSequence(final String sequence, final NoSuchElementException e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidUnicodeSequence$str(), sequence), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String userToolIncompatibleEncrypyion = "Attempt to use %s passwords, but only %s passwords are allowed";
    protected String userToolIncompatibleEncrypyion$str() {
        return userToolIncompatibleEncrypyion;
    }
    @Override
    public final IllegalArgumentException userToolIncompatibleEncrypyion(final Encryption encryption1, final Encryption encryption2) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), userToolIncompatibleEncrypyion$str(), encryption1, encryption2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String userToolWrongRealm = "Attempted to use a different realm '%s' than the already existing one '%s'";
    protected String userToolWrongRealm$str() {
        return userToolWrongRealm;
    }
    @Override
    public final IllegalArgumentException userToolWrongRealm(final String realm1, final String realm2) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), userToolWrongRealm$str(), realm1, realm2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String configLoadFailed = "Unable to load CLI configuration from `%s`. Using defaults.";
    protected String configLoadFailed$str() {
        return configLoadFailed;
    }
    @Override
    public final String configLoadFailed(final String path) {
        return String.format(getLoggingLocale(), configLoadFailed$str(), path);
    }
    private static final String configStoreFailed = "Unable to store CLI configuration to '%s'.";
    protected String configStoreFailed$str() {
        return configStoreFailed;
    }
    @Override
    public final String configStoreFailed(final String path) {
        return String.format(getLoggingLocale(), configStoreFailed$str(), path);
    }
    private static final String wrongArgumentCount = "Wrong argument count: %d.";
    protected String wrongArgumentCount$str() {
        return wrongArgumentCount;
    }
    @Override
    public final IllegalArgumentException wrongArgumentCount(final int size) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), wrongArgumentCount$str(), size));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchService = "Cannot find service '%s' in namespace '%s'";
    protected String noSuchService$str() {
        return noSuchService;
    }
    @Override
    public final IllegalArgumentException noSuchService(final String serviceName, final String namespace) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noSuchService$str(), serviceName, namespace));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noGeneratedSecret = "Cannot find or access generated secrets for service '%s'";
    protected String noGeneratedSecret$str() {
        return noGeneratedSecret;
    }
    @Override
    public final IllegalStateException noGeneratedSecret(final String serviceName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noGeneratedSecret$str(), serviceName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDefaultNamespace = "A namespace was not specified and a default has not been set";
    protected String noDefaultNamespace$str() {
        return noDefaultNamespace;
    }
    @Override
    public final IllegalStateException noDefaultNamespace() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noDefaultNamespace$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialToolPassword = "Enter the password for the credential keystore: ";
    protected String credentialToolPassword$str() {
        return credentialToolPassword;
    }
    @Override
    public final String credentialToolPassword() {
        return String.format(getLoggingLocale(), credentialToolPassword$str());
    }
    private static final String credentialToolPasswordConfirm = "Confirm the password for the credential store: ";
    protected String credentialToolPasswordConfirm$str() {
        return credentialToolPasswordConfirm;
    }
    @Override
    public final String credentialToolPasswordConfirm() {
        return String.format(getLoggingLocale(), credentialToolPasswordConfirm$str());
    }
    private static final String credentialToolCredential = "Set a credential for the alias: ";
    protected String credentialToolCredential$str() {
        return credentialToolCredential;
    }
    @Override
    public final String credentialToolCredential() {
        return String.format(getLoggingLocale(), credentialToolCredential$str());
    }
    private static final String credentialToolCredentialConfirm = "Confirm the credential: ";
    protected String credentialToolCredentialConfirm$str() {
        return credentialToolCredentialConfirm;
    }
    @Override
    public final String credentialToolCredentialConfirm() {
        return String.format(getLoggingLocale(), credentialToolCredentialConfirm$str());
    }
    private static final String illegalFilterRule = "Filter rule '%s' is not in the format [ACCEPT|REJECT]/{CIDR}";
    protected String illegalFilterRule$str() {
        return illegalFilterRule;
    }
    @Override
    public final IllegalArgumentException illegalFilterRule(final String rule) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalFilterRule$str(), rule));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String batchError = "Error executing line %d: '%s'";
    protected String batchError$str() {
        return batchError;
    }
    @Override
    public final CommandException batchError(final int lineNumber, final String line, final Throwable t) {
        final CommandException result = new CommandException(String.format(getLoggingLocale(), batchError$str(), lineNumber, line), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiresAllOf = "Option '%s' requires option '%s'";
    protected String requiresAllOf$str() {
        return requiresAllOf;
    }
    @Override
    public final RequiredOptionException requiresAllOf(final String option1, final String option2) {
        final RequiredOptionException result = new RequiredOptionException(String.format(getLoggingLocale(), requiresAllOf$str(), option1, option2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingCacheName = "The cache name is required";
    protected String missingCacheName$str() {
        return missingCacheName;
    }
    @Override
    public final IllegalArgumentException missingCacheName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingCacheName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noCatalog = "Could not determine catalog source";
    protected String noCatalog$str() {
        return noCatalog;
    }
    @Override
    public final IllegalStateException noCatalog() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noCatalog$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noTargetNamespaces = "Target namespaces must be specified when not installing globally";
    protected String noTargetNamespaces$str() {
        return noTargetNamespaces;
    }
    @Override
    public final IllegalArgumentException noTargetNamespaces() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noTargetNamespaces$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDefaultOperatorNamespace = "Could not find a default operator namespace";
    protected String noDefaultOperatorNamespace$str() {
        return noDefaultOperatorNamespace;
    }
    @Override
    public final IllegalStateException noDefaultOperatorNamespace() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noDefaultOperatorNamespace$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noKubernetes = "Kubernetes client is unavailable in this mode";
    protected String noKubernetes$str() {
        return noKubernetes;
    }
    @Override
    public final IllegalStateException noKubernetes() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noKubernetes$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noOperatorSubscription = "Could not find an operator subscription in namespace '%s'";
    protected String noOperatorSubscription$str() {
        return noOperatorSubscription;
    }
    @Override
    public final IllegalStateException noOperatorSubscription(final String namespace) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noOperatorSubscription$str(), namespace));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String exposeTypeRequiresPort = "Expose type '%s' requires a port";
    protected String exposeTypeRequiresPort$str() {
        return exposeTypeRequiresPort;
    }
    @Override
    public final IllegalArgumentException exposeTypeRequiresPort(final String exposeType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), exposeTypeRequiresPort$str(), exposeType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String encryptionTypeRequiresSecret = "Encryption type '%s' requires a secret name";
    protected String encryptionTypeRequiresSecret$str() {
        return encryptionTypeRequiresSecret;
    }
    @Override
    public final IllegalArgumentException encryptionTypeRequiresSecret(final String encryptionType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), encryptionTypeRequiresSecret$str(), encryptionType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noRunningPodsInService = "No running pods available in service %s";
    protected String noRunningPodsInService$str() {
        return noRunningPodsInService;
    }
    @Override
    public final IllegalStateException noRunningPodsInService(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noRunningPodsInService$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String usernameRequired = "A username must be specified";
    protected String usernameRequired$str() {
        return usernameRequired;
    }
    @Override
    public final IllegalArgumentException usernameRequired() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), usernameRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String checksumFailed = "Checksum for '%s' does not match. Supplied: %s Actual: %s";
    protected String checksumFailed$str() {
        return checksumFailed;
    }
    @Override
    public final SecurityException checksumFailed(final String path, final String checksum, final String computed) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), checksumFailed$str(), path, checksum, computed));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String checksumVerified = "Checksum for '%s' verified";
    protected String checksumVerified$str() {
        return checksumVerified;
    }
    @Override
    public final String checksumVerified(final String path) {
        return String.format(getLoggingLocale(), checksumVerified$str(), path);
    }
    private static final String artifactNotFound = "Artifact '%s' not found";
    protected String artifactNotFound$str() {
        return artifactNotFound;
    }
    @Override
    public final IllegalArgumentException artifactNotFound(final String path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), artifactNotFound$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String retryDownload = "Retry download '%d/%d'";
    protected String retryDownload$str() {
        return retryDownload;
    }
    @Override
    public final String retryDownload(final int retry, final int retries) {
        return String.format(getLoggingLocale(), retryDownload$str(), retry, retries);
    }
}
