/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import org.infinispan.cli.artifacts.MavenSettings;
import org.infinispan.commons.util.Util;

public class Utils {
    public static final int BUFFER_SIZE = 8192;

    public static String sha256(Path path) {
        return Utils.digest(path, "SHA-256");
    }

    public static String digest(Path path, String algorithm) {
        String string;
        block12: {
            SeekableByteChannel channel = Files.newByteChannel(path, StandardOpenOption.READ);
            try {
                MessageDigest digest = MessageDigest.getInstance(algorithm);
                if (channel instanceof FileChannel) {
                    FileChannel fileChannel = (FileChannel)channel;
                    MappedByteBuffer byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
                    digest.update(byteBuffer);
                } else {
                    ByteBuffer bb = ByteBuffer.allocate(8192);
                    while (channel.read(bb) != -1) {
                        bb.flip();
                        digest.update(bb);
                        bb.flip();
                    }
                }
                string = Util.toHexString((byte[])digest.digest());
                if (channel == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    return null;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            channel.close();
        }
        return string;
    }

    public static Path downloadFile(URL url, Path dest, boolean verbose, boolean force) throws IOException {
        HttpURLConnection connection;
        int statusCode;
        if (Files.exists(dest, new LinkOption[0])) {
            if (force) {
                Files.delete(dest);
                if (verbose) {
                    System.out.printf("Deleting previously downloaded '%s' for '%s'%n", dest, url);
                }
            } else {
                if (verbose) {
                    System.out.printf("Using previously downloaded '%s' for '%s'%n", dest, url);
                }
                return dest;
            }
        }
        if ((statusCode = (connection = (HttpURLConnection)MavenSettings.getSettings().openConnection(url)).getResponseCode()) == 404) {
            if (verbose) {
                System.out.printf("'%s' not found%n", url);
            }
            return null;
        }
        if (statusCode == 302 || statusCode == 301) {
            url = new URL(connection.getHeaderField("Location"));
            dest = dest.resolveSibling(Utils.getFilenameFromURL(url));
            connection = (HttpURLConnection)url.openConnection();
        }
        try (InputStream bis = connection.getInputStream();){
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            Files.copy(bis, dest, StandardCopyOption.REPLACE_EXISTING);
            if (verbose) {
                System.out.printf("Downloaded '%s' to '%s'%n", url, dest);
            }
            Path path = dest;
            return path;
        }
    }

    public static String getFilenameFromURL(URL url) {
        String urlPath = url.getPath();
        return urlPath.substring(urlPath.lastIndexOf(47) + 1);
    }
}

